/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.BookieServiceInfoUtils;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Versioned;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Evolving
public interface RegistrationClient
extends AutoCloseable {
    @Override
    public void close();

    public CompletableFuture<Versioned<Set<BookieSocketAddress>>> getWritableBookies();

    public CompletableFuture<Versioned<Set<BookieSocketAddress>>> getAllBookies();

    public CompletableFuture<Versioned<Set<BookieSocketAddress>>> getReadOnlyBookies();

    default public CompletableFuture<Versioned<BookieServiceInfo>> getBookieServiceInfo(String bookieId) {
        try {
            BookieServiceInfo bookieServiceInfo = BookieServiceInfoUtils.buildLegacyBookieServiceInfo(bookieId);
            return FutureUtils.value(new Versioned<BookieServiceInfo>(bookieServiceInfo, new LongVersion(-1L)));
        }
        catch (UnknownHostException e) {
            return FutureUtils.exception((Throwable)e);
        }
    }

    public CompletableFuture<Void> watchWritableBookies(RegistrationListener var1);

    public void unwatchWritableBookies(RegistrationListener var1);

    public CompletableFuture<Void> watchReadOnlyBookies(RegistrationListener var1);

    public void unwatchReadOnlyBookies(RegistrationListener var1);

    public static interface RegistrationListener {
        public void onBookiesChanged(Versioned<Set<BookieSocketAddress>> var1);
    }
}

