---
title: "Attributes of a Beam community member"
layout: "arrow_template"
---

<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Attributes of a Beam community member

{{< figure src="/images/community/beam-logo-icon.svg" >}}

## Knows, upholds, and reinforces the Beam community’s practices

- They have a proven commitment to the project
- They share their intentions with the community
- They accept and integrate community feedback in their plans, designs, code, etc.
- They earnestly try to make Beam better with their contributions

In particular, if a code contributor:

- They earnestly try to make Beam better with their own code
- They earnestly try to make Beam better with code review
- They accept and integrate feedback on their code
- They know, follow, and enforce Beam’s practices while reviewing/merging code - style, documentation, testing, backward compatibility, etc.

{{< figure src="/images/community/messages-icon.svg" >}}

## Knows, upholds, and reinforces the Apache Software Foundation code of conduct

In particular, we manifestly strive to:

- Be open
- Be empathetic
- Be welcoming
- Be friendly
- Be patient
- Be collaborative
- Be inquisitive
- Be careful in the words that they choose

[To learn more see the ASF documentation.](https://httpd.apache.org/docs/)

{{< figure src="/images/community/diamond-icon.svg" >}}

## Knows, upholds, and reinforces the responsibilities of an Apache Software Foundation committer

- They help create a product that will outlive the interest of any particular volunteer (including themselves)
- They grow and maintain the health of the Apache community
- They help out with surrounding work, such as the website & documentation
- They help users
- They can be trusted to decide when code is ready for release, or when to ask someone else to make the judgment
- They can be trusted to decide when to merge code (if a code contributor) or when to ask someone else to make the judgment

[To learn more see the ASF documentation.](https://httpd.apache.org/docs/)
