//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Protocol Buffers describing the Artifact API, for communicating with a runner
// for artifact staging and retrieval over GRPC.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: beam_artifact_api.proto

package jobmanagement_v1

import (
	context "context"
	pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CommitManifestResponse_Constants int32

const (
	// Token indicating that no artifacts were staged and therefore no retrieval attempt is necessary.
	CommitManifestResponse_NO_ARTIFACTS_STAGED_TOKEN CommitManifestResponse_Constants = 0
)

// Enum value maps for CommitManifestResponse_Constants.
var (
	CommitManifestResponse_Constants_name = map[int32]string{
		0: "NO_ARTIFACTS_STAGED_TOKEN",
	}
	CommitManifestResponse_Constants_value = map[string]int32{
		"NO_ARTIFACTS_STAGED_TOKEN": 0,
	}
)

func (x CommitManifestResponse_Constants) Enum() *CommitManifestResponse_Constants {
	p := new(CommitManifestResponse_Constants)
	*p = x
	return p
}

func (x CommitManifestResponse_Constants) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommitManifestResponse_Constants) Descriptor() protoreflect.EnumDescriptor {
	return file_beam_artifact_api_proto_enumTypes[0].Descriptor()
}

func (CommitManifestResponse_Constants) Type() protoreflect.EnumType {
	return &file_beam_artifact_api_proto_enumTypes[0]
}

func (x CommitManifestResponse_Constants) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommitManifestResponse_Constants.Descriptor instead.
func (CommitManifestResponse_Constants) EnumDescriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{17, 0}
}

// A request for artifact resolution.
type ResolveArtifactsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An (ordered) set of artifacts to (jointly) resolve.
	Artifacts []*pipeline_v1.ArtifactInformation `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	// A set of artifact type urns that are understood by the requester.
	// An attempt should be made to resolve the artifacts in terms of these URNs,
	// but other URNs may be used as well with the understanding that they must
	// be fetch-able as bytes via GetArtifact.
	PreferredUrns []string `protobuf:"bytes,2,rep,name=preferred_urns,json=preferredUrns,proto3" json:"preferred_urns,omitempty"`
}

func (x *ResolveArtifactsRequest) Reset() {
	*x = ResolveArtifactsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveArtifactsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveArtifactsRequest) ProtoMessage() {}

func (x *ResolveArtifactsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveArtifactsRequest.ProtoReflect.Descriptor instead.
func (*ResolveArtifactsRequest) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{0}
}

func (x *ResolveArtifactsRequest) GetArtifacts() []*pipeline_v1.ArtifactInformation {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *ResolveArtifactsRequest) GetPreferredUrns() []string {
	if x != nil {
		return x.PreferredUrns
	}
	return nil
}

// A response for artifact resolution.
type ResolveArtifactsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A full (ordered) set of replacements for the set of requested artifacts,
	// preferably in terms of the requested type URNs.  If there is no better
	// resolution, the original list is returned.
	Replacements []*pipeline_v1.ArtifactInformation `protobuf:"bytes,1,rep,name=replacements,proto3" json:"replacements,omitempty"`
}

func (x *ResolveArtifactsResponse) Reset() {
	*x = ResolveArtifactsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveArtifactsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveArtifactsResponse) ProtoMessage() {}

func (x *ResolveArtifactsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveArtifactsResponse.ProtoReflect.Descriptor instead.
func (*ResolveArtifactsResponse) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{1}
}

func (x *ResolveArtifactsResponse) GetReplacements() []*pipeline_v1.ArtifactInformation {
	if x != nil {
		return x.Replacements
	}
	return nil
}

// A request to get an artifact.
type GetArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Artifact *pipeline_v1.ArtifactInformation `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
}

func (x *GetArtifactRequest) Reset() {
	*x = GetArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetArtifactRequest) ProtoMessage() {}

func (x *GetArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetArtifactRequest.ProtoReflect.Descriptor instead.
func (*GetArtifactRequest) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{2}
}

func (x *GetArtifactRequest) GetArtifact() *pipeline_v1.ArtifactInformation {
	if x != nil {
		return x.Artifact
	}
	return nil
}

// Part of a response to getting an artifact.
type GetArtifactResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *GetArtifactResponse) Reset() {
	*x = GetArtifactResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetArtifactResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetArtifactResponse) ProtoMessage() {}

func (x *GetArtifactResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetArtifactResponse.ProtoReflect.Descriptor instead.
func (*GetArtifactResponse) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{3}
}

func (x *GetArtifactResponse) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Wraps an ArtifactRetrievalService request for use in ReverseArtifactRetrievalService.
type ArtifactRequestWrapper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Request:
	//	*ArtifactRequestWrapper_ResolveArtifact
	//	*ArtifactRequestWrapper_GetArtifact
	Request isArtifactRequestWrapper_Request `protobuf_oneof:"request"`
}

func (x *ArtifactRequestWrapper) Reset() {
	*x = ArtifactRequestWrapper{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactRequestWrapper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactRequestWrapper) ProtoMessage() {}

func (x *ArtifactRequestWrapper) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactRequestWrapper.ProtoReflect.Descriptor instead.
func (*ArtifactRequestWrapper) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{4}
}

func (m *ArtifactRequestWrapper) GetRequest() isArtifactRequestWrapper_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *ArtifactRequestWrapper) GetResolveArtifact() *ResolveArtifactsRequest {
	if x, ok := x.GetRequest().(*ArtifactRequestWrapper_ResolveArtifact); ok {
		return x.ResolveArtifact
	}
	return nil
}

func (x *ArtifactRequestWrapper) GetGetArtifact() *GetArtifactRequest {
	if x, ok := x.GetRequest().(*ArtifactRequestWrapper_GetArtifact); ok {
		return x.GetArtifact
	}
	return nil
}

type isArtifactRequestWrapper_Request interface {
	isArtifactRequestWrapper_Request()
}

type ArtifactRequestWrapper_ResolveArtifact struct {
	ResolveArtifact *ResolveArtifactsRequest `protobuf:"bytes,1000,opt,name=resolve_artifact,json=resolveArtifact,proto3,oneof"`
}

type ArtifactRequestWrapper_GetArtifact struct {
	GetArtifact *GetArtifactRequest `protobuf:"bytes,1001,opt,name=get_artifact,json=getArtifact,proto3,oneof"`
}

func (*ArtifactRequestWrapper_ResolveArtifact) isArtifactRequestWrapper_Request() {}

func (*ArtifactRequestWrapper_GetArtifact) isArtifactRequestWrapper_Request() {}

// Wraps an ArtifactRetrievalService response for use in ReverseArtifactRetrievalService.
type ArtifactResponseWrapper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A token indicating which job these artifacts are being staged for.
	StagingToken string `protobuf:"bytes,1,opt,name=staging_token,json=stagingToken,proto3" json:"staging_token,omitempty"`
	// Whether this is the last response for this request (for those responses that
	// would typically be terminated by the end of the response stream.)
	IsLast bool `protobuf:"varint,2,opt,name=is_last,json=isLast,proto3" json:"is_last,omitempty"`
	// The response itself.
	//
	// Types that are assignable to Response:
	//	*ArtifactResponseWrapper_ResolveArtifactResponse
	//	*ArtifactResponseWrapper_GetArtifactResponse
	Response isArtifactResponseWrapper_Response `protobuf_oneof:"response"`
}

func (x *ArtifactResponseWrapper) Reset() {
	*x = ArtifactResponseWrapper{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactResponseWrapper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactResponseWrapper) ProtoMessage() {}

func (x *ArtifactResponseWrapper) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactResponseWrapper.ProtoReflect.Descriptor instead.
func (*ArtifactResponseWrapper) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{5}
}

func (x *ArtifactResponseWrapper) GetStagingToken() string {
	if x != nil {
		return x.StagingToken
	}
	return ""
}

func (x *ArtifactResponseWrapper) GetIsLast() bool {
	if x != nil {
		return x.IsLast
	}
	return false
}

func (m *ArtifactResponseWrapper) GetResponse() isArtifactResponseWrapper_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *ArtifactResponseWrapper) GetResolveArtifactResponse() *ResolveArtifactsResponse {
	if x, ok := x.GetResponse().(*ArtifactResponseWrapper_ResolveArtifactResponse); ok {
		return x.ResolveArtifactResponse
	}
	return nil
}

func (x *ArtifactResponseWrapper) GetGetArtifactResponse() *GetArtifactResponse {
	if x, ok := x.GetResponse().(*ArtifactResponseWrapper_GetArtifactResponse); ok {
		return x.GetArtifactResponse
	}
	return nil
}

type isArtifactResponseWrapper_Response interface {
	isArtifactResponseWrapper_Response()
}

type ArtifactResponseWrapper_ResolveArtifactResponse struct {
	ResolveArtifactResponse *ResolveArtifactsResponse `protobuf:"bytes,1000,opt,name=resolve_artifact_response,json=resolveArtifactResponse,proto3,oneof"`
}

type ArtifactResponseWrapper_GetArtifactResponse struct {
	GetArtifactResponse *GetArtifactResponse `protobuf:"bytes,1001,opt,name=get_artifact_response,json=getArtifactResponse,proto3,oneof"`
}

func (*ArtifactResponseWrapper_ResolveArtifactResponse) isArtifactResponseWrapper_Response() {}

func (*ArtifactResponseWrapper_GetArtifactResponse) isArtifactResponseWrapper_Response() {}

// An artifact identifier and associated metadata.
type ArtifactMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The name of the artifact.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Optional) The Unix-like permissions of the artifact
	Permissions uint32 `protobuf:"varint,2,opt,name=permissions,proto3" json:"permissions,omitempty"`
	// (Optional) The hex-encoded sha256 checksum of the artifact. Used, among other things, by
	// harness boot code to validate the integrity of the artifact.
	Sha256 string `protobuf:"bytes,4,opt,name=sha256,proto3" json:"sha256,omitempty"`
}

func (x *ArtifactMetadata) Reset() {
	*x = ArtifactMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactMetadata) ProtoMessage() {}

func (x *ArtifactMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactMetadata.ProtoReflect.Descriptor instead.
func (*ArtifactMetadata) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{6}
}

func (x *ArtifactMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ArtifactMetadata) GetPermissions() uint32 {
	if x != nil {
		return x.Permissions
	}
	return 0
}

func (x *ArtifactMetadata) GetSha256() string {
	if x != nil {
		return x.Sha256
	}
	return ""
}

// A collection of artifacts.
type Manifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Artifact []*ArtifactMetadata `protobuf:"bytes,1,rep,name=artifact,proto3" json:"artifact,omitempty"`
}

func (x *Manifest) Reset() {
	*x = Manifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Manifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Manifest) ProtoMessage() {}

func (x *Manifest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Manifest.ProtoReflect.Descriptor instead.
func (*Manifest) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{7}
}

func (x *Manifest) GetArtifact() []*ArtifactMetadata {
	if x != nil {
		return x.Artifact
	}
	return nil
}

// A manifest with location information.
type ProxyManifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Manifest *Manifest                 `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
	Location []*ProxyManifest_Location `protobuf:"bytes,2,rep,name=location,proto3" json:"location,omitempty"`
}

func (x *ProxyManifest) Reset() {
	*x = ProxyManifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProxyManifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyManifest) ProtoMessage() {}

func (x *ProxyManifest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyManifest.ProtoReflect.Descriptor instead.
func (*ProxyManifest) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{8}
}

func (x *ProxyManifest) GetManifest() *Manifest {
	if x != nil {
		return x.Manifest
	}
	return nil
}

func (x *ProxyManifest) GetLocation() []*ProxyManifest_Location {
	if x != nil {
		return x.Location
	}
	return nil
}

// A request to get the manifest of a Job.
type GetManifestRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) An opaque token representing the entirety of the staged artifacts.
	// Returned in CommitManifestResponse.
	RetrievalToken string `protobuf:"bytes,1,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
}

func (x *GetManifestRequest) Reset() {
	*x = GetManifestRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetManifestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetManifestRequest) ProtoMessage() {}

func (x *GetManifestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetManifestRequest.ProtoReflect.Descriptor instead.
func (*GetManifestRequest) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{9}
}

func (x *GetManifestRequest) GetRetrievalToken() string {
	if x != nil {
		return x.RetrievalToken
	}
	return ""
}

// A response containing a job manifest.
type GetManifestResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Manifest *Manifest `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
}

func (x *GetManifestResponse) Reset() {
	*x = GetManifestResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetManifestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetManifestResponse) ProtoMessage() {}

func (x *GetManifestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetManifestResponse.ProtoReflect.Descriptor instead.
func (*GetManifestResponse) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{10}
}

func (x *GetManifestResponse) GetManifest() *Manifest {
	if x != nil {
		return x.Manifest
	}
	return nil
}

// A request to get an artifact. The artifact must be present in the manifest for the job.
type LegacyGetArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The name of the artifact to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Required) An opaque token representing the entirety of the staged artifacts.
	// Returned in CommitManifestResponse.
	RetrievalToken string `protobuf:"bytes,2,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
}

func (x *LegacyGetArtifactRequest) Reset() {
	*x = LegacyGetArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LegacyGetArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LegacyGetArtifactRequest) ProtoMessage() {}

func (x *LegacyGetArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LegacyGetArtifactRequest.ProtoReflect.Descriptor instead.
func (*LegacyGetArtifactRequest) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{11}
}

func (x *LegacyGetArtifactRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LegacyGetArtifactRequest) GetRetrievalToken() string {
	if x != nil {
		return x.RetrievalToken
	}
	return ""
}

// Part of an artifact.
type ArtifactChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *ArtifactChunk) Reset() {
	*x = ArtifactChunk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactChunk) ProtoMessage() {}

func (x *ArtifactChunk) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactChunk.ProtoReflect.Descriptor instead.
func (*ArtifactChunk) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{12}
}

func (x *ArtifactChunk) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

type PutArtifactMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) A token for artifact staging session. This token can be obtained
	// from PrepareJob request in JobService
	StagingSessionToken string `protobuf:"bytes,1,opt,name=staging_session_token,json=stagingSessionToken,proto3" json:"staging_session_token,omitempty"`
	// (Required) The Artifact metadata.
	Metadata *ArtifactMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *PutArtifactMetadata) Reset() {
	*x = PutArtifactMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutArtifactMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutArtifactMetadata) ProtoMessage() {}

func (x *PutArtifactMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutArtifactMetadata.ProtoReflect.Descriptor instead.
func (*PutArtifactMetadata) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{13}
}

func (x *PutArtifactMetadata) GetStagingSessionToken() string {
	if x != nil {
		return x.StagingSessionToken
	}
	return ""
}

func (x *PutArtifactMetadata) GetMetadata() *ArtifactMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// A request to stage an artifact.
type PutArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required)
	//
	// Types that are assignable to Content:
	//	*PutArtifactRequest_Metadata
	//	*PutArtifactRequest_Data
	Content isPutArtifactRequest_Content `protobuf_oneof:"content"`
}

func (x *PutArtifactRequest) Reset() {
	*x = PutArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutArtifactRequest) ProtoMessage() {}

func (x *PutArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutArtifactRequest.ProtoReflect.Descriptor instead.
func (*PutArtifactRequest) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{14}
}

func (m *PutArtifactRequest) GetContent() isPutArtifactRequest_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *PutArtifactRequest) GetMetadata() *PutArtifactMetadata {
	if x, ok := x.GetContent().(*PutArtifactRequest_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (x *PutArtifactRequest) GetData() *ArtifactChunk {
	if x, ok := x.GetContent().(*PutArtifactRequest_Data); ok {
		return x.Data
	}
	return nil
}

type isPutArtifactRequest_Content interface {
	isPutArtifactRequest_Content()
}

type PutArtifactRequest_Metadata struct {
	// The first message in a PutArtifact call must contain this field.
	Metadata *PutArtifactMetadata `protobuf:"bytes,1,opt,name=metadata,proto3,oneof"`
}

type PutArtifactRequest_Data struct {
	// A chunk of the artifact. All messages after the first in a PutArtifact call must contain a
	// chunk.
	Data *ArtifactChunk `protobuf:"bytes,2,opt,name=data,proto3,oneof"`
}

func (*PutArtifactRequest_Metadata) isPutArtifactRequest_Content() {}

func (*PutArtifactRequest_Data) isPutArtifactRequest_Content() {}

type PutArtifactResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PutArtifactResponse) Reset() {
	*x = PutArtifactResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutArtifactResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutArtifactResponse) ProtoMessage() {}

func (x *PutArtifactResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutArtifactResponse.ProtoReflect.Descriptor instead.
func (*PutArtifactResponse) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{15}
}

// A request to commit the manifest for a Job. All artifacts must have been successfully uploaded
// before this call is made.
type CommitManifestRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) The manifest to commit.
	Manifest *Manifest `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
	// (Required) A token for artifact staging session. This token can be obtained
	// from PrepareJob request in JobService
	StagingSessionToken string `protobuf:"bytes,2,opt,name=staging_session_token,json=stagingSessionToken,proto3" json:"staging_session_token,omitempty"`
}

func (x *CommitManifestRequest) Reset() {
	*x = CommitManifestRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitManifestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitManifestRequest) ProtoMessage() {}

func (x *CommitManifestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitManifestRequest.ProtoReflect.Descriptor instead.
func (*CommitManifestRequest) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{16}
}

func (x *CommitManifestRequest) GetManifest() *Manifest {
	if x != nil {
		return x.Manifest
	}
	return nil
}

func (x *CommitManifestRequest) GetStagingSessionToken() string {
	if x != nil {
		return x.StagingSessionToken
	}
	return ""
}

// The result of committing a manifest.
type CommitManifestResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) An opaque token representing the entirety of the staged artifacts.
	// This can be used to retrieve the manifest and artifacts from an associated
	// LegacyArtifactRetrievalService.
	RetrievalToken string `protobuf:"bytes,1,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
}

func (x *CommitManifestResponse) Reset() {
	*x = CommitManifestResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitManifestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitManifestResponse) ProtoMessage() {}

func (x *CommitManifestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitManifestResponse.ProtoReflect.Descriptor instead.
func (*CommitManifestResponse) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{17}
}

func (x *CommitManifestResponse) GetRetrievalToken() string {
	if x != nil {
		return x.RetrievalToken
	}
	return ""
}

type ProxyManifest_Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Uri  string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *ProxyManifest_Location) Reset() {
	*x = ProxyManifest_Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_beam_artifact_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProxyManifest_Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyManifest_Location) ProtoMessage() {}

func (x *ProxyManifest_Location) ProtoReflect() protoreflect.Message {
	mi := &file_beam_artifact_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyManifest_Location.ProtoReflect.Descriptor instead.
func (*ProxyManifest_Location) Descriptor() ([]byte, []int) {
	return file_beam_artifact_api_proto_rawDescGZIP(), []int{8, 0}
}

func (x *ProxyManifest_Location) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProxyManifest_Location) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

var File_beam_artifact_api_proto protoreflect.FileDescriptor

var file_beam_artifact_api_proto_rawDesc = []byte{
	0x0a, 0x17, 0x62, 0x65, 0x61, 0x6d, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f,
	0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x1a, 0x15, 0x62, 0x65, 0x61, 0x6d, 0x5f, 0x72, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x5f,
	0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x96, 0x01, 0x0a, 0x17, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x55, 0x72,
	0x6e, 0x73, 0x22, 0x76, 0x0a, 0x18, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a,
	0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x68, 0x0a, 0x12, 0x47, 0x65,
	0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x52, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x22, 0x29, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22,
	0xf6, 0x01, 0x0a, 0x16, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x12, 0x6e, 0x0a, 0x10, 0x72, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0xe8,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f,
	0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x6c,
	0x76, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x61, 0x0a, 0x0c, 0x67, 0x65,
	0x74, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x0b, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x42, 0x09, 0x0a,
	0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xdb, 0x02, 0x0a, 0x17, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x57, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61,
	0x67, 0x69, 0x6e, 0x67, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x69, 0x73, 0x5f,
	0x6c, 0x61, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x69, 0x73, 0x4c, 0x61,
	0x73, 0x74, 0x12, 0x80, 0x01, 0x0a, 0x19, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x5f, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x18, 0xe8, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x17, 0x72, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x73, 0x0a, 0x15, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0xe9,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f,
	0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x13, 0x67, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x60, 0x0a, 0x10, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x22, 0x61, 0x0a, 0x08, 0x4d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a,
	0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0xed, 0x01, 0x0a, 0x0d,
	0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a,
	0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65,
	0x73, 0x74, 0x52, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x30, 0x0a, 0x08, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0x3d, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x61, 0x6c, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x64, 0x0a, 0x13, 0x47, 0x65,
	0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4d, 0x0a, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x22, 0x57, 0x0a, 0x18, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x47, 0x65, 0x74, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x61, 0x6c, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x23, 0x0a, 0x0d, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa0,
	0x01, 0x0a, 0x13, 0x50, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x55, 0x0a, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0xc9, 0x01, 0x0a, 0x12, 0x50, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x4c, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x15, 0x0a,
	0x13, 0x50, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66,
	0x65, 0x73, 0x74, 0x52, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a,
	0x15, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x74,
	0x61, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x49, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x73, 0x12, 0x3c, 0x0a, 0x19, 0x4e, 0x4f, 0x5f, 0x41, 0x52, 0x54, 0x49, 0x46, 0x41, 0x43,
	0x54, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10,
	0x00, 0x1a, 0x1d, 0xaa, 0xb4, 0xfa, 0xc2, 0x05, 0x17, 0x5f, 0x5f, 0x6e, 0x6f, 0x5f, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x5f,
	0x32, 0xc1, 0x02, 0x0a, 0x18, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x97, 0x01,
	0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x73, 0x12, 0x40, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x6c, 0x76, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8a, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x3b, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x30, 0x01, 0x32, 0xc3, 0x01, 0x0a, 0x16, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x53, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0xa8, 0x01, 0x0a, 0x1f, 0x52, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x40, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x57, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x72, 0x1a, 0x3f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f,
	0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x57,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x28, 0x01, 0x30, 0x01, 0x32, 0xbf, 0x02, 0x0a, 0x1c, 0x4c,
	0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x53, 0x74, 0x61,
	0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8a, 0x01, 0x0a, 0x0b,
	0x50, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x3b, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x75, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x12, 0x91, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xb8, 0x02, 0x0a,
	0x1e, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x88, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12,
	0x3b, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8a, 0x01, 0x0a, 0x0b, 0x47,
	0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x41, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x47, 0x65, 0x74, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x30, 0x01, 0x42, 0x86, 0x01, 0x0a, 0x26, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x6a, 0x6f, 0x62, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x42, 0x0b, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x41, 0x70, 0x69, 0x5a,
	0x4f, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x73, 0x64, 0x6b, 0x73, 0x2f, 0x67, 0x6f, 0x2f,
	0x70, 0x6b, 0x67, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x6a,
	0x6f, 0x62, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x31, 0x3b,
	0x6a, 0x6f, 0x62, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_beam_artifact_api_proto_rawDescOnce sync.Once
	file_beam_artifact_api_proto_rawDescData = file_beam_artifact_api_proto_rawDesc
)

func file_beam_artifact_api_proto_rawDescGZIP() []byte {
	file_beam_artifact_api_proto_rawDescOnce.Do(func() {
		file_beam_artifact_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_beam_artifact_api_proto_rawDescData)
	})
	return file_beam_artifact_api_proto_rawDescData
}

var file_beam_artifact_api_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_beam_artifact_api_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_beam_artifact_api_proto_goTypes = []interface{}{
	(CommitManifestResponse_Constants)(0),   // 0: org.apache.beam.model.job_management.v1.CommitManifestResponse.Constants
	(*ResolveArtifactsRequest)(nil),         // 1: org.apache.beam.model.job_management.v1.ResolveArtifactsRequest
	(*ResolveArtifactsResponse)(nil),        // 2: org.apache.beam.model.job_management.v1.ResolveArtifactsResponse
	(*GetArtifactRequest)(nil),              // 3: org.apache.beam.model.job_management.v1.GetArtifactRequest
	(*GetArtifactResponse)(nil),             // 4: org.apache.beam.model.job_management.v1.GetArtifactResponse
	(*ArtifactRequestWrapper)(nil),          // 5: org.apache.beam.model.job_management.v1.ArtifactRequestWrapper
	(*ArtifactResponseWrapper)(nil),         // 6: org.apache.beam.model.job_management.v1.ArtifactResponseWrapper
	(*ArtifactMetadata)(nil),                // 7: org.apache.beam.model.job_management.v1.ArtifactMetadata
	(*Manifest)(nil),                        // 8: org.apache.beam.model.job_management.v1.Manifest
	(*ProxyManifest)(nil),                   // 9: org.apache.beam.model.job_management.v1.ProxyManifest
	(*GetManifestRequest)(nil),              // 10: org.apache.beam.model.job_management.v1.GetManifestRequest
	(*GetManifestResponse)(nil),             // 11: org.apache.beam.model.job_management.v1.GetManifestResponse
	(*LegacyGetArtifactRequest)(nil),        // 12: org.apache.beam.model.job_management.v1.LegacyGetArtifactRequest
	(*ArtifactChunk)(nil),                   // 13: org.apache.beam.model.job_management.v1.ArtifactChunk
	(*PutArtifactMetadata)(nil),             // 14: org.apache.beam.model.job_management.v1.PutArtifactMetadata
	(*PutArtifactRequest)(nil),              // 15: org.apache.beam.model.job_management.v1.PutArtifactRequest
	(*PutArtifactResponse)(nil),             // 16: org.apache.beam.model.job_management.v1.PutArtifactResponse
	(*CommitManifestRequest)(nil),           // 17: org.apache.beam.model.job_management.v1.CommitManifestRequest
	(*CommitManifestResponse)(nil),          // 18: org.apache.beam.model.job_management.v1.CommitManifestResponse
	(*ProxyManifest_Location)(nil),          // 19: org.apache.beam.model.job_management.v1.ProxyManifest.Location
	(*pipeline_v1.ArtifactInformation)(nil), // 20: org.apache.beam.model.pipeline.v1.ArtifactInformation
}
var file_beam_artifact_api_proto_depIdxs = []int32{
	20, // 0: org.apache.beam.model.job_management.v1.ResolveArtifactsRequest.artifacts:type_name -> org.apache.beam.model.pipeline.v1.ArtifactInformation
	20, // 1: org.apache.beam.model.job_management.v1.ResolveArtifactsResponse.replacements:type_name -> org.apache.beam.model.pipeline.v1.ArtifactInformation
	20, // 2: org.apache.beam.model.job_management.v1.GetArtifactRequest.artifact:type_name -> org.apache.beam.model.pipeline.v1.ArtifactInformation
	1,  // 3: org.apache.beam.model.job_management.v1.ArtifactRequestWrapper.resolve_artifact:type_name -> org.apache.beam.model.job_management.v1.ResolveArtifactsRequest
	3,  // 4: org.apache.beam.model.job_management.v1.ArtifactRequestWrapper.get_artifact:type_name -> org.apache.beam.model.job_management.v1.GetArtifactRequest
	2,  // 5: org.apache.beam.model.job_management.v1.ArtifactResponseWrapper.resolve_artifact_response:type_name -> org.apache.beam.model.job_management.v1.ResolveArtifactsResponse
	4,  // 6: org.apache.beam.model.job_management.v1.ArtifactResponseWrapper.get_artifact_response:type_name -> org.apache.beam.model.job_management.v1.GetArtifactResponse
	7,  // 7: org.apache.beam.model.job_management.v1.Manifest.artifact:type_name -> org.apache.beam.model.job_management.v1.ArtifactMetadata
	8,  // 8: org.apache.beam.model.job_management.v1.ProxyManifest.manifest:type_name -> org.apache.beam.model.job_management.v1.Manifest
	19, // 9: org.apache.beam.model.job_management.v1.ProxyManifest.location:type_name -> org.apache.beam.model.job_management.v1.ProxyManifest.Location
	8,  // 10: org.apache.beam.model.job_management.v1.GetManifestResponse.manifest:type_name -> org.apache.beam.model.job_management.v1.Manifest
	7,  // 11: org.apache.beam.model.job_management.v1.PutArtifactMetadata.metadata:type_name -> org.apache.beam.model.job_management.v1.ArtifactMetadata
	14, // 12: org.apache.beam.model.job_management.v1.PutArtifactRequest.metadata:type_name -> org.apache.beam.model.job_management.v1.PutArtifactMetadata
	13, // 13: org.apache.beam.model.job_management.v1.PutArtifactRequest.data:type_name -> org.apache.beam.model.job_management.v1.ArtifactChunk
	8,  // 14: org.apache.beam.model.job_management.v1.CommitManifestRequest.manifest:type_name -> org.apache.beam.model.job_management.v1.Manifest
	1,  // 15: org.apache.beam.model.job_management.v1.ArtifactRetrievalService.ResolveArtifacts:input_type -> org.apache.beam.model.job_management.v1.ResolveArtifactsRequest
	3,  // 16: org.apache.beam.model.job_management.v1.ArtifactRetrievalService.GetArtifact:input_type -> org.apache.beam.model.job_management.v1.GetArtifactRequest
	6,  // 17: org.apache.beam.model.job_management.v1.ArtifactStagingService.ReverseArtifactRetrievalService:input_type -> org.apache.beam.model.job_management.v1.ArtifactResponseWrapper
	15, // 18: org.apache.beam.model.job_management.v1.LegacyArtifactStagingService.PutArtifact:input_type -> org.apache.beam.model.job_management.v1.PutArtifactRequest
	17, // 19: org.apache.beam.model.job_management.v1.LegacyArtifactStagingService.CommitManifest:input_type -> org.apache.beam.model.job_management.v1.CommitManifestRequest
	10, // 20: org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService.GetManifest:input_type -> org.apache.beam.model.job_management.v1.GetManifestRequest
	12, // 21: org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService.GetArtifact:input_type -> org.apache.beam.model.job_management.v1.LegacyGetArtifactRequest
	2,  // 22: org.apache.beam.model.job_management.v1.ArtifactRetrievalService.ResolveArtifacts:output_type -> org.apache.beam.model.job_management.v1.ResolveArtifactsResponse
	4,  // 23: org.apache.beam.model.job_management.v1.ArtifactRetrievalService.GetArtifact:output_type -> org.apache.beam.model.job_management.v1.GetArtifactResponse
	5,  // 24: org.apache.beam.model.job_management.v1.ArtifactStagingService.ReverseArtifactRetrievalService:output_type -> org.apache.beam.model.job_management.v1.ArtifactRequestWrapper
	16, // 25: org.apache.beam.model.job_management.v1.LegacyArtifactStagingService.PutArtifact:output_type -> org.apache.beam.model.job_management.v1.PutArtifactResponse
	18, // 26: org.apache.beam.model.job_management.v1.LegacyArtifactStagingService.CommitManifest:output_type -> org.apache.beam.model.job_management.v1.CommitManifestResponse
	11, // 27: org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService.GetManifest:output_type -> org.apache.beam.model.job_management.v1.GetManifestResponse
	13, // 28: org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService.GetArtifact:output_type -> org.apache.beam.model.job_management.v1.ArtifactChunk
	22, // [22:29] is the sub-list for method output_type
	15, // [15:22] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_beam_artifact_api_proto_init() }
func file_beam_artifact_api_proto_init() {
	if File_beam_artifact_api_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_beam_artifact_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveArtifactsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveArtifactsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetArtifactResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactRequestWrapper); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactResponseWrapper); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Manifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProxyManifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetManifestRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetManifestResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LegacyGetArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactChunk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutArtifactMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutArtifactResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitManifestRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitManifestResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_beam_artifact_api_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProxyManifest_Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_beam_artifact_api_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ArtifactRequestWrapper_ResolveArtifact)(nil),
		(*ArtifactRequestWrapper_GetArtifact)(nil),
	}
	file_beam_artifact_api_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ArtifactResponseWrapper_ResolveArtifactResponse)(nil),
		(*ArtifactResponseWrapper_GetArtifactResponse)(nil),
	}
	file_beam_artifact_api_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*PutArtifactRequest_Metadata)(nil),
		(*PutArtifactRequest_Data)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_beam_artifact_api_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   4,
		},
		GoTypes:           file_beam_artifact_api_proto_goTypes,
		DependencyIndexes: file_beam_artifact_api_proto_depIdxs,
		EnumInfos:         file_beam_artifact_api_proto_enumTypes,
		MessageInfos:      file_beam_artifact_api_proto_msgTypes,
	}.Build()
	File_beam_artifact_api_proto = out.File
	file_beam_artifact_api_proto_rawDesc = nil
	file_beam_artifact_api_proto_goTypes = nil
	file_beam_artifact_api_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ArtifactRetrievalServiceClient is the client API for ArtifactRetrievalService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ArtifactRetrievalServiceClient interface {
	// Resolves the given artifact references into one or more replacement
	// artifact references (e.g. a Maven dependency into a (transitive) set
	// of jars.
	ResolveArtifacts(ctx context.Context, in *ResolveArtifactsRequest, opts ...grpc.CallOption) (*ResolveArtifactsResponse, error)
	// Retrieves the given artifact as a stream of bytes.
	GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (ArtifactRetrievalService_GetArtifactClient, error)
}

type artifactRetrievalServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewArtifactRetrievalServiceClient(cc grpc.ClientConnInterface) ArtifactRetrievalServiceClient {
	return &artifactRetrievalServiceClient{cc}
}

func (c *artifactRetrievalServiceClient) ResolveArtifacts(ctx context.Context, in *ResolveArtifactsRequest, opts ...grpc.CallOption) (*ResolveArtifactsResponse, error) {
	out := new(ResolveArtifactsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/ResolveArtifacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRetrievalServiceClient) GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (ArtifactRetrievalService_GetArtifactClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArtifactRetrievalService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/GetArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &artifactRetrievalServiceGetArtifactClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArtifactRetrievalService_GetArtifactClient interface {
	Recv() (*GetArtifactResponse, error)
	grpc.ClientStream
}

type artifactRetrievalServiceGetArtifactClient struct {
	grpc.ClientStream
}

func (x *artifactRetrievalServiceGetArtifactClient) Recv() (*GetArtifactResponse, error) {
	m := new(GetArtifactResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ArtifactRetrievalServiceServer is the server API for ArtifactRetrievalService service.
type ArtifactRetrievalServiceServer interface {
	// Resolves the given artifact references into one or more replacement
	// artifact references (e.g. a Maven dependency into a (transitive) set
	// of jars.
	ResolveArtifacts(context.Context, *ResolveArtifactsRequest) (*ResolveArtifactsResponse, error)
	// Retrieves the given artifact as a stream of bytes.
	GetArtifact(*GetArtifactRequest, ArtifactRetrievalService_GetArtifactServer) error
}

// UnimplementedArtifactRetrievalServiceServer can be embedded to have forward compatible implementations.
type UnimplementedArtifactRetrievalServiceServer struct {
}

func (*UnimplementedArtifactRetrievalServiceServer) ResolveArtifacts(context.Context, *ResolveArtifactsRequest) (*ResolveArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResolveArtifacts not implemented")
}
func (*UnimplementedArtifactRetrievalServiceServer) GetArtifact(*GetArtifactRequest, ArtifactRetrievalService_GetArtifactServer) error {
	return status.Errorf(codes.Unimplemented, "method GetArtifact not implemented")
}

func RegisterArtifactRetrievalServiceServer(s *grpc.Server, srv ArtifactRetrievalServiceServer) {
	s.RegisterService(&_ArtifactRetrievalService_serviceDesc, srv)
}

func _ArtifactRetrievalService_ResolveArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRetrievalServiceServer).ResolveArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/ResolveArtifacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRetrievalServiceServer).ResolveArtifacts(ctx, req.(*ResolveArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRetrievalService_GetArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetArtifactRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArtifactRetrievalServiceServer).GetArtifact(m, &artifactRetrievalServiceGetArtifactServer{stream})
}

type ArtifactRetrievalService_GetArtifactServer interface {
	Send(*GetArtifactResponse) error
	grpc.ServerStream
}

type artifactRetrievalServiceGetArtifactServer struct {
	grpc.ServerStream
}

func (x *artifactRetrievalServiceGetArtifactServer) Send(m *GetArtifactResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _ArtifactRetrievalService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.ArtifactRetrievalService",
	HandlerType: (*ArtifactRetrievalServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ResolveArtifacts",
			Handler:    _ArtifactRetrievalService_ResolveArtifacts_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetArtifact",
			Handler:       _ArtifactRetrievalService_GetArtifact_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_artifact_api.proto",
}

// ArtifactStagingServiceClient is the client API for ArtifactStagingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ArtifactStagingServiceClient interface {
	ReverseArtifactRetrievalService(ctx context.Context, opts ...grpc.CallOption) (ArtifactStagingService_ReverseArtifactRetrievalServiceClient, error)
}

type artifactStagingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewArtifactStagingServiceClient(cc grpc.ClientConnInterface) ArtifactStagingServiceClient {
	return &artifactStagingServiceClient{cc}
}

func (c *artifactStagingServiceClient) ReverseArtifactRetrievalService(ctx context.Context, opts ...grpc.CallOption) (ArtifactStagingService_ReverseArtifactRetrievalServiceClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArtifactStagingService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.ArtifactStagingService/ReverseArtifactRetrievalService", opts...)
	if err != nil {
		return nil, err
	}
	x := &artifactStagingServiceReverseArtifactRetrievalServiceClient{stream}
	return x, nil
}

type ArtifactStagingService_ReverseArtifactRetrievalServiceClient interface {
	Send(*ArtifactResponseWrapper) error
	Recv() (*ArtifactRequestWrapper, error)
	grpc.ClientStream
}

type artifactStagingServiceReverseArtifactRetrievalServiceClient struct {
	grpc.ClientStream
}

func (x *artifactStagingServiceReverseArtifactRetrievalServiceClient) Send(m *ArtifactResponseWrapper) error {
	return x.ClientStream.SendMsg(m)
}

func (x *artifactStagingServiceReverseArtifactRetrievalServiceClient) Recv() (*ArtifactRequestWrapper, error) {
	m := new(ArtifactRequestWrapper)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ArtifactStagingServiceServer is the server API for ArtifactStagingService service.
type ArtifactStagingServiceServer interface {
	ReverseArtifactRetrievalService(ArtifactStagingService_ReverseArtifactRetrievalServiceServer) error
}

// UnimplementedArtifactStagingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedArtifactStagingServiceServer struct {
}

func (*UnimplementedArtifactStagingServiceServer) ReverseArtifactRetrievalService(ArtifactStagingService_ReverseArtifactRetrievalServiceServer) error {
	return status.Errorf(codes.Unimplemented, "method ReverseArtifactRetrievalService not implemented")
}

func RegisterArtifactStagingServiceServer(s *grpc.Server, srv ArtifactStagingServiceServer) {
	s.RegisterService(&_ArtifactStagingService_serviceDesc, srv)
}

func _ArtifactStagingService_ReverseArtifactRetrievalService_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ArtifactStagingServiceServer).ReverseArtifactRetrievalService(&artifactStagingServiceReverseArtifactRetrievalServiceServer{stream})
}

type ArtifactStagingService_ReverseArtifactRetrievalServiceServer interface {
	Send(*ArtifactRequestWrapper) error
	Recv() (*ArtifactResponseWrapper, error)
	grpc.ServerStream
}

type artifactStagingServiceReverseArtifactRetrievalServiceServer struct {
	grpc.ServerStream
}

func (x *artifactStagingServiceReverseArtifactRetrievalServiceServer) Send(m *ArtifactRequestWrapper) error {
	return x.ServerStream.SendMsg(m)
}

func (x *artifactStagingServiceReverseArtifactRetrievalServiceServer) Recv() (*ArtifactResponseWrapper, error) {
	m := new(ArtifactResponseWrapper)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _ArtifactStagingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.ArtifactStagingService",
	HandlerType: (*ArtifactStagingServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReverseArtifactRetrievalService",
			Handler:       _ArtifactStagingService_ReverseArtifactRetrievalService_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_artifact_api.proto",
}

// LegacyArtifactStagingServiceClient is the client API for LegacyArtifactStagingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LegacyArtifactStagingServiceClient interface {
	// Stage an artifact to be available during job execution. The first request must contain the
	// name of the artifact. All future requests must contain sequential chunks of the content of
	// the artifact.
	PutArtifact(ctx context.Context, opts ...grpc.CallOption) (LegacyArtifactStagingService_PutArtifactClient, error)
	// Commit the manifest for a Job. All artifacts must have been successfully uploaded
	// before this call is made.
	//
	// Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
	CommitManifest(ctx context.Context, in *CommitManifestRequest, opts ...grpc.CallOption) (*CommitManifestResponse, error)
}

type legacyArtifactStagingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLegacyArtifactStagingServiceClient(cc grpc.ClientConnInterface) LegacyArtifactStagingServiceClient {
	return &legacyArtifactStagingServiceClient{cc}
}

func (c *legacyArtifactStagingServiceClient) PutArtifact(ctx context.Context, opts ...grpc.CallOption) (LegacyArtifactStagingService_PutArtifactClient, error) {
	stream, err := c.cc.NewStream(ctx, &_LegacyArtifactStagingService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.LegacyArtifactStagingService/PutArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &legacyArtifactStagingServicePutArtifactClient{stream}
	return x, nil
}

type LegacyArtifactStagingService_PutArtifactClient interface {
	Send(*PutArtifactRequest) error
	CloseAndRecv() (*PutArtifactResponse, error)
	grpc.ClientStream
}

type legacyArtifactStagingServicePutArtifactClient struct {
	grpc.ClientStream
}

func (x *legacyArtifactStagingServicePutArtifactClient) Send(m *PutArtifactRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *legacyArtifactStagingServicePutArtifactClient) CloseAndRecv() (*PutArtifactResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(PutArtifactResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *legacyArtifactStagingServiceClient) CommitManifest(ctx context.Context, in *CommitManifestRequest, opts ...grpc.CallOption) (*CommitManifestResponse, error) {
	out := new(CommitManifestResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.LegacyArtifactStagingService/CommitManifest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LegacyArtifactStagingServiceServer is the server API for LegacyArtifactStagingService service.
type LegacyArtifactStagingServiceServer interface {
	// Stage an artifact to be available during job execution. The first request must contain the
	// name of the artifact. All future requests must contain sequential chunks of the content of
	// the artifact.
	PutArtifact(LegacyArtifactStagingService_PutArtifactServer) error
	// Commit the manifest for a Job. All artifacts must have been successfully uploaded
	// before this call is made.
	//
	// Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
	CommitManifest(context.Context, *CommitManifestRequest) (*CommitManifestResponse, error)
}

// UnimplementedLegacyArtifactStagingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLegacyArtifactStagingServiceServer struct {
}

func (*UnimplementedLegacyArtifactStagingServiceServer) PutArtifact(LegacyArtifactStagingService_PutArtifactServer) error {
	return status.Errorf(codes.Unimplemented, "method PutArtifact not implemented")
}
func (*UnimplementedLegacyArtifactStagingServiceServer) CommitManifest(context.Context, *CommitManifestRequest) (*CommitManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitManifest not implemented")
}

func RegisterLegacyArtifactStagingServiceServer(s *grpc.Server, srv LegacyArtifactStagingServiceServer) {
	s.RegisterService(&_LegacyArtifactStagingService_serviceDesc, srv)
}

func _LegacyArtifactStagingService_PutArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(LegacyArtifactStagingServiceServer).PutArtifact(&legacyArtifactStagingServicePutArtifactServer{stream})
}

type LegacyArtifactStagingService_PutArtifactServer interface {
	SendAndClose(*PutArtifactResponse) error
	Recv() (*PutArtifactRequest, error)
	grpc.ServerStream
}

type legacyArtifactStagingServicePutArtifactServer struct {
	grpc.ServerStream
}

func (x *legacyArtifactStagingServicePutArtifactServer) SendAndClose(m *PutArtifactResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *legacyArtifactStagingServicePutArtifactServer) Recv() (*PutArtifactRequest, error) {
	m := new(PutArtifactRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _LegacyArtifactStagingService_CommitManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LegacyArtifactStagingServiceServer).CommitManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.LegacyArtifactStagingService/CommitManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LegacyArtifactStagingServiceServer).CommitManifest(ctx, req.(*CommitManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LegacyArtifactStagingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.LegacyArtifactStagingService",
	HandlerType: (*LegacyArtifactStagingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CommitManifest",
			Handler:    _LegacyArtifactStagingService_CommitManifest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PutArtifact",
			Handler:       _LegacyArtifactStagingService_PutArtifact_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "beam_artifact_api.proto",
}

// LegacyArtifactRetrievalServiceClient is the client API for LegacyArtifactRetrievalService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LegacyArtifactRetrievalServiceClient interface {
	// Get the manifest for the job
	GetManifest(ctx context.Context, in *GetManifestRequest, opts ...grpc.CallOption) (*GetManifestResponse, error)
	// Get an artifact staged for the job. The requested artifact must be within the manifest
	GetArtifact(ctx context.Context, in *LegacyGetArtifactRequest, opts ...grpc.CallOption) (LegacyArtifactRetrievalService_GetArtifactClient, error)
}

type legacyArtifactRetrievalServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLegacyArtifactRetrievalServiceClient(cc grpc.ClientConnInterface) LegacyArtifactRetrievalServiceClient {
	return &legacyArtifactRetrievalServiceClient{cc}
}

func (c *legacyArtifactRetrievalServiceClient) GetManifest(ctx context.Context, in *GetManifestRequest, opts ...grpc.CallOption) (*GetManifestResponse, error) {
	out := new(GetManifestResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService/GetManifest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *legacyArtifactRetrievalServiceClient) GetArtifact(ctx context.Context, in *LegacyGetArtifactRequest, opts ...grpc.CallOption) (LegacyArtifactRetrievalService_GetArtifactClient, error) {
	stream, err := c.cc.NewStream(ctx, &_LegacyArtifactRetrievalService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService/GetArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &legacyArtifactRetrievalServiceGetArtifactClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type LegacyArtifactRetrievalService_GetArtifactClient interface {
	Recv() (*ArtifactChunk, error)
	grpc.ClientStream
}

type legacyArtifactRetrievalServiceGetArtifactClient struct {
	grpc.ClientStream
}

func (x *legacyArtifactRetrievalServiceGetArtifactClient) Recv() (*ArtifactChunk, error) {
	m := new(ArtifactChunk)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// LegacyArtifactRetrievalServiceServer is the server API for LegacyArtifactRetrievalService service.
type LegacyArtifactRetrievalServiceServer interface {
	// Get the manifest for the job
	GetManifest(context.Context, *GetManifestRequest) (*GetManifestResponse, error)
	// Get an artifact staged for the job. The requested artifact must be within the manifest
	GetArtifact(*LegacyGetArtifactRequest, LegacyArtifactRetrievalService_GetArtifactServer) error
}

// UnimplementedLegacyArtifactRetrievalServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLegacyArtifactRetrievalServiceServer struct {
}

func (*UnimplementedLegacyArtifactRetrievalServiceServer) GetManifest(context.Context, *GetManifestRequest) (*GetManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetManifest not implemented")
}
func (*UnimplementedLegacyArtifactRetrievalServiceServer) GetArtifact(*LegacyGetArtifactRequest, LegacyArtifactRetrievalService_GetArtifactServer) error {
	return status.Errorf(codes.Unimplemented, "method GetArtifact not implemented")
}

func RegisterLegacyArtifactRetrievalServiceServer(s *grpc.Server, srv LegacyArtifactRetrievalServiceServer) {
	s.RegisterService(&_LegacyArtifactRetrievalService_serviceDesc, srv)
}

func _LegacyArtifactRetrievalService_GetManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LegacyArtifactRetrievalServiceServer).GetManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService/GetManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LegacyArtifactRetrievalServiceServer).GetManifest(ctx, req.(*GetManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LegacyArtifactRetrievalService_GetArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LegacyGetArtifactRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LegacyArtifactRetrievalServiceServer).GetArtifact(m, &legacyArtifactRetrievalServiceGetArtifactServer{stream})
}

type LegacyArtifactRetrievalService_GetArtifactServer interface {
	Send(*ArtifactChunk) error
	grpc.ServerStream
}

type legacyArtifactRetrievalServiceGetArtifactServer struct {
	grpc.ServerStream
}

func (x *legacyArtifactRetrievalServiceGetArtifactServer) Send(m *ArtifactChunk) error {
	return x.ServerStream.SendMsg(m)
}

var _LegacyArtifactRetrievalService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.LegacyArtifactRetrievalService",
	HandlerType: (*LegacyArtifactRetrievalServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetManifest",
			Handler:    _LegacyArtifactRetrievalService_GetManifest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetArtifact",
			Handler:       _LegacyArtifactRetrievalService_GetArtifact_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_artifact_api.proto",
}
