/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.RMHeaderPart;

public class Sequence
implements RMHeaderPart {
    private Identifier identifier;
    private long messageNumber;
    private boolean lastMessage = false;
    private String namespaceValue = null;
    private OMNamespace omNamespace = null;

    public Sequence(String namespaceValue) {
        this.namespaceValue = namespaceValue;
        this.omNamespace = "http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceValue) ? Sandesha2Constants.SPEC_2005_02.OM_NS_URI : Sandesha2Constants.SPEC_2007_02.OM_NS_URI;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromHeaderBlock(SOAPHeaderBlock shb) throws OMException, SandeshaException {
        if (shb == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noSequencePartInElement"));
        }
        OMElement identifierPart = null;
        OMElement msgNumberPart = null;
        OMElement lastMessageElement = null;
        Iterator iter = shb.getChildElements();
        while (iter.hasNext()) {
            OMElement child = (OMElement)iter.next();
            QName qn = child.getQName();
            if (!this.namespaceValue.equals(qn.getNamespaceURI())) continue;
            if ("Identifier".equals(qn.getLocalPart())) {
                identifierPart = child;
                continue;
            }
            if ("MessageNumber".equals(qn.getLocalPart())) {
                msgNumberPart = child;
                continue;
            }
            if (!"LastMessage".equals(qn.getLocalPart())) continue;
            lastMessageElement = child;
        }
        this.identifier = new Identifier(this.namespaceValue);
        this.identifier.fromOMElement(identifierPart);
        if (msgNumberPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noMessageNumberPartInElement"));
        }
        this.messageNumber = Long.parseLong(msgNumberPart.getText());
        if (lastMessageElement != null) {
            this.lastMessage = true;
        }
        shb.setProcessed();
        return this;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public boolean getLastMessage() {
        return this.lastMessage;
    }

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setLastMessage(boolean lastMessage) {
        this.lastMessage = lastMessage;
    }

    public void setMessageNumber(long messageNumber) {
        this.messageNumber = messageNumber;
    }

    public void toHeader(SOAPHeader header) {
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullMsgId"));
        }
        if (this.messageNumber <= 0L) {
            throw new OMException(SandeshaMessageHelper.getMessage("setAValidMsgNumber", Long.toString(this.messageNumber)));
        }
        SOAPHeaderBlock sequenceHeaderBlock = header.addHeaderBlock("Sequence", this.omNamespace);
        sequenceHeaderBlock.setMustUnderstand(true);
        this.identifier.toOMElement((OMElement)sequenceHeaderBlock, this.omNamespace);
        OMElement messageNoElement = sequenceHeaderBlock.getOMFactory().createOMElement("MessageNumber", this.omNamespace);
        messageNoElement.setText(Long.toString(this.messageNumber));
        sequenceHeaderBlock.addChild((OMNode)messageNoElement);
        if (this.lastMessage) {
            OMElement lastMessageElement = sequenceHeaderBlock.getOMFactory().createOMElement("LastMessage", this.omNamespace);
            sequenceHeaderBlock.addChild((OMNode)lastMessageElement);
        }
    }
}

