/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SequenceManager;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.SenderWorker;
import org.apache.sandesha2.workers.SequenceEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sender
extends SandeshaThread {
    private static final Log log = LogFactory.getLog(Sender.class);
    int nextIndex = 0;
    boolean processedMessage = false;
    long lastHousekeeping = 0L;
    long lastRanCleanup = 0L;
    private static int HOUSEKEEPING_INTERVAL = 20000;
    private ConcurrentHashMap<String, AckHolder> ackMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> warnedAlreadyOrphans = new ConcurrentHashMap();

    public Sender() {
        super(500);
    }

    public void scheduleAddressableAcknowledgement(String sequenceId, long ackInterval, RMMsgContext ref) {
        AckHolder ackH = new AckHolder();
        ackH.tts = System.currentTimeMillis() + ackInterval;
        ackH.refMsg = ref;
        this.ackMap.putIfAbsent(sequenceId, ackH);
    }

    public void removeScheduledAcknowledgement(String sequenceId) {
        this.ackMap.remove(sequenceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean internalRun() {
        String message;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Sender::internalRun");
        }
        Transaction transaction = null;
        boolean sleep = false;
        try {
            SenderBeanMgr mgr;
            SenderBean senderBean;
            AckHolder acktts;
            ArrayList<SequenceEntry> allSequencesList = this.getSequences();
            int size = allSequencesList.size();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Choosing one from " + size + " sequences"));
            }
            if (this.nextIndex >= size) {
                this.nextIndex = 0;
                if (size == 0 || !this.processedMessage) {
                    sleep = true;
                }
                this.processedMessage = false;
                if (System.currentTimeMillis() - this.lastHousekeeping > (long)HOUSEKEEPING_INTERVAL) {
                    this.deleteTerminatedSequences(this.storageManager);
                    this.unblockTransportThreads(this.storageManager);
                    this.checkForOrphanMessages(this.storageManager);
                    this.lastHousekeeping = System.currentTimeMillis();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exit: Sender::internalRun, looped over all sequences, sleep " + sleep));
                }
                boolean bl = sleep;
                return bl;
            }
            transaction = this.storageManager.getTransaction();
            SequenceEntry entry = allSequencesList.get(this.nextIndex++);
            String sequenceId = entry.getSequenceId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Chose sequence " + sequenceId));
            }
            String rmVersion = null;
            boolean found = false;
            if (entry.isRmSource()) {
                RMSBean matcher;
                RMSBean rms = null;
                if (entry.rmsKey == null) {
                    matcher = new RMSBean();
                    matcher.setInternalSequenceID(sequenceId);
                    matcher.setTerminated(false);
                    rms = this.storageManager.getRMSBeanMgr().findUnique(matcher);
                    if (rms != null) {
                        entry.rmsKey = rms.getCreateSeqMsgID();
                    }
                } else {
                    rms = this.storageManager.getRMSBeanMgr().retrieve(entry.rmsKey);
                    if (rms == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"RMS bean is null - checking using findUnique");
                        }
                        matcher = new RMSBean();
                        matcher.setInternalSequenceID(sequenceId);
                        matcher.setTerminated(false);
                        rms = this.storageManager.getRMSBeanMgr().findUnique(matcher);
                    }
                }
                if (rms != null && !rms.isTerminated() && !rms.isTimedOut()) {
                    sequenceId = rms.getSequenceID();
                    if (SequenceManager.hasSequenceTimedOut(rms, sequenceId, this.storageManager)) {
                        SequenceManager.finalizeTimedOutSequence(rms.getInternalSequenceID(), null, this.storageManager);
                    } else {
                        found = true;
                    }
                    rmVersion = rms.getRMVersion();
                }
            } else {
                RMDBean rmd = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, sequenceId);
                if (rmd != null && !rmd.isTerminated()) {
                    found = true;
                    rmVersion = rmd.getRMVersion();
                }
            }
            if (!found) {
                this.stopThreadForSequence(sequenceId, entry.isRmSource());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: Sender::internalRun, sequence has ended");
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                    transaction = null;
                }
                boolean rmd = false;
                return rmd;
            }
            if (sequenceId != null && (acktts = this.ackMap.get(sequenceId)) != null && acktts.tts < System.currentTimeMillis()) {
                this.ackMap.remove(sequenceId);
                RMDBean rmd = this.storageManager.getRMDBeanMgr().retrieve(sequenceId);
                if (rmd != null) {
                    RMMsgContext ackRMMsgContext = AcknowledgementManager.generateAckMessage(acktts.refMsg, rmd, sequenceId, this.storageManager, true);
                    AcknowledgementManager.addAckBeanEntry(ackRMMsgContext, sequenceId, acktts.tts, this.storageManager);
                    transaction.commit();
                    transaction = this.storageManager.getTransaction();
                }
            }
            if ((senderBean = (mgr = this.storageManager.getSenderBeanMgr()).getNextMsgToSend(sequenceId)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: Sender::internalRun, no message for this sequence");
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                    transaction = null;
                }
                boolean ackRMMsgContext = false;
                return ackRMMsgContext;
            }
            String workId = senderBean.getMessageID() + senderBean.getTimeToSend();
            if (this.getWorkerLock().isWorkPresent(workId)) {
                if (log.isDebugEnabled()) {
                    String message2 = SandeshaMessageHelper.getMessage("workAlreadyAssigned", workId);
                    log.debug((Object)("Exit: Sender::internalRun, " + message2 + ", sleeping"));
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                    transaction = null;
                }
                boolean message2 = true;
                return message2;
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
            SenderWorker worker = new SenderWorker(this.context, senderBean, rmVersion);
            worker.setLock(this.getWorkerLock());
            worker.setWorkId(workId);
            try {
                this.getWorkerLock().addWork(workId, worker);
                this.threadPool.execute((Runnable)worker);
            }
            catch (Exception e) {
                this.getWorkerLock().removeWork(workId);
            }
            this.processedMessage = true;
        }
        catch (Exception e) {
            message = SandeshaMessageHelper.getMessage("sendMsgError", e.toString());
            log.debug((Object)message, (Throwable)e);
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                try {
                    transaction.rollback();
                    transaction = null;
                }
                catch (Exception e) {
                    message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                    log.debug((Object)message, (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Sender::internalRun, not sleeping");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTerminatedSequences(StorageManager storageManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Sender::deleteTerminatedSequences");
        }
        RMSBean finderBean = new RMSBean();
        finderBean.setTerminated(true);
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean((AxisDescription)storageManager.getContext().getAxisConfiguration());
            long deleteTime = propertyBean.getSequenceRemovalTimeoutInterval();
            if (deleteTime < 0L) {
                deleteTime = 0L;
            }
            if (deleteTime > 0L) {
                List<RMSBean> rmsBeans = storageManager.getRMSBeanMgr().find(finderBean);
                this.deleteRMSBeans(rmsBeans, propertyBean, deleteTime);
                finderBean.setTerminated(false);
                finderBean.setTimedOut(true);
                rmsBeans = storageManager.getRMSBeanMgr().find(finderBean);
                this.deleteRMSBeans(rmsBeans, propertyBean, deleteTime);
                RMDBean finderRMDBean = new RMDBean();
                finderRMDBean.setTerminated(true);
                List<RMDBean> rmdBeans = storageManager.getRMDBeanMgr().find(finderRMDBean);
                for (RMDBean rmdBean : rmdBeans) {
                    long timeNow = System.currentTimeMillis();
                    long lastActivated = rmdBean.getLastActivatedTime();
                    if (lastActivated + deleteTime >= timeNow) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deleting RMDBean " + deleteTime + " : " + rmdBean));
                    }
                    storageManager.getRMDBeanMgr().delete(rmdBean.getSequenceID());
                }
            }
            if (propertyBean.getInactivityTimeoutInterval() > 0L) {
                RMDBean finderRMDBean = new RMDBean();
                finderRMDBean.setTerminated(false);
                List<RMDBean> rmdBeans = storageManager.getRMDBeanMgr().find(finderRMDBean);
                for (RMDBean rmdBean : rmdBeans) {
                    long timeNow = System.currentTimeMillis();
                    long lastActivated = rmdBean.getLastActivatedTime();
                    if (lastActivated + propertyBean.getInactivityTimeoutInterval() >= timeNow) continue;
                    rmdBean.setTerminated(true);
                    rmdBean.setLastActivatedTime(timeNow);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(System.currentTimeMillis() + "Marking RMDBean as terminated " + rmdBean));
                    }
                    storageManager.getRMDBeanMgr().update(rmdBean);
                }
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
        }
        catch (SandeshaException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
        }
        finally {
            block24: {
                if (transaction != null && transaction.isActive()) {
                    try {
                        transaction.rollback();
                    }
                    catch (SandeshaStorageException e) {
                        if (!log.isDebugEnabled()) break block24;
                        log.debug((Object)"Caught exception rolling back transaction", (Throwable)((Object)e));
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Sender::deleteTerminatedSequences");
        }
    }

    private void deleteRMSBeans(List<RMSBean> rmsBeans, SandeshaPolicyBean propertyBean, long deleteTime) throws SandeshaStorageException, SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Sender::deleteRMSBeans");
        }
        for (RMSBean rmsBean : rmsBeans) {
            RMSBean reallocatedRMSBean;
            long timeNow = System.currentTimeMillis();
            long lastActivated = rmsBean.getLastActivatedTime();
            if (lastActivated + deleteTime >= timeNow || rmsBean.isReallocated() != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing RMSBean " + rmsBean));
            }
            if ((reallocatedRMSBean = SandeshaUtil.isLinkedToReallocatedRMSBean(this.storageManager, rmsBean.getInternalSequenceID())) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing Reallocated RMSBean " + reallocatedRMSBean));
                }
                this.storageManager.getRMSBeanMgr().delete(reallocatedRMSBean.getCreateSeqMsgID());
            }
            this.storageManager.getRMSBeanMgr().delete(rmsBean.getCreateSeqMsgID());
            this.storageManager.removeMessageContext(rmsBean.getReferenceMessageStoreKey());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Sender::deleteRMSBeans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblockTransportThreads(StorageManager manager) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Sender::unblockTransportThreads");
        }
        Transaction transaction = null;
        try {
            transaction = manager.getTransaction();
            SenderBean finder = new SenderBean();
            finder.setSend(false);
            finder.setTransportAvailable(true);
            finder.setTimeToSend(System.currentTimeMillis() - 60000L);
            List<SenderBean> beans = manager.getSenderBeanMgr().find(finder);
            for (SenderBean bean : beans) {
                EndpointReference acksToEPR;
                MessageContext msgCtx = manager.retrieveMessageContext(bean.getMessageContextRefKey(), this.context);
                RequestResponseTransport t = null;
                MessageContext inMsg = null;
                OperationContext op = msgCtx.getOperationContext();
                if (op != null) {
                    inMsg = op.getMessageContext("In");
                }
                if (inMsg != null) {
                    t = (RequestResponseTransport)inMsg.getProperty("RequestResponseTransportControl");
                }
                if (t == null || !RequestResponseTransport.RequestResponseTransportStatus.WAITING.equals((Object)t.getStatus())) continue;
                if (log.isWarnEnabled()) {
                    String message = SandeshaMessageHelper.getMessage("freeingTransport");
                    log.warn((Object)message);
                }
                boolean sendAck = false;
                RMDBean inbound = null;
                String inboundSeq = bean.getInboundSequenceId();
                if (inboundSeq != null) {
                    inbound = SandeshaUtil.getRMDBeanFromSequenceId(manager, inboundSeq);
                }
                if (inbound != null && (acksToEPR = inbound.getAcksToEndpointReference()) != null && acksToEPR.hasAnonymousAddress()) {
                    sendAck = true;
                }
                if (sendAck) {
                    RMMsgContext rmMsgCtx = MsgInitializer.initializeMessage(msgCtx);
                    RMMsgContext ackRMMsgCtx = AcknowledgementManager.generateAckMessage(rmMsgCtx, inbound, inbound.getSequenceID(), this.storageManager, true);
                    AcknowledgementManager.sendAckNow(ackRMMsgCtx);
                    TransportUtils.setResponseWritten((MessageContext)msgCtx, (boolean)true);
                } else {
                    TransportUtils.setResponseWritten((MessageContext)msgCtx, (boolean)false);
                }
                bean.setTransportAvailable(false);
                bean.setTimeToSend(System.currentTimeMillis());
                manager.getSenderBeanMgr().update(bean);
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception", (Throwable)e);
            }
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Sender::unblockTransportThreads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForOrphanMessages(StorageManager manager) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: Sender::checkForOrphanMessages");
        }
        Transaction tran = null;
        try {
            tran = manager.getTransaction();
            SenderBean finder = new SenderBean();
            finder.setSend(true);
            finder.setTransportAvailable(false);
            finder.setTimeToSend(System.currentTimeMillis() - 60000L);
            List<SenderBean> beans = manager.getSenderBeanMgr().find(finder);
            tran.commit();
            tran = manager.getTransaction();
            for (SenderBean bean : beans) {
                int messageType;
                if (log.isWarnEnabled()) {
                    String message = null;
                    String internalSequenceID = bean.getInternalSequenceID();
                    String sequenceID = bean.getSequenceID();
                    if (!this.warnedAlreadyOrphans.containsKey(sequenceID)) {
                        if (bean.getMessageType() == 3) {
                            message = SandeshaMessageHelper.getMessage("noPolling", sequenceID, internalSequenceID);
                        } else {
                            String messageType2 = Integer.toString(bean.getMessageType());
                            message = SandeshaMessageHelper.getMessage("noPollingProtocol", messageType2, sequenceID, internalSequenceID);
                        }
                        this.warnedAlreadyOrphans.put(sequenceID, System.currentTimeMillis());
                        log.warn((Object)message);
                    }
                }
                if (7 == (messageType = bean.getMessageType()) || 9 == messageType) {
                    String id = bean.getSequenceID();
                    RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(manager, id);
                    TerminateManager.terminateSendingSide(rmsBean, this.storageManager, false, null);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sender::checkForOrphanMessages.  Orphaned message of type TERMINATE_SEQ or TERMINATE_SEQ_RESPONSE found.  Deleting this message with a sequence ID of : " + id));
                    }
                    manager.getSenderBeanMgr().delete(bean.getMessageID());
                } else {
                    bean.setTimeToSend(System.currentTimeMillis());
                    manager.getSenderBeanMgr().update(bean);
                }
                long currentTime = System.currentTimeMillis();
                if (this.lastRanCleanup == 0L) {
                    this.lastRanCleanup = System.currentTimeMillis();
                }
                if (this.warnedAlreadyOrphans.size() <= 1000 && currentTime <= this.lastRanCleanup + 600000L) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Sender::checkForOrphanMessages.  Cleaning up list of orphans");
                }
                long timeAnHourAgo = currentTime - 3600000L;
                for (Object key : this.warnedAlreadyOrphans.keySet()) {
                    long ageOfThisOrphan = this.warnedAlreadyOrphans.get(key);
                    if (ageOfThisOrphan >= timeAnHourAgo) continue;
                    this.warnedAlreadyOrphans.remove(key);
                }
                this.lastRanCleanup = System.currentTimeMillis();
            }
            if (tran != null && tran.isActive()) {
                tran.commit();
            }
            tran = null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception", (Throwable)e);
            }
        }
        finally {
            if (tran != null && tran.isActive()) {
                tran.rollback();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Sender::checkForOrphanMessages");
        }
    }

    private static class AckHolder {
        public long tts = 0L;
        public RMMsgContext refMsg;

        private AckHolder() {
        }
    }
}

