/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.description.impl.URIResolverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.resolver.Catalog;
import org.xml.sax.InputSource;

public class CatalogURIResolver
extends URIResolverImpl {
    private static Log log = LogFactory.getLog(CatalogURIResolver.class);
    private Catalog catalogResolver;

    public CatalogURIResolver(JAXWSCatalogManager catalogManager) {
        this(catalogManager, null);
    }

    public CatalogURIResolver(JAXWSCatalogManager catalogManager, ClassLoader classLoader) {
        super(classLoader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init: catalogManager :" + String.valueOf(catalogManager)));
        }
        if (catalogManager != null) {
            this.catalogResolver = catalogManager.getCatalog();
        }
    }

    public String getRedirectedURI(String namespace, String schemaLocation, String baseUri) {
        String resolvedImportLocation = null;
        try {
            resolvedImportLocation = this.catalogResolver.resolveSystem(schemaLocation);
            if (resolvedImportLocation == null) {
                resolvedImportLocation = this.catalogResolver.resolveSystem(namespace);
            }
            if (resolvedImportLocation == null) {
                resolvedImportLocation = this.catalogResolver.resolveURI(schemaLocation);
            }
            if (resolvedImportLocation == null) {
                resolvedImportLocation = this.catalogResolver.resolvePublic(namespace, namespace);
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getRedirectedURI error: Catalog resolution failed");
            }
            throw new RuntimeException("Catalog resolution failed", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRedirectedURI exit: redirected location: " + resolvedImportLocation));
        }
        return resolvedImportLocation;
    }

    @Override
    public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolveEntity: [" + namespace + "][" + schemaLocation + "][ " + baseUri + "]"));
        }
        InputSource returnInputSource = null;
        if (this.catalogResolver != null) {
            String redirectedURI;
            if (log.isDebugEnabled()) {
                log.debug((Object)"catalogResolver found, calling CatalogURIResolver.getRedirectedURI.");
            }
            if ((redirectedURI = this.getRedirectedURI(namespace, schemaLocation, baseUri)) != null) {
                returnInputSource = this.getInputSourceFromRedirectedURI(redirectedURI);
            }
        }
        if (returnInputSource != null) {
            return returnInputSource;
        }
        return super.resolveEntity(namespace, schemaLocation, baseUri);
    }

    private InputSource getInputSourceFromRedirectedURI(String redirectedURI) {
        InputSource returnInputSource;
        String validatedURI;
        InputStream is;
        block14: {
            is = null;
            validatedURI = null;
            returnInputSource = null;
            if (this.isAbsolute(redirectedURI) && (is = this.getInputStreamForURI(redirectedURI)) != null) {
                validatedURI = redirectedURI;
            }
            if (is == null && this.classLoader != null) {
                block13: {
                    try {
                        is = this.classLoader.getResourceAsStream(redirectedURI);
                        if (is != null) {
                            validatedURI = redirectedURI;
                        }
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) break block13;
                        log.debug((Object)("Exception occured in validateRedirectedURI, ignoring exception continuing processing: " + t.getMessage()));
                    }
                }
                if (is == null) {
                    redirectedURI = this.stripProtocol(redirectedURI);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getInputSourceFromRedirectedURI: new redirected location: " + redirectedURI));
                    }
                    try {
                        is = this.classLoader.getResourceAsStream(redirectedURI);
                        if (is != null) {
                            validatedURI = redirectedURI;
                        }
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) break block14;
                        log.debug((Object)("Exception occured in validateRedirectedURI, ignoring exception continuing processing: " + t.getMessage()));
                    }
                }
            }
        }
        if (is != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getInputSourceFromRedirectedURI: XSD input stream is not null after resolving import for: " + redirectedURI));
            }
            returnInputSource = new InputSource(is);
            returnInputSource.setSystemId(validatedURI != null ? validatedURI : redirectedURI);
            if (log.isDebugEnabled()) {
                log.debug((Object)("returnInputSource :" + returnInputSource.getSystemId()));
            }
        }
        return returnInputSource;
    }

    private String stripProtocol(String uriStr) {
        String retURI = uriStr.replace('\\', '/');
        int index = retURI.indexOf("://");
        if (index != -1) {
            retURI = retURI.substring(index + 3);
        }
        return retURI;
    }
}

