/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.transaction.UserTransaction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSEndpoint;
import org.apache.axis2.transport.jms.JMSListener;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.axis2.transport.jms.ctype.ContentTypeInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSMessageReceiver {
    private static final Log log = LogFactory.getLog(JMSMessageReceiver.class);
    private JMSListener jmsListener = null;
    private JMSConnectionFactory jmsConnectionFactory = null;
    private MetricsCollector metrics = null;
    final JMSEndpoint endpoint;

    JMSMessageReceiver(JMSListener jmsListener, JMSConnectionFactory jmsConFac, JMSEndpoint endpoint) {
        this.jmsListener = jmsListener;
        this.jmsConnectionFactory = jmsConFac;
        this.endpoint = endpoint;
        this.metrics = jmsListener.getMetricsCollector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMessage(Message message, UserTransaction ut) {
        block21: {
            try {
                if (log.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Received new JMS message for service :").append(this.endpoint.getServiceName());
                    sb.append("\nDestination    : ").append(message.getJMSDestination());
                    sb.append("\nMessage ID     : ").append(message.getJMSMessageID());
                    sb.append("\nCorrelation ID : ").append(message.getJMSCorrelationID());
                    sb.append("\nReplyTo        : ").append(message.getJMSReplyTo());
                    sb.append("\nRedelivery ?   : ").append(message.getJMSRedelivered());
                    sb.append("\nPriority       : ").append(message.getJMSPriority());
                    sb.append("\nExpiration     : ").append(message.getJMSExpiration());
                    sb.append("\nTimestamp      : ").append(message.getJMSTimestamp());
                    sb.append("\nMessage Type   : ").append(message.getJMSType());
                    sb.append("\nPersistent ?   : ").append(2 == message.getJMSDeliveryMode());
                    log.debug((Object)sb.toString());
                    if (log.isTraceEnabled() && message instanceof TextMessage) {
                        log.trace((Object)("\nMessage : " + ((TextMessage)message).getText()));
                    }
                }
            }
            catch (JMSException e) {
                if (!log.isDebugEnabled()) break block21;
                log.debug((Object)"Error reading JMS message headers for debug logging", (Throwable)e);
            }
        }
        try {
            this.metrics.incrementBytesReceived(JMSUtils.getMessageSize(message));
        }
        catch (JMSException e) {
            log.warn((Object)"Error reading JMS message size to update transport metrics", (Throwable)e);
        }
        try {
            long expiryTime = message.getJMSExpiration();
            if (expiryTime > 0L && System.currentTimeMillis() > expiryTime) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Discard expired message with ID : " + message.getJMSMessageID()));
                }
                return true;
            }
        }
        catch (JMSException expiryTime) {
            // empty catch block
        }
        boolean successful = false;
        try {
            successful = this.processThoughEngine(message, ut);
        }
        catch (JMSException e) {
            log.error((Object)"JMS Exception encountered while processing", (Throwable)e);
        }
        catch (AxisFault e) {
            log.error((Object)"Axis fault processing message", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Unknown error processing message", (Throwable)e);
        }
        finally {
            if (successful) {
                this.metrics.incrementMessagesReceived();
            } else {
                this.metrics.incrementFaultsReceiving();
            }
        }
        return successful;
    }

    private boolean processThoughEngine(Message message, UserTransaction ut) throws JMSException, AxisFault {
        String jndiReplyDestinationName;
        MessageContext msgContext = this.endpoint.createMessageContext();
        try {
            msgContext.setMessageID(message.getJMSMessageID());
            String jmsCorrelationID = message.getJMSCorrelationID();
            if (jmsCorrelationID != null && jmsCorrelationID.length() > 0) {
                msgContext.setProperty("JMS_COORELATION_ID", (Object)jmsCorrelationID);
            } else {
                msgContext.setProperty("JMS_COORELATION_ID", (Object)message.getJMSMessageID());
            }
        }
        catch (JMSException jmsCorrelationID) {
            // empty catch block
        }
        String soapAction = JMSUtils.getProperty(message, "SOAPAction");
        ContentTypeInfo contentTypeInfo = this.endpoint.getContentTypeRuleSet().getContentTypeInfo(message);
        if (contentTypeInfo == null) {
            throw new AxisFault("Unable to determine content type for message " + msgContext.getMessageID());
        }
        Destination replyTo = message.getJMSReplyTo();
        if (replyTo == null && (jndiReplyDestinationName = this.endpoint.getJndiReplyDestinationName()) != null) {
            replyTo = this.jmsConnectionFactory.getDestination(jndiReplyDestinationName, this.endpoint.getReplyDestinationType());
        }
        if (replyTo != null) {
            msgContext.setProperty("OutTransportInfo", (Object)new JMSOutTransportInfo(this.jmsConnectionFactory, replyTo, contentTypeInfo.getPropertyName()));
        }
        JMSUtils.setSOAPEnvelope(message, msgContext, contentTypeInfo.getContentType());
        if (ut != null) {
            msgContext.setProperty("UserTransaction", (Object)ut);
        }
        this.jmsListener.handleIncomingMessage(msgContext, JMSUtils.getTransportHeaders(message), soapAction, contentTypeInfo.getContentType());
        Object o = msgContext.getProperty("SET_ROLLBACK_ONLY");
        return o == null || (!(o instanceof Boolean) || (Boolean)o == false) && (!(o instanceof String) || Boolean.valueOf((String)o) == false);
    }
}

