/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.base.BaseUtils;

public abstract class ProtocolEndpoint {
    private AbstractTransportListenerEx<?> listener;
    private AxisService service;

    void init(AbstractTransportListenerEx<?> listener, AxisService service) {
        this.listener = listener;
        this.service = service;
    }

    public final AbstractTransportListenerEx<?> getListener() {
        return this.listener;
    }

    public final AxisService getService() {
        return this.service;
    }

    public final String getServiceName() {
        return this.service == null ? null : this.service.getName();
    }

    protected final ConfigurationContext getConfigurationContext() {
        return this.listener.getConfigurationContext();
    }

    public abstract boolean loadConfiguration(ParameterInclude var1) throws AxisFault;

    public abstract EndpointReference[] getEndpointReferences(AxisService var1, String var2) throws AxisFault;

    public String getDescription() {
        return this.toString();
    }

    public MessageContext createMessageContext() throws AxisFault {
        MessageContext msgContext = this.listener.createMessageContext();
        if (this.service != null) {
            msgContext.setAxisService(this.service);
            Parameter operationParam = this.service.getParameter("Operation");
            QName operationQName = operationParam != null ? BaseUtils.getQNameFromString(operationParam.getValue()) : BaseConstants.DEFAULT_OPERATION;
            AxisOperation operation = this.service.getOperation(operationQName);
            if (operation != null) {
                msgContext.setAxisOperation(operation);
                msgContext.setAxisMessage(operation.getMessage("In"));
                msgContext.setSoapAction("urn:" + operation.getName().getLocalPart());
            }
        }
        return msgContext;
    }
}

