/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.eclipse.ui;

import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.axis2.tool.service.eclipse.util.SettingsConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractServiceWizardPage
extends WizardPage
implements SettingsConstants {
    protected IDialogSettings settings;
    protected boolean restoredFromPreviousSettings = false;

    public AbstractServiceWizardPage(String pageName) {
        super(pageName + ".name");
        this.init(pageName);
    }

    protected void init(String pageName) {
        this.setTitle(ServiceArchiver.getResourceString(pageName + ".title"));
        this.setDescription(ServiceArchiver.getResourceString(pageName + ".desc"));
        this.setImageDescriptor(ServiceArchiver.getWizardImageDescriptor());
        IDialogSettings rootSettings = ServiceArchiver.getDefault().getDialogSettings();
        IDialogSettings section = rootSettings.getSection(this.getClass().getName());
        if (section == null) {
            this.settings = rootSettings.addNewSection(this.getClass().getName());
            this.restoredFromPreviousSettings = false;
            this.initializeDefaultSettings();
        } else {
            this.restoredFromPreviousSettings = true;
            this.settings = section;
        }
    }

    protected void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    protected abstract void initializeDefaultSettings();

    protected abstract boolean getWizardComplete();

    public boolean isSkipNext() {
        return false;
    }
}

