/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Contain;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Contains;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;

public interface TitanPredicate
extends Predicate {
    public boolean isValidCondition(Object var1);

    public boolean isValidValueType(Class<?> var1);

    public boolean hasNegation();

    public TitanPredicate negate();

    public boolean isQNF();

    public boolean evaluate(Object var1, Object var2);

    public static class Converter {
        public static final TitanPredicate convert(Predicate p) {
            if (p instanceof TitanPredicate) {
                return (TitanPredicate)p;
            }
            if (p instanceof Query.Compare) {
                Query.Compare comp = (Query.Compare)p;
                switch (comp) {
                    case EQUAL: {
                        return Cmp.EQUAL;
                    }
                    case NOT_EQUAL: {
                        return Cmp.NOT_EQUAL;
                    }
                    case GREATER_THAN: {
                        return Cmp.GREATER_THAN;
                    }
                    case GREATER_THAN_EQUAL: {
                        return Cmp.GREATER_THAN_EQUAL;
                    }
                    case LESS_THAN: {
                        return Cmp.LESS_THAN;
                    }
                    case LESS_THAN_EQUAL: {
                        return Cmp.LESS_THAN_EQUAL;
                    }
                }
                throw new IllegalArgumentException("Unexpected comparator: " + comp);
            }
            if (p instanceof Compare) {
                Compare comp = (Compare)p;
                switch (comp) {
                    case EQUAL: {
                        return Cmp.EQUAL;
                    }
                    case NOT_EQUAL: {
                        return Cmp.NOT_EQUAL;
                    }
                    case GREATER_THAN: {
                        return Cmp.GREATER_THAN;
                    }
                    case GREATER_THAN_EQUAL: {
                        return Cmp.GREATER_THAN_EQUAL;
                    }
                    case LESS_THAN: {
                        return Cmp.LESS_THAN;
                    }
                    case LESS_THAN_EQUAL: {
                        return Cmp.LESS_THAN_EQUAL;
                    }
                }
                throw new IllegalArgumentException("Unexpected comparator: " + comp);
            }
            if (p instanceof Contains) {
                Contains con = (Contains)p;
                switch (con) {
                    case IN: {
                        return Contain.IN;
                    }
                    case NOT_IN: {
                        return Contain.NOT_IN;
                    }
                }
                throw new IllegalArgumentException("Unexpected container: " + con);
            }
            throw new IllegalArgumentException("Titan does not support the given predicate: " + p);
        }
    }
}

