/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoInstanceCache;
import com.thinkaurelius.titan.graphdb.database.serialize.kryo.KryoInstanceCacheImpl;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;

public class KryoSerializer
implements Closeable {
    public static final int DEFAULT_MAX_OUTPUT_SIZE = 0xA00000;
    public static final int KRYO_ID_OFFSET = 50;
    private final int maxOutputSize;
    private final KryoInstanceCache kryos;
    private static final StaticBuffer.Factory<Input> INPUT_FACTORY = new StaticBuffer.Factory<Input>(){

        @Override
        public Input get(byte[] array, int offset, int limit) {
            return new Input(Arrays.copyOfRange(array, offset, limit));
        }
    };
    private final Cache<Class<?>, Boolean> objectVerificationCache = CacheBuilder.newBuilder().maximumSize(10000L).concurrencyLevel(4).initialCapacity(32).build();

    @Deprecated
    public KryoSerializer(List<Class> defaultRegistrations) {
        this(defaultRegistrations, false);
    }

    @Deprecated
    public KryoSerializer(List<Class> defaultRegistrations, boolean registrationRequired) {
        this(defaultRegistrations, registrationRequired, 0xA00000);
    }

    @Deprecated
    public KryoSerializer(List<Class> defaultRegistrations, boolean registrationRequired, int maxOutputSize) {
        this(defaultRegistrations, registrationRequired, maxOutputSize, GraphDatabaseConfiguration.KRYO_INSTANCE_CACHE.getDefaultValue());
    }

    public KryoSerializer(final List<Class> defaultRegistrations, final boolean registrationRequired, int maxOutputSize, KryoInstanceCacheImpl kcache) {
        this.maxOutputSize = maxOutputSize;
        for (Class clazz : defaultRegistrations) {
            this.objectVerificationCache.put((Object)clazz, (Object)Boolean.TRUE);
        }
        Function<Kryo, Void> kryoInitFunc = new Function<Kryo, Void>(){

            public Void apply(Kryo k) {
                k.setRegistrationRequired(registrationRequired);
                k.register(Class.class, (Serializer)new DefaultSerializers.ClassSerializer());
                for (int i = 0; i < defaultRegistrations.size(); ++i) {
                    Class clazz = (Class)defaultRegistrations.get(i);
                    k.register(clazz, 50 + i);
                }
                return null;
            }
        };
        this.kryos = kcache.createManager(kryoInitFunc);
    }

    Kryo getKryo() {
        return this.kryos.get();
    }

    public Object readClassAndObject(ReadBuffer buffer) {
        Input i = buffer.asRelative(INPUT_FACTORY);
        int startPos = i.position();
        Object value = this.getKryo().readClassAndObject(i);
        buffer.movePositionTo(buffer.getPosition() + i.position() - startPos);
        return value;
    }

    public <T> T readObjectNotNull(ReadBuffer buffer, Class<T> type) {
        Input i = buffer.asRelative(INPUT_FACTORY);
        int startPos = i.position();
        Object value = this.getKryo().readObject(i, type);
        buffer.movePositionTo(buffer.getPosition() + i.position() - startPos);
        return (T)value;
    }

    private Output getOutput(Object object) {
        return new Output(128, this.maxOutputSize);
    }

    private void writeOutput(WriteBuffer out, Output output) {
        byte[] array = output.getBuffer();
        int limit = output.position();
        for (int i = 0; i < limit; ++i) {
            out.putByte(array[i]);
        }
    }

    public void writeObjectNotNull(WriteBuffer out, Object object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkArgument((boolean)this.isValidObject(object), (String)"Cannot de-/serialize object: %s", (Object[])new Object[]{object});
        Output output = this.getOutput(object);
        this.getKryo().writeObject(output, object);
        this.writeOutput(out, output);
    }

    public void writeClassAndObject(WriteBuffer out, Object object) {
        Preconditions.checkArgument((boolean)this.isValidObject(object), (String)"Cannot de-/serialize object: %s", (Object[])new Object[]{object});
        Output output = this.getOutput(object);
        this.getKryo().writeClassAndObject(output, object);
        this.writeOutput(out, output);
    }

    final boolean isValidObject(Object o) {
        if (o == null) {
            return true;
        }
        Boolean status = (Boolean)this.objectVerificationCache.getIfPresent(o.getClass());
        if (status == null) {
            Kryo kryo = this.getKryo();
            if (!(kryo.getSerializer(o.getClass()) instanceof FieldSerializer)) {
                status = Boolean.TRUE;
            } else if (!KryoSerializer.isValidClass(o.getClass())) {
                status = Boolean.FALSE;
            } else {
                try {
                    Output out = new Output(128, this.maxOutputSize);
                    kryo.writeClassAndObject(out, o);
                    Input in = new Input(out.getBuffer(), 0, out.position());
                    Object ocopy = kryo.readClassAndObject(in);
                    status = o.equals(ocopy) ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (Throwable e) {
                    status = Boolean.FALSE;
                }
            }
            this.objectVerificationCache.put(o.getClass(), (Object)status);
        }
        return status;
    }

    public static final boolean isValidClass(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.isArray()) {
            return KryoSerializer.isValidClass(type.getComponentType());
        }
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.kryos);
    }

    private static class TypeRegistration {
        final Class type;
        final Serializer serializer;

        TypeRegistration(Class type, Serializer serializer) {
            this.type = type;
            this.serializer = serializer;
        }
    }
}

