/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idassigner;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDBlockSizer;

public class StaticIDBlockSizer
implements IDBlockSizer {
    private final long blockSize;
    private final long blockSizeLimit;

    public StaticIDBlockSizer(long blockSize, long blockSizeLimit) {
        Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((blockSizeLimit > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((blockSizeLimit > blockSize ? 1 : 0) != 0, (String)"%s vs %s", (Object[])new Object[]{blockSizeLimit, blockSize});
        this.blockSize = blockSize;
        this.blockSizeLimit = blockSizeLimit;
    }

    @Override
    public long getBlockSize(int idNamespace) {
        return this.blockSize;
    }

    @Override
    public long getIdUpperBound(int idNamespace) {
        return this.blockSizeLimit;
    }
}

