/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.configuration;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.AttributeHandler;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;

public class RegisteredAttributeClass<T> {
    private final Class<T> type;
    private final AttributeHandler<T> serializer;

    public RegisteredAttributeClass(Class<T> type, AttributeHandler<T> serializer) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(serializer);
        this.type = type;
        this.serializer = serializer;
    }

    void registerWith(Serializer s) {
        s.registerClass(this.type, this.serializer);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        return this.type.equals(((RegisteredAttributeClass)oth).type);
    }

    public int hashCode() {
        return this.type.hashCode() + 110432;
    }

    public String toString() {
        return this.type.toString();
    }
}

