/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntryList;
import com.thinkaurelius.titan.graphdb.query.BackendQuery;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class SliceQuery
extends BaseQuery
implements BackendQuery<SliceQuery> {
    public static final boolean DEFAULT_STATIC = false;
    private final StaticBuffer sliceStart;
    private final StaticBuffer sliceEnd;

    public SliceQuery(StaticBuffer sliceStart, StaticBuffer sliceEnd) {
        assert (sliceStart != null && sliceEnd != null);
        this.sliceStart = sliceStart;
        this.sliceEnd = sliceEnd;
    }

    public SliceQuery(SliceQuery query) {
        this(query.getSliceStart(), query.getSliceEnd());
        this.setLimit(query.getLimit());
    }

    public StaticBuffer getSliceStart() {
        return this.sliceStart;
    }

    public StaticBuffer getSliceEnd() {
        return this.sliceEnd;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.sliceStart).append((Object)this.sliceEnd).append(this.getLimit()).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null && !this.getClass().isInstance(other)) {
            return false;
        }
        SliceQuery oth = (SliceQuery)other;
        return this.sliceStart.equals(oth.sliceStart) && this.sliceEnd.equals(oth.sliceEnd) && this.getLimit() == oth.getLimit();
    }

    public boolean subsumes(SliceQuery oth) {
        Preconditions.checkNotNull((Object)oth);
        if (this == oth) {
            return true;
        }
        if (oth.getLimit() > this.getLimit()) {
            return false;
        }
        if (!this.hasLimit()) {
            return this.sliceStart.compareTo(oth.sliceStart) <= 0 && this.sliceEnd.compareTo(oth.sliceEnd) >= 0;
        }
        return this.sliceStart.compareTo(oth.sliceStart) == 0 && this.sliceEnd.compareTo(oth.sliceEnd) >= 0;
    }

    public EntryList getSubset(SliceQuery otherQuery, EntryList otherResult) {
        Entry e;
        assert (otherQuery.subsumes(this));
        int pos = Collections.binarySearch(otherResult, this.sliceStart);
        if (pos < 0) {
            pos = -pos - 1;
        }
        ArrayList<Entry> result = new ArrayList<Entry>();
        while (pos < otherResult.size() && result.size() < this.getLimit() && (e = (Entry)otherResult.get(pos)).getColumnAs(StaticBuffer.STATIC_FACTORY).compareTo(this.sliceEnd) < 0) {
            result.add(e);
            ++pos;
        }
        return StaticArrayEntryList.of(result);
    }

    public static StaticBuffer pointRange(StaticBuffer point) {
        return BufferUtil.nextBiggerBuffer(point);
    }

    @Override
    public SliceQuery setLimit(int limit) {
        Preconditions.checkArgument((!this.hasLimit() ? 1 : 0) != 0);
        super.setLimit(limit);
        return this;
    }

    @Override
    public SliceQuery updateLimit(int newLimit) {
        return new SliceQuery(this.sliceStart, this.sliceEnd).setLimit(newLimit);
    }
}

