/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mapping;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;

public class MappedField
implements Serializable {
    private final Set<String> names;
    private Integer id;
    private MappedFields nestedMapping;

    public static MappedField of(Integer id, String name) {
        return new MappedField(id, (Iterable<String>)ImmutableSet.of((Object)name), null);
    }

    public static MappedField of(Integer id, Iterable<String> names) {
        return new MappedField(id, names, null);
    }

    public static MappedField of(Integer id, String name, MappedFields nestedMapping) {
        return new MappedField(id, (Iterable<String>)ImmutableSet.of((Object)name), nestedMapping);
    }

    public static MappedField of(Integer id, Iterable<String> names, MappedFields nestedMapping) {
        return new MappedField(id, names, nestedMapping);
    }

    private MappedField(Integer id, Iterable<String> names, MappedFields nested) {
        this.id = id;
        this.names = ImmutableSet.copyOf(names);
        this.nestedMapping = nested;
    }

    public Integer id() {
        return this.id;
    }

    public Set<String> names() {
        return this.names;
    }

    public MappedFields nestedMapping() {
        return this.nestedMapping;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MappedField)) {
            return false;
        }
        MappedField that = (MappedField)other;
        return this.names.equals(that.names) && Objects.equals(this.id, that.id) && Objects.equals(this.nestedMapping, that.nestedMapping);
    }

    public int hashCode() {
        return Objects.hash(this.names, this.id, this.nestedMapping);
    }

    public String toString() {
        return "([" + Joiner.on((String)", ").join(this.names) + "] -> " + (this.id != null ? this.id : "?") + (this.nestedMapping != null ? ", " + this.nestedMapping + ")" : ")");
    }
}

