/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.lazy;

import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.lazy.AbstractLazyNestedVisitablePointable;
import org.apache.asterix.om.lazy.AbstractLazyVisitablePointable;
import org.apache.asterix.om.lazy.GenericLazyVisitablePointable;
import org.apache.asterix.om.lazy.ILazyVisitablePointableVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;

public class RecordLazyVisitablePointable
extends AbstractLazyNestedVisitablePointable {
    protected final VoidPointable currentFieldName = new VoidPointable();
    protected final AbstractLazyVisitablePointable openVisitable = new GenericLazyVisitablePointable();
    private int openValuesOffset;
    private int numberOfOpenChildren;

    public RecordLazyVisitablePointable(boolean tagged) {
        super(tagged, ATypeTag.OBJECT);
    }

    @Override
    public void nextChild() throws HyracksDataException {
        byte[] data = this.getByteArray();
        int fieldNameLength = NonTaggedFormatUtil.getFieldValueLength(data, this.openValuesOffset, ATypeTag.STRING, false);
        this.currentFieldName.set(data, this.openValuesOffset, fieldNameLength);
        this.openValuesOffset += fieldNameLength;
        this.currentChildTypeTag = data[this.openValuesOffset];
        int valueLength = NonTaggedFormatUtil.getFieldValueLength(data, this.openValuesOffset, this.getChildTypeTag(), true) + 1;
        this.currentValue.set(data, this.openValuesOffset, valueLength);
        this.openValuesOffset += valueLength;
    }

    @Override
    public boolean isTaggedChild() {
        return true;
    }

    @Override
    public int getNumberOfChildren() {
        return this.numberOfOpenChildren;
    }

    public IValueReference getFieldName() {
        return this.currentFieldName;
    }

    @Override
    public AbstractLazyVisitablePointable getChildVisitablePointable() throws HyracksDataException {
        this.openVisitable.set(this.getChildValue());
        return this.openVisitable;
    }

    @Override
    public final <R, T> R accept(ILazyVisitablePointableVisitor<R, T> visitor, T arg) throws HyracksDataException {
        return visitor.visit(this, arg);
    }

    @Override
    void init(byte[] data, int offset, int length) {
        this.initOpenPart(data, offset);
    }

    protected int initOpenPart(byte[] data, int pointer) {
        int skipTypeTag = this.isTagged() ? 1 : 0;
        int currentPointer = pointer + skipTypeTag + 4;
        boolean isExpanded = data[currentPointer] == 1;
        ++currentPointer;
        if (isExpanded) {
            int openPartStart = pointer + AInt32SerializerDeserializer.getInt(data, currentPointer) - (this.isTagged() ? 0 : 1);
            currentPointer += 4;
            this.numberOfOpenChildren = AInt32SerializerDeserializer.getInt(data, openPartStart);
            this.openValuesOffset = openPartStart + 4 + 8 * this.numberOfOpenChildren;
        } else {
            this.numberOfOpenChildren = 0;
        }
        return currentPointer;
    }
}

