/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.dataflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LsmResource;
import org.apache.hyracks.storage.am.lsm.rtree.utils.LSMRTreeUtils;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IStorageManager;

public class LSMRTreeWithAntiMatterLocalResource
extends LsmResource {
    private static final long serialVersionUID = 1L;
    protected final IBinaryComparatorFactory[] btreeCmpFactories;
    protected final IPrimitiveValueProviderFactory[] valueProviderFactories;
    protected final RTreePolicyType rtreePolicyType;
    protected final ILinearizeComparatorFactory linearizeCmpFactory;
    protected final int[] rtreeFields;
    protected final boolean isPointMBR;

    public LSMRTreeWithAntiMatterLocalResource(String path, IStorageManager storageManager, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] rtreeCmpFactories, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] filterFields, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory, IVirtualBufferCacheProvider vbcProvider, ILSMIOOperationSchedulerProvider ioSchedulerProvider, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, IBinaryComparatorFactory[] btreeCmpFactories, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType, ILinearizeComparatorFactory linearizeCmpFactory, int[] rtreeFields, boolean isPointMBR, boolean durable, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        super(path, storageManager, typeTraits, rtreeCmpFactories, filterTypeTraits, filterCmpFactories, filterFields, opTrackerProvider, ioOpCallbackFactory, pageWriteCallbackFactory, metadataPageManagerFactory, vbcProvider, ioSchedulerProvider, mergePolicyFactory, mergePolicyProperties, durable, nullTypeTraits, nullIntrospector);
        this.btreeCmpFactories = btreeCmpFactories;
        this.valueProviderFactories = valueProviderFactories;
        this.rtreePolicyType = rtreePolicyType;
        this.linearizeCmpFactory = linearizeCmpFactory;
        this.rtreeFields = rtreeFields;
        this.isPointMBR = isPointMBR;
    }

    private LSMRTreeWithAntiMatterLocalResource(IPersistedResourceRegistry registry, JsonNode json, IBinaryComparatorFactory[] btreeCmpFactories, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType, ILinearizeComparatorFactory linearizeCmpFactory, int[] rtreeFields, boolean isPointMBR) throws HyracksDataException {
        super(registry, json);
        this.btreeCmpFactories = btreeCmpFactories;
        this.valueProviderFactories = valueProviderFactories;
        this.rtreePolicyType = rtreePolicyType;
        this.linearizeCmpFactory = linearizeCmpFactory;
        this.rtreeFields = rtreeFields;
        this.isPointMBR = isPointMBR;
    }

    public ILSMIndex createInstance(INCServiceContext serviceCtx) throws HyracksDataException {
        IIOManager ioManager = this.storageManager.getIoManager(serviceCtx);
        FileReference file = ioManager.resolve(this.path);
        List virtualBufferCaches = this.vbcProvider.getVirtualBufferCaches(serviceCtx, file);
        this.ioOpCallbackFactory.initialize(serviceCtx, (IResource)this);
        this.pageWriteCallbackFactory.initialize(serviceCtx, (IResource)this);
        return LSMRTreeUtils.createLSMTreeWithAntiMatterTuples(ioManager, virtualBufferCaches, file, this.storageManager.getBufferCache(serviceCtx), this.typeTraits, this.cmpFactories, this.btreeCmpFactories, this.valueProviderFactories, this.rtreePolicyType, this.mergePolicyFactory.createMergePolicy(this.mergePolicyProperties, serviceCtx), this.opTrackerProvider.getOperationTracker(serviceCtx, (IResource)this), this.ioSchedulerProvider.getIoScheduler(serviceCtx), this.ioOpCallbackFactory, this.pageWriteCallbackFactory, this.linearizeCmpFactory, this.rtreeFields, this.filterTypeTraits, this.filterCmpFactories, this.filterFields, this.durable, this.isPointMBR, this.metadataPageManagerFactory, this.nullTypeTraits, this.nullIntrospector);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode jsonObject = registry.getClassIdentifier(((Object)((Object)this)).getClass(), 1L);
        super.appendToJson(jsonObject, registry);
        ArrayNode btreeCmpFactoriesArray = OBJECT_MAPPER.createArrayNode();
        for (IBinaryComparatorFactory factory : this.btreeCmpFactories) {
            btreeCmpFactoriesArray.add(factory.toJson(registry));
        }
        jsonObject.set("btreeCmpFactories", (JsonNode)btreeCmpFactoriesArray);
        jsonObject.set("linearizeCmpFactory", this.linearizeCmpFactory.toJson(registry));
        ArrayNode valueProviderFactoriesArray = OBJECT_MAPPER.createArrayNode();
        for (IPrimitiveValueProviderFactory factory : this.valueProviderFactories) {
            valueProviderFactoriesArray.add(factory.toJson(registry));
        }
        jsonObject.set("valueProviderFactories", (JsonNode)valueProviderFactoriesArray);
        jsonObject.set("rtreePolicyType", this.rtreePolicyType.toJson(registry));
        jsonObject.putPOJO("rtreeFields", (Object)this.rtreeFields);
        jsonObject.put("isPointMBR", this.isPointMBR);
        return jsonObject;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        int[] rtreeFields = (int[])OBJECT_MAPPER.convertValue((Object)json.get("rtreeFields"), int[].class);
        boolean isPointMBR = json.get("isPointMBR").asBoolean();
        RTreePolicyType rtreePolicyType = (RTreePolicyType)registry.deserialize(json.get("rtreePolicyType"));
        ILinearizeComparatorFactory linearizeCmpFactory = (ILinearizeComparatorFactory)registry.deserialize(json.get("linearizeCmpFactory"));
        ArrayList<IBinaryComparatorFactory> btreeCmpFactoriesList = new ArrayList<IBinaryComparatorFactory>();
        ArrayNode jsonBtreeCmpFactories = (ArrayNode)json.get("btreeCmpFactories");
        for (JsonNode cf : jsonBtreeCmpFactories) {
            btreeCmpFactoriesList.add((IBinaryComparatorFactory)registry.deserialize(cf));
        }
        IBinaryComparatorFactory[] btreeCmpFactories = btreeCmpFactoriesList.toArray(new IBinaryComparatorFactory[0]);
        ArrayList<IPrimitiveValueProviderFactory> valueProviderFactoriesList = new ArrayList<IPrimitiveValueProviderFactory>();
        ArrayNode jsonValueProviderFactories = (ArrayNode)json.get("valueProviderFactories");
        for (JsonNode cf : jsonValueProviderFactories) {
            valueProviderFactoriesList.add((IPrimitiveValueProviderFactory)registry.deserialize(cf));
        }
        IPrimitiveValueProviderFactory[] valueProviderFactories = valueProviderFactoriesList.toArray(new IPrimitiveValueProviderFactory[0]);
        return new LSMRTreeWithAntiMatterLocalResource(registry, json, btreeCmpFactories, valueProviderFactories, rtreePolicyType, linearizeCmpFactory, rtreeFields, isPointMBR);
    }
}

