/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.unnestingfunctions.std;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.unnestingfunctions.base.AbstractUnnestingFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class SpatialTileDescriptor
extends AbstractUnnestingFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new SpatialTileDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SPATIAL_TILE;
    }

    public IUnnestingEvaluatorFactory createUnnestingEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IUnnestingEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IUnnestingEvaluator createUnnestingEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                IHyracksTaskContext hyracksTaskContext = ctx.getTaskContext();
                return new IUnnestingEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private List<Integer> tileValues = new ArrayList<Integer>();
                    private final IPointable inputArg0 = new VoidPointable();
                    private final IPointable inputArg1 = new VoidPointable();
                    private final IPointable inputArg2 = new VoidPointable();
                    private final IPointable inputArg3 = new VoidPointable();
                    private final IScalarEvaluator eval0;
                    private final IScalarEvaluator eval1;
                    private final IScalarEvaluator eval2;
                    private final IScalarEvaluator eval3;
                    private final AMutableInt32 aInt32;
                    int pos;
                    private final ISerializerDeserializer intSerde;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.eval2 = args[2].createScalarEvaluator(ctx);
                        this.eval3 = args[3].createScalarEvaluator(ctx);
                        this.aInt32 = new AMutableInt32(0);
                        this.intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                    }

                    public void init(IFrameTupleReference tuple) throws HyracksDataException {
                        this.eval0.evaluate(tuple, this.inputArg0);
                        this.eval1.evaluate(tuple, this.inputArg1);
                        this.eval2.evaluate(tuple, this.inputArg2);
                        this.eval3.evaluate(tuple, this.inputArg3);
                        byte[] bytes0 = this.inputArg0.getByteArray();
                        byte[] bytes1 = this.inputArg1.getByteArray();
                        byte[] bytes2 = this.inputArg2.getByteArray();
                        byte[] bytes3 = this.inputArg3.getByteArray();
                        int offset0 = this.inputArg0.getStartOffset();
                        int offset1 = this.inputArg1.getStartOffset();
                        int offset2 = this.inputArg2.getStartOffset();
                        int offset3 = this.inputArg3.getStartOffset();
                        ATypeTag tag0 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
                        ATypeTag tag1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
                        ATypeTag tag2 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes2[offset2]);
                        ATypeTag tag3 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes3[offset3]);
                        if (tag0 != ATypeTag.RECTANGLE) {
                            throw new TypeMismatchException(SpatialTileDescriptor.this.sourceLoc, SpatialTileDescriptor.this.getIdentifier(), 0, bytes0[offset0], ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                        }
                        if (tag1 != ATypeTag.RECTANGLE) {
                            throw new TypeMismatchException(SpatialTileDescriptor.this.sourceLoc, SpatialTileDescriptor.this.getIdentifier(), 0, bytes1[offset1], ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                        }
                        double x1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double y1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                        double y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                        double minX = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double minY = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double maxX = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                        double maxY = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                        int rows = ATypeHierarchy.getIntegerValue((String)SpatialTileDescriptor.this.getIdentifier().getName(), (int)0, (byte[])bytes2, (int)offset2);
                        int columns = ATypeHierarchy.getIntegerValue((String)SpatialTileDescriptor.this.getIdentifier().getName(), (int)0, (byte[])bytes3, (int)offset3);
                        this.tileValues.clear();
                        this.pos = 0;
                        if (!(minX == 0.0 && minY == 0.0 && maxX == 0.0 && maxY == 0.0 || x1 > maxX || minX > x2 || y1 > maxY || minY > y2)) {
                            int row1 = (int)Math.ceil((y1 - minY) * (double)rows / (maxY - minY));
                            int col1 = (int)Math.ceil((x1 - minX) * (double)columns / (maxX - minX));
                            int row2 = (int)Math.ceil((y2 - minY) * (double)rows / (maxY - minY));
                            int col2 = (int)Math.ceil((x2 - minX) * (double)columns / (maxX - minX));
                            row1 = Math.min(Math.max(1, row1), rows * columns);
                            col1 = Math.min(Math.max(1, col1), rows * columns);
                            row2 = Math.min(Math.max(1, row2), rows * columns);
                            col2 = Math.min(Math.max(1, col2), rows * columns);
                            int minRow = Math.min(row1, row2);
                            int maxRow = Math.max(row1, row2);
                            int minCol = Math.min(col1, col2);
                            int maxCol = Math.max(col1, col2);
                            for (int i = minRow; i <= maxRow; ++i) {
                                for (int j = minCol; j <= maxCol; ++j) {
                                    int tileId = (i - 1) * columns + j;
                                    this.tileValues.add(tileId);
                                }
                            }
                        }
                    }

                    public boolean step(IPointable result) throws HyracksDataException {
                        if (this.pos < this.tileValues.size()) {
                            this.aInt32.setValue(this.tileValues.get(this.pos).intValue());
                            this.resultStorage.reset();
                            this.intSerde.serialize((Object)this.aInt32, this.resultStorage.getDataOutput());
                            result.set((IValueReference)this.resultStorage);
                            ++this.pos;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }
}

