/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABinary;
import org.apache.asterix.om.base.AMutableBinary;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.binary.AbstractBinaryScalarEvaluator;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.bytes.Base64Parser;
import org.apache.hyracks.util.bytes.HexParser;

@MissingNullInOutFunction
public class ParseBinaryDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private static final UTF8StringPointable HEX_FORMAT = UTF8StringPointable.generateUTF8Pointable((String)"hex");
    private static final UTF8StringPointable BASE64_FORMAT = UTF8StringPointable.generateUTF8Pointable((String)"base64");
    public static final IFunctionDescriptorFactory FACTORY = ParseBinaryDescriptor::new;
    public static final ATypeTag[] EXPECTED_INPUT_TAGS = new ATypeTag[]{ATypeTag.STRING, ATypeTag.STRING};

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.PARSE_BINARY;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractBinaryScalarEvaluator(ctx, args, ParseBinaryDescriptor.this.getIdentifier(), ParseBinaryDescriptor.this.sourceLoc){
                    private ISerializerDeserializer<ABinary> binarySerde;
                    private AMutableBinary aBinary;
                    private final UTF8StringPointable stringPointable;
                    private final UTF8StringPointable formatPointable;
                    private final HexParser hexParser;
                    private final Base64Parser base64Parser;
                    {
                        this.binarySerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABINARY);
                        this.aBinary = new AMutableBinary(new byte[0], 0, 0);
                        this.stringPointable = new UTF8StringPointable();
                        this.formatPointable = new UTF8StringPointable();
                        this.hexParser = new HexParser();
                        this.base64Parser = new Base64Parser();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evaluators[0].evaluate(tuple, this.pointables[0]);
                        this.evaluators[1].evaluate(tuple, this.pointables[1]);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.pointables[0], this.pointables[1])) {
                            return;
                        }
                        ATypeTag binaryTag = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[0].getByteArray()[this.pointables[0].getStartOffset()]];
                        ATypeTag formatTag = ATypeTag.VALUE_TYPE_MAPPING[this.pointables[1].getByteArray()[this.pointables[1].getStartOffset()]];
                        this.checkTypeMachingThrowsIfNot(EXPECTED_INPUT_TAGS, binaryTag, formatTag);
                        this.stringPointable.set(this.pointables[0].getByteArray(), this.pointables[0].getStartOffset() + 1, this.pointables[0].getLength());
                        this.formatPointable.set(this.pointables[1].getByteArray(), this.pointables[1].getStartOffset() + 1, this.pointables[1].getLength());
                        if (HEX_FORMAT.ignoreCaseCompareTo(this.formatPointable) == 0) {
                            this.hexParser.generateByteArrayFromHexString(this.stringPointable.getByteArray(), this.stringPointable.getCharStartOffset(), this.stringPointable.getUTF8Length());
                            this.aBinary.setValue(this.hexParser.getByteArray(), 0, this.hexParser.getLength());
                        } else if (BASE64_FORMAT.ignoreCaseCompareTo(this.formatPointable) == 0) {
                            this.base64Parser.generatePureByteArrayFromBase64String(this.stringPointable.getByteArray(), this.stringPointable.getCharStartOffset(), this.stringPointable.getUTF8Length());
                            this.aBinary.setValue(this.base64Parser.getByteArray(), 0, this.base64Parser.getLength());
                        } else {
                            throw new UnsupportedItemTypeException(this.sourceLoc, ParseBinaryDescriptor.this.getIdentifier(), formatTag.serialize());
                        }
                        this.binarySerde.serialize((Object)this.aBinary, this.dataOutput);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

