/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class ToNumberDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = ToNumberDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                final IScalarEvaluator inputEval = args[0].createScalarEvaluator(ctx);
                VoidPointable inputArg = new VoidPointable();
                ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                DataOutput out = resultStorage.getDataOutput();
                AMutableInt64 aInt64 = new AMutableInt64(0L);
                AMutableDouble aDouble = new AMutableDouble(0.0);
                UTF8StringPointable utf8Ptr = new UTF8StringPointable();
                MutableBoolean maybeNumeric = new MutableBoolean();
                ISerializerDeserializer INT64_SERDE = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                ISerializerDeserializer DOUBLE_SERDE = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                return new IScalarEvaluator((IPointable)inputArg, resultStorage, aInt64, INT64_SERDE, out, utf8Ptr, maybeNumeric, aDouble, DOUBLE_SERDE){
                    final /* synthetic */ IPointable val$inputArg;
                    final /* synthetic */ ArrayBackedValueStorage val$resultStorage;
                    final /* synthetic */ AMutableInt64 val$aInt64;
                    final /* synthetic */ ISerializerDeserializer val$INT64_SERDE;
                    final /* synthetic */ DataOutput val$out;
                    final /* synthetic */ UTF8StringPointable val$utf8Ptr;
                    final /* synthetic */ MutableBoolean val$maybeNumeric;
                    final /* synthetic */ AMutableDouble val$aDouble;
                    final /* synthetic */ ISerializerDeserializer val$DOUBLE_SERDE;
                    {
                        this.val$inputArg = iPointable;
                        this.val$resultStorage = arrayBackedValueStorage;
                        this.val$aInt64 = aMutableInt64;
                        this.val$INT64_SERDE = iSerializerDeserializer;
                        this.val$out = dataOutput;
                        this.val$utf8Ptr = uTF8StringPointable;
                        this.val$maybeNumeric = mutableBoolean;
                        this.val$aDouble = aMutableDouble;
                        this.val$DOUBLE_SERDE = iSerializerDeserializer2;
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        inputEval.evaluate(tuple, this.val$inputArg);
                        this.val$resultStorage.reset();
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.val$inputArg)) {
                            return;
                        }
                        byte[] bytes = this.val$inputArg.getByteArray();
                        int startOffset = this.val$inputArg.getStartOffset();
                        ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[bytes[startOffset]];
                        switch (tt) {
                            case TINYINT: 
                            case SMALLINT: 
                            case INTEGER: 
                            case BIGINT: 
                            case FLOAT: 
                            case DOUBLE: {
                                result.set((IValueReference)this.val$inputArg);
                                break;
                            }
                            case BOOLEAN: {
                                boolean b = ABooleanSerializerDeserializer.getBoolean((byte[])bytes, (int)(startOffset + 1));
                                this.val$aInt64.setValue(b ? 1L : 0L);
                                this.val$INT64_SERDE.serialize((Object)this.val$aInt64, this.val$out);
                                result.set((IValueReference)this.val$resultStorage);
                                break;
                            }
                            case STRING: {
                                this.val$utf8Ptr.set(bytes, startOffset + 1, this.val$inputArg.getLength() - 1);
                                if (NumberUtils.parseInt64(this.val$utf8Ptr, this.val$aInt64, this.val$maybeNumeric)) {
                                    this.val$INT64_SERDE.serialize((Object)this.val$aInt64, this.val$out);
                                    result.set((IValueReference)this.val$resultStorage);
                                    break;
                                }
                                if (this.val$maybeNumeric.booleanValue() && NumberUtils.parseDouble(this.val$utf8Ptr, this.val$aDouble)) {
                                    this.val$DOUBLE_SERDE.serialize((Object)this.val$aDouble, this.val$out);
                                    result.set((IValueReference)this.val$resultStorage);
                                    break;
                                }
                                PointableHelper.setNull(result);
                                break;
                            }
                            case ARRAY: 
                            case MULTISET: 
                            case OBJECT: {
                                PointableHelper.setNull(result);
                                break;
                            }
                            default: {
                                throw new TypeMismatchException(ToNumberDescriptor.this.sourceLoc, ToNumberDescriptor.this.getIdentifier(), 0, bytes[startOffset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG, ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG, ATypeTag.SERIALIZED_STRING_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.TO_NUMBER;
    }
}

