/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.temporal.AsterixTemporalTypeParseException;
import org.apache.asterix.om.base.temporal.DateTimeFormatUtils;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.constructors.AbstractDateTimeConstructorEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractDateTimeConstructorWithFormatEvaluator
extends AbstractDateTimeConstructorEvaluator {
    private final IScalarEvaluator formatEval;
    protected final IPointable formatArg = new VoidPointable();
    private final UTF8StringPointable formatTextPtr = new UTF8StringPointable();
    private final AMutableInt64 aInt64 = new AMutableInt64(0L);

    protected AbstractDateTimeConstructorWithFormatEvaluator(IEvaluatorContext ctx, IScalarEvaluatorFactory[] args, SourceLocation sourceLoc) throws HyracksDataException {
        super(ctx, args[0].createScalarEvaluator(ctx), sourceLoc);
        this.formatEval = args[1].createScalarEvaluator(ctx);
    }

    @Override
    protected void evaluateInput(IFrameTupleReference tuple) throws HyracksDataException {
        super.evaluateInput(tuple);
        this.formatEval.evaluate(tuple, this.formatArg);
    }

    @Override
    protected boolean checkAndSetMissingOrNull(IPointable result) throws HyracksDataException {
        return PointableHelper.checkAndSetMissingOrNull(result, this.inputArg, this.formatArg);
    }

    @Override
    protected boolean parseDateTime(UTF8StringPointable textPtr, AMutableDateTime result) {
        byte[] formatBytes = this.formatArg.getByteArray();
        int formatStartOffset = this.formatArg.getStartOffset();
        int formatLength = this.formatArg.getLength();
        if (formatBytes[formatStartOffset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            return false;
        }
        this.formatTextPtr.set(formatBytes, formatStartOffset + 1, formatLength - 1);
        try {
            if (DateTimeFormatUtils.getInstance().parseDateTime(this.aInt64, textPtr.getByteArray(), textPtr.getCharStartOffset(), textPtr.getUTF8Length(), formatBytes, this.formatTextPtr.getCharStartOffset(), this.formatTextPtr.getUTF8Length(), DateTimeFormatUtils.DateTimeParseMode.DATETIME, false)) {
                result.setValue(this.aInt64.getLongValue());
                return true;
            }
            return false;
        }
        catch (AsterixTemporalTypeParseException e) {
            return false;
        }
    }
}

