/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.util.string.UTF8StringUtil;

public abstract class AbstractBooleanConstructorEvaluator
extends AbstractConstructorEvaluator {
    protected final ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    protected static final IBinaryComparator UTF8_BINARY_CMP = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
    protected static final byte[] TRUE = UTF8StringUtil.writeStringToBytes((String)"true");
    protected static final byte[] FALSE = UTF8StringUtil.writeStringToBytes((String)"false");
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();

    protected AbstractBooleanConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case BOOLEAN: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case TINYINT: {
                this.setInteger(AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(startOffset + 1)), result);
                break;
            }
            case SMALLINT: {
                this.setInteger(AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(startOffset + 1)), result);
                break;
            }
            case INTEGER: {
                this.setInteger(AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(startOffset + 1)), result);
                break;
            }
            case BIGINT: {
                this.setInteger(AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(startOffset + 1)), result);
                break;
            }
            case FLOAT: {
                this.setDouble(AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(startOffset + 1)), result);
                break;
            }
            case DOUBLE: {
                this.setDouble(ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(startOffset + 1)), result);
                break;
            }
            case STRING: {
                Boolean v = this.parseBoolean(bytes, startOffset, len);
                if (v != null) {
                    this.setBoolean(result, v);
                    break;
                }
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    protected Boolean parseBoolean(byte[] bytes, int offset, int len) throws HyracksDataException {
        if (UTF8_BINARY_CMP.compare(bytes, offset + 1, len - 1, TRUE, 0, TRUE.length) == 0) {
            return true;
        }
        if (UTF8_BINARY_CMP.compare(bytes, offset + 1, len - 1, FALSE, 0, FALSE.length) == 0) {
            return false;
        }
        return null;
    }

    protected final void setBoolean(IPointable result, boolean value) throws HyracksDataException {
        this.resultStorage.reset();
        this.booleanSerde.serialize((Object)ABoolean.valueOf((boolean)value), this.out);
        result.set((IValueReference)this.resultStorage);
    }

    protected final void setInteger(long v, IPointable result) throws HyracksDataException {
        this.setBoolean(result, v != 0L);
    }

    protected final void setDouble(double v, IPointable result) throws HyracksDataException {
        long bits = Double.doubleToLongBits(v);
        boolean zeroOrNaN = bits == NumberUtils.POSITIVE_ZERO_BITS || bits == NumberUtils.NEGATIVE_ZERO_BITS || bits == NumberUtils.NAN_BITS;
        this.setBoolean(result, !zeroOrNaN);
    }

    @Override
    protected BuiltinType getTargetType() {
        return BuiltinType.ABOOLEAN;
    }
}

