/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.collections;

import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ListifyAggregateFunctionEvalFactory
implements IAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory[] args;
    private final AOrderedListType orderedListType;
    private final IAType itemType;
    private final SourceLocation sourceLoc;

    ListifyAggregateFunctionEvalFactory(IScalarEvaluatorFactory[] args, AOrderedListType type, IAType itemType, SourceLocation sourceLoc) {
        this.args = args;
        this.orderedListType = type;
        this.itemType = itemType;
        this.sourceLoc = sourceLoc;
    }

    public IAggregateEvaluator createAggregateEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
        return new AbstractAggregateFunction(this.sourceLoc){
            private IPointable inputVal;
            private IScalarEvaluator eval;
            private ArrayBackedValueStorage resultStorage;
            private OrderedListBuilder builder;
            private final CastTypeEvaluator caster;
            {
                super(sourceLoc);
                this.inputVal = new VoidPointable();
                this.eval = ListifyAggregateFunctionEvalFactory.this.args[0].createScalarEvaluator(ctx);
                this.resultStorage = new ArrayBackedValueStorage();
                this.builder = new OrderedListBuilder();
                this.caster = ListifyAggregateFunctionEvalFactory.this.orderedListType.getItemType().getTypeTag() == ATypeTag.ANY && !TypeHelper.isFullyOpen((IAType)ListifyAggregateFunctionEvalFactory.this.itemType) ? new CastTypeEvaluator((IAType)BuiltinType.ANY, ListifyAggregateFunctionEvalFactory.this.itemType, this.eval) : null;
            }

            public void init() throws HyracksDataException {
                this.builder.reset((AbstractCollectionType)ListifyAggregateFunctionEvalFactory.this.orderedListType);
            }

            public void step(IFrameTupleReference tuple) throws HyracksDataException {
                try {
                    if (this.caster != null) {
                        this.caster.evaluate(tuple, this.inputVal);
                    } else {
                        this.eval.evaluate(tuple, this.inputVal);
                    }
                    this.builder.addItem((IValueReference)this.inputVal);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            public void finish(IPointable result) throws HyracksDataException {
                this.resultStorage.reset();
                try {
                    this.builder.write(this.resultStorage.getDataOutput(), true);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                result.set((IValueReference)this.resultStorage);
            }

            public void finishPartial(IPointable result) throws HyracksDataException {
                this.finish(result);
            }
        };
    }
}

