/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import org.apache.asterix.app.function.TPCDSDataGeneratorReader;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.metadata.declared.AbstractDatasourceFunction;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class TPCDSDataGeneratorFunction
extends AbstractDatasourceFunction {
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final double scalingFactor;
    private final int parallelism;
    private final FunctionIdentifier functionIdentifier;

    TPCDSDataGeneratorFunction(AlgebricksAbsolutePartitionConstraint locations, String tableName, double scalingFactor, FunctionIdentifier functionIdentifier) {
        super(locations);
        this.tableName = tableName;
        this.scalingFactor = scalingFactor;
        this.functionIdentifier = functionIdentifier;
        this.parallelism = locations.getLocations().length;
    }

    public IRecordReader<char[]> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return new TPCDSDataGeneratorReader(this.tableName, this.scalingFactor, this.parallelism, partition, this.getFunctionIdentifier());
    }

    private FunctionIdentifier getFunctionIdentifier() {
        return this.functionIdentifier;
    }
}

