/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.statistics.impl;

import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.s3guard.MetastoreInstrumentation;
import org.apache.hadoop.fs.s3a.statistics.BlockOutputStreamStatistics;
import org.apache.hadoop.fs.s3a.statistics.CommitterStatistics;
import org.apache.hadoop.fs.s3a.statistics.DelegationTokenStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AMultipartUploaderStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.s3a.statistics.StatisticsFromAwsSdk;
import org.apache.hadoop.fs.s3a.statistics.impl.S3AMultipartUploaderStatisticsImpl;
import org.apache.hadoop.fs.s3a.statistics.impl.StatisticsFromAwsSdkImpl;
import org.apache.hadoop.fs.statistics.DurationTracker;

public class BondedS3AStatisticsContext
implements S3AStatisticsContext {
    private final S3AFSStatisticsSource statisticsSource;

    public BondedS3AStatisticsContext(S3AFSStatisticsSource statisticsSource) {
        this.statisticsSource = statisticsSource;
    }

    private S3AInstrumentation getInstrumentation() {
        return this.statisticsSource.getInstrumentation();
    }

    private FileSystem.Statistics getInstanceStatistics() {
        return this.statisticsSource.getInstanceStatistics();
    }

    @Override
    public MetastoreInstrumentation getS3GuardInstrumentation() {
        return this.getInstrumentation().getS3GuardInstrumentation();
    }

    @Override
    public S3AInputStreamStatistics newInputStreamStatistics() {
        return this.getInstrumentation().newInputStreamStatistics(this.statisticsSource.getInstanceStatistics());
    }

    @Override
    public CommitterStatistics newCommitterStatistics() {
        return this.getInstrumentation().newCommitterStatistics();
    }

    @Override
    public BlockOutputStreamStatistics newOutputStreamStatistics() {
        return this.getInstrumentation().newOutputStreamStatistics(this.getInstanceStatistics());
    }

    @Override
    public void incrementCounter(Statistic op, long count) {
        this.getInstrumentation().incrementCounter(op, count);
    }

    @Override
    public void incrementGauge(Statistic op, long count) {
        this.getInstrumentation().incrementGauge(op, count);
    }

    @Override
    public void decrementGauge(Statistic op, long count) {
        this.getInstrumentation().decrementGauge(op, count);
    }

    @Override
    public void addValueToQuantiles(Statistic op, long value) {
        this.getInstrumentation().addValueToQuantiles(op, value);
    }

    @Override
    public void recordDuration(Statistic op, boolean success, Duration duration) {
        this.getInstrumentation().recordDuration(op, success, duration);
    }

    @Override
    public DelegationTokenStatistics newDelegationTokenStatistics() {
        return this.getInstrumentation().newDelegationTokenStatistics();
    }

    @Override
    public StatisticsFromAwsSdk newStatisticsFromAwsSdk() {
        return new StatisticsFromAwsSdkImpl(this.getInstrumentation());
    }

    @Override
    public S3AMultipartUploaderStatistics createMultipartUploaderStatistics() {
        return new S3AMultipartUploaderStatisticsImpl(this::incrementCounter);
    }

    public DurationTracker trackDuration(String key, long count) {
        return this.getInstrumentation().trackDuration(key, count);
    }

    public static interface S3AFSStatisticsSource {
        public S3AInstrumentation getInstrumentation();

        @Nullable
        public FileSystem.Statistics getInstanceStatistics();
    }
}

