/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.ScalingInfo;
import com.teradata.tpcds.TableFlags;
import com.teradata.tpcds.column.CallCenterColumn;
import com.teradata.tpcds.column.CatalogPageColumn;
import com.teradata.tpcds.column.CatalogReturnsColumn;
import com.teradata.tpcds.column.CatalogSalesColumn;
import com.teradata.tpcds.column.Column;
import com.teradata.tpcds.column.CustomerAddressColumn;
import com.teradata.tpcds.column.CustomerColumn;
import com.teradata.tpcds.column.CustomerDemographicsColumn;
import com.teradata.tpcds.column.DateDimColumn;
import com.teradata.tpcds.column.DbgenVersionColumn;
import com.teradata.tpcds.column.HouseholdDemographicsColumn;
import com.teradata.tpcds.column.IncomeBandColumn;
import com.teradata.tpcds.column.InventoryColumn;
import com.teradata.tpcds.column.ItemColumn;
import com.teradata.tpcds.column.PromotionColumn;
import com.teradata.tpcds.column.ReasonColumn;
import com.teradata.tpcds.column.ShipModeColumn;
import com.teradata.tpcds.column.StoreColumn;
import com.teradata.tpcds.column.StoreReturnsColumn;
import com.teradata.tpcds.column.StoreSalesColumn;
import com.teradata.tpcds.column.TimeDimColumn;
import com.teradata.tpcds.column.WarehouseColumn;
import com.teradata.tpcds.column.WebPageColumn;
import com.teradata.tpcds.column.WebReturnsColumn;
import com.teradata.tpcds.column.WebSalesColumn;
import com.teradata.tpcds.column.WebSiteColumn;
import com.teradata.tpcds.generator.CallCenterGeneratorColumn;
import com.teradata.tpcds.generator.CatalogPageGeneratorColumn;
import com.teradata.tpcds.generator.CatalogReturnsGeneratorColumn;
import com.teradata.tpcds.generator.CatalogSalesGeneratorColumn;
import com.teradata.tpcds.generator.CustomerAddressGeneratorColumn;
import com.teradata.tpcds.generator.CustomerDemographicsGeneratorColumn;
import com.teradata.tpcds.generator.CustomerGeneratorColumn;
import com.teradata.tpcds.generator.DateDimGeneratorColumn;
import com.teradata.tpcds.generator.DbgenVersionGeneratorColumn;
import com.teradata.tpcds.generator.GeneratorColumn;
import com.teradata.tpcds.generator.HouseholdDemographicsGeneratorColumn;
import com.teradata.tpcds.generator.IncomeBandGeneratorColumn;
import com.teradata.tpcds.generator.InventoryGeneratorColumn;
import com.teradata.tpcds.generator.ItemGeneratorColumn;
import com.teradata.tpcds.generator.PromotionGeneratorColumn;
import com.teradata.tpcds.generator.ReasonGeneratorColumn;
import com.teradata.tpcds.generator.ShipModeGeneratorColumn;
import com.teradata.tpcds.generator.StoreGeneratorColumn;
import com.teradata.tpcds.generator.StoreReturnsGeneratorColumn;
import com.teradata.tpcds.generator.StoreSalesGeneratorColumn;
import com.teradata.tpcds.generator.TimeDimGeneratorColumn;
import com.teradata.tpcds.generator.WarehouseGeneratorColumn;
import com.teradata.tpcds.generator.WebPageGeneratorColumn;
import com.teradata.tpcds.generator.WebReturnsGeneratorColumn;
import com.teradata.tpcds.generator.WebSalesGeneratorColumn;
import com.teradata.tpcds.generator.WebSiteGeneratorColumn;
import com.teradata.tpcds.row.generator.CallCenterRowGenerator;
import com.teradata.tpcds.row.generator.CatalogPageRowGenerator;
import com.teradata.tpcds.row.generator.CatalogReturnsRowGenerator;
import com.teradata.tpcds.row.generator.CatalogSalesRowGenerator;
import com.teradata.tpcds.row.generator.CustomerAddressRowGenerator;
import com.teradata.tpcds.row.generator.CustomerDemographicsRowGenerator;
import com.teradata.tpcds.row.generator.CustomerRowGenerator;
import com.teradata.tpcds.row.generator.DateDimRowGenerator;
import com.teradata.tpcds.row.generator.DbgenVersionRowGenerator;
import com.teradata.tpcds.row.generator.HouseholdDemographicsRowGenerator;
import com.teradata.tpcds.row.generator.IncomeBandRowGenerator;
import com.teradata.tpcds.row.generator.InventoryRowGenerator;
import com.teradata.tpcds.row.generator.ItemRowGenerator;
import com.teradata.tpcds.row.generator.PromotionRowGenerator;
import com.teradata.tpcds.row.generator.ReasonRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.ShipModeRowGenerator;
import com.teradata.tpcds.row.generator.StoreReturnsRowGenerator;
import com.teradata.tpcds.row.generator.StoreRowGenerator;
import com.teradata.tpcds.row.generator.StoreSalesRowGenerator;
import com.teradata.tpcds.row.generator.TimeDimRowGenerator;
import com.teradata.tpcds.row.generator.WarehouseRowGenerator;
import com.teradata.tpcds.row.generator.WebPageRowGenerator;
import com.teradata.tpcds.row.generator.WebReturnsRowGenerator;
import com.teradata.tpcds.row.generator.WebSalesRowGenerator;
import com.teradata.tpcds.row.generator.WebSiteRowGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public enum Table {
    CALL_CENTER(new TableFlags.TableFlagsBuilder().setIsSmall().setKeepsHistory().build(), 100, 11L, CallCenterRowGenerator.class, CallCenterGeneratorColumn.values(), CallCenterColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 3, 12, 15, 18, 21, 24, 27, 30, 30}, 0)),
    CATALOG_PAGE(new TableFlags.TableFlagsBuilder().build(), 200, 3L, CatalogPageRowGenerator.class, CatalogPageGeneratorColumn.values(), CatalogPageColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.STATIC, new int[]{0, 11718, 12000, 20400, 26000, 30000, 36000, 40000, 46000, 50000}, 0)),
    CATALOG_RETURNS(new TableFlags.TableFlagsBuilder().build(), 400, 65543L, CatalogReturnsRowGenerator.class, CatalogReturnsGeneratorColumn.values(), CatalogReturnsColumn.values(), new ScalingInfo(4, ScalingInfo.ScalingModel.LINEAR, new int[]{0, 16, 160, 1600, 4800, 16000, 48000, 160000, 480000, 1600000}, 0)),
    CATALOG_SALES(new TableFlags.TableFlagsBuilder().setIsDateBased().build(), 100, 163840L, CatalogSalesRowGenerator.class, CatalogSalesGeneratorColumn.values(), CatalogSalesColumn.values(), new ScalingInfo(4, ScalingInfo.ScalingModel.LINEAR, new int[]{0, 16, 160, 1600, 4800, 16000, 48000, 160000, 480000, 1600000}, 0)),
    CUSTOMER(new TableFlags.TableFlagsBuilder().build(), 700, 19L, CustomerRowGenerator.class, CustomerGeneratorColumn.values(), CustomerColumn.values(), new ScalingInfo(3, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 100, 500, 2000, 5000, 12000, 30000, 65000, 80000, 100000}, 0)),
    CUSTOMER_ADDRESS(new TableFlags.TableFlagsBuilder().build(), 600, 3L, CustomerAddressRowGenerator.class, CustomerAddressGeneratorColumn.values(), CustomerAddressColumn.values(), new ScalingInfo(3, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 50, 250, 1000, 2500, 6000, 15000, 32500, 40000, 50000}, 0)),
    CUSTOMER_DEMOGRAPHICS(new TableFlags.TableFlagsBuilder().build(), 0, 1L, CustomerDemographicsRowGenerator.class, CustomerDemographicsGeneratorColumn.values(), CustomerDemographicsColumn.values(), new ScalingInfo(2, ScalingInfo.ScalingModel.STATIC, new int[]{0, 19208, 19208, 19208, 19208, 19208, 19208, 19208, 19208, 19208}, 0)),
    DATE_DIM(new TableFlags.TableFlagsBuilder().build(), 0, 3L, DateDimRowGenerator.class, DateDimGeneratorColumn.values(), DateDimColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.STATIC, new int[]{0, 73049, 73049, 73049, 73049, 73049, 73049, 73049, 73049, 73049}, 0)),
    HOUSEHOLD_DEMOGRAPHICS(new TableFlags.TableFlagsBuilder().build(), 0, 1L, HouseholdDemographicsRowGenerator.class, HouseholdDemographicsGeneratorColumn.values(), HouseholdDemographicsColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.STATIC, new int[]{0, 7200, 7200, 7200, 7200, 7200, 7200, 7200, 7200, 7200}, 0)),
    INCOME_BAND(new TableFlags.TableFlagsBuilder().build(), 0, 1L, IncomeBandRowGenerator.class, IncomeBandGeneratorColumn.values(), IncomeBandColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.STATIC, new int[]{0, 20, 20, 20, 20, 20, 20, 20, 20, 20}, 0)),
    INVENTORY(new TableFlags.TableFlagsBuilder().setIsDateBased().build(), 1000, 7L, InventoryRowGenerator.class, InventoryGeneratorColumn.values(), InventoryColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 0)),
    ITEM(new TableFlags.TableFlagsBuilder().setKeepsHistory().build(), 50, 11L, ItemRowGenerator.class, ItemGeneratorColumn.values(), ItemColumn.values(), new ScalingInfo(3, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 9, 51, 102, 132, 150, 180, 201, 231, 251}, 0)),
    PROMOTION(new TableFlags.TableFlagsBuilder().build(), 200, 3L, PromotionRowGenerator.class, PromotionGeneratorColumn.values(), PromotionColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 300, 500, 1000, 1300, 1500, 1800, 2000, 2300, 2500}, 0)),
    REASON(new TableFlags.TableFlagsBuilder().build(), 0, 3L, ReasonRowGenerator.class, ReasonGeneratorColumn.values(), ReasonColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 35, 45, 55, 60, 65, 67, 70, 72, 75}, 0)),
    SHIP_MODE(new TableFlags.TableFlagsBuilder().build(), 0, 3L, ShipModeRowGenerator.class, ShipModeGeneratorColumn.values(), ShipModeColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.STATIC, new int[]{0, 20, 20, 20, 20, 20, 20, 20, 20, 20}, 0)),
    STORE(new TableFlags.TableFlagsBuilder().setKeepsHistory().setIsSmall().build(), 100, 11L, StoreRowGenerator.class, StoreGeneratorColumn.values(), StoreColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 6, 51, 201, 402, 501, 675, 750, 852, 951}, 0)),
    STORE_RETURNS(new TableFlags.TableFlagsBuilder().build(), 700, 516L, StoreReturnsRowGenerator.class, StoreReturnsGeneratorColumn.values(), StoreReturnsColumn.values(), new ScalingInfo(4, ScalingInfo.ScalingModel.LINEAR, new int[]{0, 24, 240, 2400, 7200, 24000, 72000, 240000, 720000, 2400000}, 0)),
    STORE_SALES(new TableFlags.TableFlagsBuilder().setIsDateBased().build(), 900, 516L, StoreSalesRowGenerator.class, StoreSalesGeneratorColumn.values(), StoreSalesColumn.values(), new ScalingInfo(4, ScalingInfo.ScalingModel.LINEAR, new int[]{0, 24, 240, 2400, 7200, 24000, 72000, 240000, 720000, 2400000}, 0)),
    TIME_DIM(new TableFlags.TableFlagsBuilder().build(), 0, 3L, TimeDimRowGenerator.class, TimeDimGeneratorColumn.values(), TimeDimColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.STATIC, new int[]{0, 86400, 86400, 86400, 86400, 86400, 86400, 86400, 86400, 86400}, 0)),
    WAREHOUSE(new TableFlags.TableFlagsBuilder().setIsSmall().build(), 200, 3L, WarehouseRowGenerator.class, WarehouseGeneratorColumn.values(), WarehouseColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 5, 10, 15, 17, 20, 22, 25, 27, 30}, 0)),
    WEB_PAGE(new TableFlags.TableFlagsBuilder().setKeepsHistory().build(), 250, 11L, WebPageRowGenerator.class, WebPageGeneratorColumn.values(), WebPageColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 30, 100, 1020, 1302, 1500, 1800, 2001, 2301, 2502}, 0)),
    WEB_RETURNS(new TableFlags.TableFlagsBuilder().build(), 900, 8196L, WebReturnsRowGenerator.class, WebReturnsGeneratorColumn.values(), WebReturnsColumn.values(), new ScalingInfo(3, ScalingInfo.ScalingModel.LINEAR, new int[]{0, 60, 600, 6000, 18000, 60000, 180000, 600000, 1800000, 6000000}, 0)),
    WEB_SALES(new TableFlags.TableFlagsBuilder().setIsDateBased().build(), 5, 131080L, WebSalesRowGenerator.class, WebSalesGeneratorColumn.values(), WebSalesColumn.values(), new ScalingInfo(3, ScalingInfo.ScalingModel.LINEAR, new int[]{0, 60, 600, 6000, 18000, 60000, 180000, 600000, 1800000, 6000000}, 0)),
    WEB_SITE(new TableFlags.TableFlagsBuilder().setKeepsHistory().setIsSmall().build(), 100, 11L, WebSiteRowGenerator.class, WebSiteGeneratorColumn.values(), WebSiteColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.LOGARITHMIC, new int[]{0, 15, 21, 12, 21, 27, 33, 39, 42, 48}, 0)),
    DBGEN_VERSION(new TableFlags.TableFlagsBuilder().build(), 0, 0L, DbgenVersionRowGenerator.class, DbgenVersionGeneratorColumn.values(), DbgenVersionColumn.values(), new ScalingInfo(0, ScalingInfo.ScalingModel.STATIC, new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, 0)),
    S_BRAND,
    S_CUSTOMER_ADDRESS,
    S_CALL_CENTER,
    S_CATALOG,
    S_CATALOG_ORDER,
    S_CATALOG_ORDER_LINEITEM,
    S_CATALOG_PAGE,
    S_CATALOG_PROMOTIONAL_ITEM,
    S_CATALOG_RETURNS,
    S_CATEGORY,
    S_CLASS,
    S_COMPANY,
    S_CUSTOMER,
    S_DIVISION,
    S_INVENTORY,
    S_ITEM,
    S_MANAGER,
    S_MANUFACTURER,
    S_MARKET,
    S_PRODUCT,
    S_PROMOTION,
    S_PURCHASE,
    S_PURCHASE_LINEITEM,
    S_REASON,
    S_STORE,
    S_STORE_PROMOTIONAL_ITEM,
    S_STORE_RETURNS,
    S_SUBCATEGORY,
    S_SUBCLASS,
    S_WAREHOUSE,
    S_WEB_ORDER,
    S_WEB_ORDER_LINEITEM,
    S_WEB_PAGE,
    S_WEB_PROMOTIONAL_ITEM,
    S_WEB_RETURNS,
    S_WEB_SITE,
    S_ZIPG;

    private final TableFlags tableFlags;
    private final int nullBasisPoints;
    private final long notNullBitMap;
    private final Class<? extends RowGenerator> rowGeneratorClass;
    private final GeneratorColumn[] generatorColumns;
    private final Column[] columns;
    private final ScalingInfo scalingInfo;
    private Optional<Table> parent = Optional.empty();
    private Optional<Table> child = Optional.empty();

    public Class<? extends RowGenerator> getRowGeneratorClass() {
        return this.rowGeneratorClass;
    }

    private Table() {
        this.tableFlags = new TableFlags.TableFlagsBuilder().build();
        this.nullBasisPoints = 0;
        this.notNullBitMap = 0L;
        this.rowGeneratorClass = null;
        this.generatorColumns = new GeneratorColumn[0];
        this.columns = new Column[0];
        this.scalingInfo = new ScalingInfo(0, ScalingInfo.ScalingModel.LINEAR, new int[10], 0);
    }

    private Table(TableFlags tableFlags, int nullBasisPoints, long notNullBitMap, Class<? extends RowGenerator> rowGeneratorClass, GeneratorColumn[] generatorColumns, Column[] columns, ScalingInfo scalingInfo) {
        this.tableFlags = tableFlags;
        this.nullBasisPoints = nullBasisPoints;
        this.notNullBitMap = notNullBitMap;
        this.rowGeneratorClass = rowGeneratorClass;
        this.generatorColumns = generatorColumns;
        this.columns = columns;
        this.scalingInfo = scalingInfo;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public boolean keepsHistory() {
        return this.tableFlags.keepsHistory();
    }

    public boolean isSmall() {
        return this.tableFlags.isSmall();
    }

    public boolean hasChild() {
        return this.child.isPresent();
    }

    public Table getChild() {
        return this.child.get();
    }

    public boolean isChild() {
        return this.parent.isPresent();
    }

    public Table getParent() {
        return this.parent.get();
    }

    public int getNullBasisPoints() {
        return this.nullBasisPoints;
    }

    public long getNotNullBitMap() {
        return this.notNullBitMap;
    }

    public GeneratorColumn[] getGeneratorColumns() {
        return this.generatorColumns;
    }

    public ScalingInfo getScalingInfo() {
        return this.scalingInfo;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Column getColumn(String columnName) {
        List allColumnMatches = Arrays.stream(this.getColumns()).filter(column -> columnName.toLowerCase().equals(column.getName().toLowerCase())).collect(Collectors.toList());
        Preconditions.checkState((allColumnMatches.size() == 1 ? 1 : 0) != 0);
        return (Column)allColumnMatches.get(0);
    }

    public static Table getTable(String tableName) {
        List allTableMatches = Table.getBaseTables().stream().filter(table -> tableName.toLowerCase().equals(table.getName().toLowerCase())).collect(Collectors.toList());
        Preconditions.checkState((allTableMatches.size() == 1 ? 1 : 0) != 0);
        return (Table)((Object)allTableMatches.get(0));
    }

    public static List<Table> getBaseTables() {
        ImmutableList allTables = ImmutableList.copyOf((Object[])Table.values());
        return allTables.stream().filter(table -> !table.getName().startsWith("s_")).collect(Collectors.toList());
    }

    public static List<Table> getSourceTables() {
        ImmutableList allTables = ImmutableList.copyOf((Object[])Table.values());
        return allTables.stream().filter(table -> table.getName().startsWith("s_")).collect(Collectors.toList());
    }

    static {
        Table.CATALOG_RETURNS.parent = Optional.of(CATALOG_SALES);
        Table.CATALOG_SALES.child = Optional.of(CATALOG_RETURNS);
        Table.STORE_RETURNS.parent = Optional.of(STORE_SALES);
        Table.STORE_SALES.child = Optional.of(STORE_RETURNS);
        Table.WEB_RETURNS.parent = Optional.of(WEB_SALES);
        Table.WEB_SALES.child = Optional.of(WEB_RETURNS);
    }
}

