/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.comm.ICloseableBufferAcceptor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.exceptions.NetException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.api.result.IResultPartitionManager;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.comm.channels.IChannelConnectionFactory;
import org.apache.hyracks.comm.channels.NetworkOutputChannel;
import org.apache.hyracks.net.protocols.muxdemux.ChannelControlBlock;
import org.apache.hyracks.net.protocols.muxdemux.IChannelOpenListener;
import org.apache.hyracks.net.protocols.muxdemux.MultiplexedConnection;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemux;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemuxPerformanceCounters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultNetworkManager
implements IChannelConnectionFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    static final int INITIAL_MESSAGE_SIZE = 20;
    private final IResultPartitionManager partitionManager;
    private final MuxDemux md;
    private final int nBuffers;
    private NetworkAddress localNetworkAddress;
    private NetworkAddress publicNetworkAddress;

    public ResultNetworkManager(String inetAddress, int inetPort, IResultPartitionManager partitionManager, int nThreads, int nBuffers, String publicInetAddress, int publicInetPort, IChannelInterfaceFactory channelInterfaceFactory, ISocketChannelFactory socketChannelFactory) {
        this.partitionManager = partitionManager;
        this.nBuffers = nBuffers;
        this.md = new MuxDemux(new InetSocketAddress(inetAddress, inetPort), (IChannelOpenListener)new ChannelOpenListener(), nThreads, 5, channelInterfaceFactory, socketChannelFactory);
        this.publicNetworkAddress = new NetworkAddress(publicInetAddress, publicInetPort);
    }

    public void start() throws IOException {
        this.md.start();
        InetSocketAddress sockAddr = this.md.getLocalAddress();
        this.localNetworkAddress = new NetworkAddress(sockAddr.getHostString(), sockAddr.getPort());
        if (this.publicNetworkAddress.getAddress() == null) {
            this.publicNetworkAddress = this.localNetworkAddress;
        } else if (this.publicNetworkAddress.getPort() == 0) {
            this.publicNetworkAddress = new NetworkAddress(this.publicNetworkAddress.getAddress(), sockAddr.getPort());
        }
    }

    public NetworkAddress getLocalNetworkAddress() {
        return this.localNetworkAddress;
    }

    public NetworkAddress getPublicNetworkAddress() {
        return this.publicNetworkAddress;
    }

    public void stop() {
    }

    public ChannelControlBlock connect(SocketAddress remoteAddress) throws InterruptedException, NetException {
        MultiplexedConnection mConn = this.md.connect((InetSocketAddress)remoteAddress);
        return mConn.openChannel();
    }

    public MuxDemuxPerformanceCounters getPerformanceCounters() {
        return this.md.getPerformanceCounters();
    }

    private class InitialBufferAcceptor
    implements ICloseableBufferAcceptor {
        private final ChannelControlBlock ccb;
        private NetworkOutputChannel noc;

        public InitialBufferAcceptor(ChannelControlBlock ccb) {
            this.ccb = ccb;
        }

        public void accept(ByteBuffer buffer) {
            JobId jobId = new JobId(buffer.getLong());
            ResultSetId rsId = new ResultSetId(buffer.getLong());
            int partition = buffer.getInt();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Received initial result partition read request for JobId: " + jobId + " partition: " + partition + " on channel: " + this.ccb);
            }
            this.noc = new NetworkOutputChannel(this.ccb, ResultNetworkManager.this.nBuffers);
            try {
                ResultNetworkManager.this.partitionManager.initializeResultPartitionReader(jobId, rsId, partition, (IFrameWriter)this.noc);
            }
            catch (HyracksException e) {
                LOGGER.warn("Failed to initialize result partition reader", (Throwable)e);
                this.noc.abort(1);
            }
        }

        public void close() {
        }

        public void error(int ecode) {
            if (this.noc != null) {
                this.noc.abort(ecode);
            }
        }
    }

    private class ChannelOpenListener
    implements IChannelOpenListener {
        private ChannelOpenListener() {
        }

        public void channelOpened(ChannelControlBlock channel) {
            channel.getReadInterface().setFullBufferAcceptor((ICloseableBufferAcceptor)new InitialBufferAcceptor(channel));
            channel.getReadInterface().getEmptyBufferAcceptor().accept(ByteBuffer.allocate(20));
        }
    }
}

