/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.utils;

import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;

public class NormalizedKeyUtils {
    private NormalizedKeyUtils() {
    }

    public static int compareNormalizeKeys(int[] keys1, int start1, int[] keys2, int start2, int length) {
        for (int i = 0; i < length; ++i) {
            int key1 = keys1[start1 + i];
            int key2 = keys2[start2 + i];
            if (key1 == key2) continue;
            return ((long)key1 & 0xFFFFFFFFL) < ((long)key2 & 0xFFFFFFFFL) ? -1 : 1;
        }
        return 0;
    }

    public static int getDecisivePrefixLength(INormalizedKeyComputerFactory[] keyNormalizerFactories) {
        if (keyNormalizerFactories == null) {
            return 0;
        }
        for (int i = 0; i < keyNormalizerFactories.length; ++i) {
            if (keyNormalizerFactories[i].getNormalizedKeyProperties().isDecisive()) continue;
            return i;
        }
        return keyNormalizerFactories.length;
    }

    public static void putLongIntoNormalizedKeys(int[] normalizedKeys, int keyStart, long key) {
        int low;
        int high;
        normalizedKeys[keyStart] = high = (int)(key >> 32);
        normalizedKeys[keyStart + 1] = low = (int)key;
    }

    public static int[] createNormalizedKeyArray(INormalizedKeyComputer normalizer) {
        if (normalizer == null) {
            return null;
        }
        return new int[normalizer.getNormalizedKeyProperties().getNormalizedKeyLength()];
    }
}

