/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFamily;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class RepartitionComputerFamily
implements ITuplePartitionComputerFamily {
    private static final long serialVersionUID = 1L;
    private int factor;
    private ITuplePartitionComputerFamily delegateFactory;

    public RepartitionComputerFamily(int factor, ITuplePartitionComputerFamily delegate) {
        this.factor = factor;
        this.delegateFactory = delegate;
    }

    public ITuplePartitionComputer createPartitioner(int seed) {
        final int s = seed;
        return new ITuplePartitionComputer(){
            private ITuplePartitionComputer delegate;
            {
                this.delegate = RepartitionComputerFamily.this.delegateFactory.createPartitioner(s);
            }

            public int partition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                return this.delegate.partition(accessor, tIndex, RepartitionComputerFamily.this.factor * nParts) / RepartitionComputerFamily.this.factor;
            }
        };
    }
}

