/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameFieldAppender;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.AbstractFrameAppender;
import org.apache.hyracks.util.IntSerDeUtils;

public class FrameFixedFieldAppender
extends AbstractFrameAppender
implements IFrameFieldAppender {
    private final int fieldCount;
    private int lastFieldEndOffset;
    private int currentField;
    private int leftOverSize;
    private byte[] cachedLeftOverFields;

    public FrameFixedFieldAppender(int numberFields) {
        this.fieldCount = numberFields;
        this.lastFieldEndOffset = 0;
        this.currentField = 0;
        this.leftOverSize = 0;
    }

    @Override
    public void reset(IFrame frame, boolean clear) throws HyracksDataException {
        super.reset(frame, clear);
        this.lastFieldEndOffset = 0;
        this.currentField = 0;
        this.leftOverSize = 0;
    }

    public void resetWithLeftOverData(IFrame frame) throws HyracksDataException {
        super.reset(frame, true);
        this.copyLeftOverDataFromeBufferToFrame();
    }

    @Override
    public void write(IFrameWriter outWriter, boolean clearFrame) throws HyracksDataException {
        super.write(outWriter, clearFrame);
        if (clearFrame) {
            this.copyLeftOverDataFromeBufferToFrame();
        }
    }

    public boolean appendField(byte[] bytes, int offset, int length) throws HyracksDataException {
        if (this.canHoldNewTuple(this.fieldCount, this.lastFieldEndOffset + length)) {
            int currentFieldDataStart = this.tupleDataEndOffset + this.fieldCount * 4 + this.lastFieldEndOffset;
            System.arraycopy(bytes, offset, this.array, currentFieldDataStart, length);
            this.lastFieldEndOffset += length;
            IntSerDeUtils.putInt((byte[])this.array, (int)(this.tupleDataEndOffset + this.currentField * 4), (int)this.lastFieldEndOffset);
            if (++this.currentField == this.fieldCount) {
                this.tupleDataEndOffset += this.fieldCount * 4 + this.lastFieldEndOffset;
                IntSerDeUtils.putInt((byte[])this.array, (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
                ++this.tupleCount;
                IntSerDeUtils.putInt((byte[])this.array, (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
                this.currentField = 0;
                this.lastFieldEndOffset = 0;
            }
            return true;
        }
        if (this.currentField > 0) {
            this.copyLeftOverDataFromFrameToBuffer();
        }
        return false;
    }

    private void copyLeftOverDataFromFrameToBuffer() {
        this.leftOverSize = this.lastFieldEndOffset + this.fieldCount * 4;
        if (this.cachedLeftOverFields == null || this.cachedLeftOverFields.length < this.leftOverSize) {
            this.cachedLeftOverFields = new byte[this.leftOverSize];
        }
        System.arraycopy(this.array, this.tupleDataEndOffset, this.cachedLeftOverFields, 0, this.leftOverSize);
    }

    private void copyLeftOverDataFromeBufferToFrame() throws HyracksDataException {
        if (this.leftOverSize > 0) {
            if (!this.canHoldNewTuple(0, this.leftOverSize)) {
                throw new HyracksDataException("The given frame can not be extended to insert the leftover data from the last record");
            }
            System.arraycopy(this.cachedLeftOverFields, 0, this.array, this.tupleDataEndOffset, this.leftOverSize);
            this.leftOverSize = 0;
        }
    }

    public boolean appendField(IFrameTupleAccessor fta, int tIndex, int fIndex) throws HyracksDataException {
        int startOffset = fta.getTupleStartOffset(tIndex);
        int fStartOffset = fta.getFieldStartOffset(tIndex, fIndex);
        int fLen = fta.getFieldEndOffset(tIndex, fIndex) - fStartOffset;
        return this.appendField(fta.getBuffer().array(), startOffset + fta.getFieldSlotsLength() + fStartOffset, fLen);
    }

    public boolean hasLeftOverFields() {
        return this.currentField != 0;
    }
}

