/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataflow;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.io.IWritable;

public final class ActivityId
implements IWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private OperatorDescriptorId odId;
    private int id;

    public static ActivityId create(DataInput dis) throws IOException {
        ActivityId activityId = new ActivityId();
        activityId.readFields(dis);
        return activityId;
    }

    private ActivityId() {
    }

    public ActivityId(OperatorDescriptorId odId, int id) {
        this.odId = odId;
        this.id = id;
    }

    public OperatorDescriptorId getOperatorDescriptorId() {
        return this.odId;
    }

    public void setOperatorDescriptorId(OperatorDescriptorId odId) {
        this.odId = odId;
    }

    public int getLocalId() {
        return this.id;
    }

    public int hashCode() {
        return this.odId.hashCode() + this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityId)) {
            return false;
        }
        ActivityId other = (ActivityId)o;
        return other.odId.equals(this.odId) && other.id == this.id;
    }

    public String toString() {
        return "ANID:" + this.odId + ":" + this.id;
    }

    public static ActivityId parse(String str) {
        if (str.startsWith("ANID:")) {
            str = str.substring(5);
            int idIdx = str.lastIndexOf(58);
            return new ActivityId(OperatorDescriptorId.parse(str.substring(0, idIdx)), Integer.parseInt(str.substring(idIdx + 1)));
        }
        throw new IllegalArgumentException("Unable to parse: " + str);
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        this.odId.writeFields(output);
        output.writeInt(this.id);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.odId = OperatorDescriptorId.create(input);
        this.id = input.readInt();
    }
}

