/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.evaluators;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.parser.JSONDataParser;
import org.apache.asterix.external.parser.factory.JSONDataParserFactory;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleInputStream;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class StringJsonParseEval
implements IScalarEvaluator {
    private final IEvaluatorContext ctx;
    private final IScalarEvaluator inputEval;
    private final JSONDataParser parser;
    private final SourceLocation sourceLocation;
    private final IPointable inputVal;
    private final UTF8StringPointable utf8Val;
    private final ByteArrayAccessibleInputStream inputStream;
    private final ArrayBackedValueStorage resultStorage;
    private final DataOutput out;

    public StringJsonParseEval(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLocation) throws IOException {
        this.ctx = ctx;
        this.inputEval = inputEval;
        this.parser = (JSONDataParser)new JSONDataParserFactory().createInputStreamParser(ctx.getTaskContext(), 0);
        this.sourceLocation = sourceLocation;
        this.inputVal = new VoidPointable();
        this.utf8Val = new UTF8StringPointable();
        this.inputStream = new ByteArrayAccessibleInputStream(new byte[0], 0, 0);
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
        this.parser.setInputStream((InputStream)this.inputStream);
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.inputEval.evaluate(tuple, this.inputVal);
        if (PointableHelper.checkAndSetMissingOrNull((IPointable)result, (IPointable)this.inputVal)) {
            return;
        }
        byte[] bytes = this.inputVal.getByteArray();
        if (bytes[offset = this.inputVal.getStartOffset()] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            this.utf8Val.set(bytes, offset + 1, this.inputVal.getLength() - 1);
            this.inputStream.setContent(bytes, this.utf8Val.getCharStartOffset(), this.utf8Val.getUTF8Length());
            this.resultStorage.reset();
            try {
                if (this.parser.parseAnyValue(this.out)) {
                    result.set((IValueReference)this.resultStorage);
                    return;
                }
                this.resetParser();
            }
            catch (HyracksDataException e) {
                IWarningCollector warningCollector = this.ctx.getWarningCollector();
                if (warningCollector.shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)this.sourceLocation, (IError)ErrorCode.RECORD_READER_MALFORMED_INPUT_STREAM, (Serializable[])new Serializable[0]));
                }
                this.resetParser();
            }
        } else {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLocation, (FunctionIdentifier)BuiltinFunctions.STRING_PARSE_JSON, (byte)bytes[offset], (int)0, (ATypeTag)ATypeTag.STRING);
        }
        PointableHelper.setNull((IPointable)result);
    }

    private void resetParser() throws HyracksDataException {
        try {
            this.parser.reset((InputStream)this.inputStream);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

