/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.library.java.base.JBoolean;
import org.apache.asterix.external.library.java.base.JDate;
import org.apache.asterix.external.library.java.base.JDateTime;
import org.apache.asterix.external.library.java.base.JDouble;
import org.apache.asterix.external.library.java.base.JDuration;
import org.apache.asterix.external.library.java.base.JFloat;
import org.apache.asterix.external.library.java.base.JInt;
import org.apache.asterix.external.library.java.base.JInterval;
import org.apache.asterix.external.library.java.base.JLong;
import org.apache.asterix.external.library.java.base.JMissing;
import org.apache.asterix.external.library.java.base.JNull;
import org.apache.asterix.external.library.java.base.JOrderedList;
import org.apache.asterix.external.library.java.base.JRecord;
import org.apache.asterix.external.library.java.base.JString;
import org.apache.asterix.external.library.java.base.JTime;
import org.apache.asterix.external.library.java.base.JUnorderedList;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;

public class JTypeObjectFactory
implements IObjectFactory<IJObject, IAType> {
    public static final JTypeObjectFactory INSTANCE = new JTypeObjectFactory();

    private JTypeObjectFactory() {
    }

    public IJObject create(IAType type) {
        IJObject retValue = null;
        switch (type.getTypeTag()) {
            case INTEGER: {
                retValue = new JInt(0);
                break;
            }
            case STRING: {
                retValue = new JString("");
                break;
            }
            case FLOAT: {
                retValue = new JFloat(0.0f);
                break;
            }
            case DOUBLE: {
                retValue = new JDouble(0.0);
                break;
            }
            case BOOLEAN: {
                retValue = new JBoolean(false);
                break;
            }
            case DATE: {
                retValue = new JDate(0);
                break;
            }
            case DATETIME: {
                retValue = new JDateTime(0L);
                break;
            }
            case DURATION: {
                retValue = new JDuration(0, 0L);
                break;
            }
            case INTERVAL: {
                retValue = new JInterval(0L, 0L);
                break;
            }
            case TIME: {
                retValue = new JTime(0);
                break;
            }
            case BIGINT: {
                retValue = new JLong(0L);
                break;
            }
            case NULL: {
                retValue = JNull.INSTANCE;
                break;
            }
            case MISSING: {
                retValue = JMissing.INSTANCE;
                break;
            }
            case ARRAY: {
                AOrderedListType ot = (AOrderedListType)type;
                IAType orderedItemType = ot.getItemType();
                retValue = new JOrderedList(orderedItemType);
                break;
            }
            case MULTISET: {
                AUnorderedListType ut = (AUnorderedListType)type;
                IAType unorderedItemType = ut.getItemType();
                retValue = new JUnorderedList(unorderedItemType);
                break;
            }
            case OBJECT: {
                IAType[] fieldTypes = ((ARecordType)type).getFieldTypes();
                IJObject[] fieldObjects = null;
                if (fieldTypes != null) {
                    fieldObjects = new IJObject[fieldTypes.length];
                    int index = 0;
                    for (IAType fieldType : fieldTypes) {
                        fieldObjects[index] = this.create(fieldType);
                        ++index;
                    }
                    retValue = new JRecord((ARecordType)type, fieldObjects);
                    break;
                }
                retValue = new JRecord((ARecordType)type, new IJObject[0]);
                break;
            }
            case UNION: {
                AUnionType unionType = (AUnionType)type;
                IJObject itemObject = null;
                if (unionType.isMissableType()) {
                    itemObject = this.create((IAType)unionType);
                }
                retValue = itemObject;
                break;
            }
        }
        return retValue;
    }
}

