/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class LineRecordReader
extends StreamRecordReader {
    protected boolean hasHeader;
    protected boolean prevCharCR;
    protected int newlineLength;
    protected long beginLineNumber = 1L;
    protected long lineNumber = 1L;
    protected boolean newSource = false;
    private static final List<String> recordReaderFormats = Collections.unmodifiableList(Arrays.asList("delimited-text", "csv", "tsv"));
    private static final String REQUIRED_CONFIGS = "";

    @Override
    public void configure(IHyracksTaskContext ctx, AsterixInputStream inputStream, Map<String, String> config) throws HyracksDataException {
        super.configure(inputStream, config);
        this.hasHeader = ExternalDataUtils.hasHeader(config);
        this.newSource = true;
        inputStream.setNotificationHandler(this);
    }

    @Override
    public void notifyNewSource() {
        this.resetForNewSource();
    }

    @Override
    public void resetForNewSource() {
        super.resetForNewSource();
        this.newSource = true;
        this.beginLineNumber = 1L;
        this.lineNumber = 1L;
        this.prevCharCR = false;
        this.newlineLength = 0;
    }

    @Override
    public List<String> getRecordReaderFormats() {
        return recordReaderFormats;
    }

    @Override
    public String getRequiredConfigs() {
        return REQUIRED_CONFIGS;
    }

    @Override
    public boolean hasNext() throws IOException {
        while (true) {
            if (this.done) {
                return false;
            }
            this.beginLineNumber = this.lineNumber;
            this.newlineLength = 0;
            this.prevCharCR = false;
            this.record.reset();
            int readLength = 0;
            do {
                int startPosn = this.bufferPosn;
                if (this.bufferPosn >= this.bufferLength) {
                    this.bufferPosn = 0;
                    startPosn = 0;
                    this.bufferLength = this.reader.read(this.inputBuffer);
                    if (this.bufferLength <= 0) {
                        if (readLength <= 0) {
                            this.close();
                            return false;
                        }
                        this.record.endRecord();
                        break;
                    }
                }
                while (this.bufferPosn < this.bufferLength) {
                    if (this.inputBuffer[this.bufferPosn] == '\ufeff') {
                        ++startPosn;
                    } else {
                        if (this.inputBuffer[this.bufferPosn] == '\n') {
                            this.newlineLength = this.prevCharCR ? 2 : 1;
                            ++this.bufferPosn;
                            ++this.lineNumber;
                            break;
                        }
                        if (this.prevCharCR) {
                            ++this.lineNumber;
                            this.newlineLength = 1;
                            break;
                        }
                        this.prevCharCR = this.inputBuffer[this.bufferPosn] == '\r';
                    }
                    ++this.bufferPosn;
                }
                if ((readLength = this.bufferPosn - startPosn) <= 0) continue;
                this.record.append(this.inputBuffer, startPosn, readLength);
            } while (this.newlineLength == 0);
            if (this.record.isEmptyRecord()) continue;
            if (!this.newSource || !this.hasHeader) break;
            this.newSource = false;
        }
        return true;
    }

    @Override
    public LongSupplier getLineNumber() {
        return this::getBeginLineNumber;
    }

    private long getBeginLineNumber() {
        return this.beginLineNumber;
    }
}

