/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.IOException;
import org.apache.asterix.external.indexing.ExternalFileIndexAccessor;
import org.apache.asterix.external.indexing.RecordId;
import org.apache.asterix.external.input.record.reader.hdfs.AbstractCharRecordLookupReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SequenceLookupReader
extends AbstractCharRecordLookupReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private SequenceFile.Reader reader;
    private Writable key;

    public SequenceLookupReader(ExternalFileIndexAccessor snapshotAccessor, FileSystem fs, Configuration conf) {
        super(snapshotAccessor, fs, conf);
    }

    @Override
    protected void readRecord(RecordId rid) throws IOException {
        this.reader.seek(rid.getOffset());
        this.reader.next(this.key, (Writable)this.value);
    }

    @Override
    protected void closeFile() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (Exception e) {
            LOGGER.warn("Error closing HDFS file ", (Throwable)e);
        }
    }

    @Override
    protected void openFile() throws IllegalArgumentException, IOException {
        this.reader = new SequenceFile.Reader(this.fs, new Path(this.file.getFileName()), this.conf);
        this.key = (Writable)ReflectionUtils.newInstance((Class)this.reader.getKeyClass(), (Configuration)this.conf);
        this.value = (Text)ReflectionUtils.newInstance((Class)this.reader.getValueClass(), (Configuration)this.conf);
    }
}

