/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling.om;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.job.profiling.om.AbstractProfile;
import org.apache.hyracks.control.common.job.profiling.om.JobletProfile;

public class JobProfile
extends AbstractProfile {
    private static final long serialVersionUID = 1L;
    private JobId jobId;
    private Map<String, JobletProfile> jobletProfiles;

    public static JobProfile create(DataInput dis) throws IOException {
        JobProfile jobProfile = new JobProfile();
        jobProfile.readFields(dis);
        return jobProfile;
    }

    private JobProfile() {
    }

    public JobProfile(JobId jobId) {
        this.jobId = jobId;
        this.jobletProfiles = new HashMap<String, JobletProfile>();
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Map<String, JobletProfile> getJobletProfiles() {
        return this.jobletProfiles;
    }

    @Override
    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("job-id", this.jobId.toString());
        this.populateCounters(json);
        ArrayNode jobletsArray = om.createArrayNode();
        for (JobletProfile p : this.jobletProfiles.values()) {
            jobletsArray.add((JsonNode)p.toJSON());
        }
        json.set("joblets", (JsonNode)jobletsArray);
        return json;
    }

    public void merge(JobProfile other) {
        super.merge(this);
        for (JobletProfile jp : other.jobletProfiles.values()) {
            if (this.jobletProfiles.containsKey(jp.getNodeId())) {
                this.jobletProfiles.get(jp.getNodeId()).merge(jp);
                continue;
            }
            this.jobletProfiles.put(jp.getNodeId(), jp);
        }
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.jobId = JobId.create((DataInput)input);
        int size = input.readInt();
        this.jobletProfiles = new HashMap<String, JobletProfile>();
        for (int i = 0; i < size; ++i) {
            String key = input.readUTF();
            JobletProfile value = JobletProfile.create(input);
            this.jobletProfiles.put(key, value);
        }
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        this.jobId.writeFields(output);
        output.writeInt(this.jobletProfiles.size());
        for (Map.Entry<String, JobletProfile> entry : this.jobletProfiles.entrySet()) {
            output.writeUTF(entry.getKey());
            entry.getValue().writeFields(output);
        }
    }
}

