/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.HashPartitionExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.HashPartitionMergeExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.PartialBroadcastRangeFollowingExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.PartialBroadcastRangeIntersectExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.RangePartitionExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.SortMergeExchangePOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IntervalColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class UsedVariableVisitor
implements ILogicalOperatorVisitor<Void, Void> {
    private final Collection<LogicalVariable> usedVariables;

    public UsedVariableVisitor(Collection<LogicalVariable> usedVariables) {
        this.usedVariables = usedVariables;
    }

    @Override
    public Void visitAggregateOperator(AggregateOperator op, Void arg) {
        for (Mutable<ILogicalExpression> exprRef : op.getExpressions()) {
            ((ILogicalExpression)exprRef.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, Void arg) {
        for (Mutable<ILogicalExpression> exprRef : op.getExpressions()) {
            ((ILogicalExpression)exprRef.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, Void arg) {
        if (op.getAdditionalFilteringExpressions() != null) {
            for (Mutable<ILogicalExpression> e : op.getAdditionalFilteringExpressions()) {
                ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
            }
        }
        if (op.getSelectCondition() != null) {
            HashSet<LogicalVariable> usedVariablesBySelect = new HashSet<LogicalVariable>();
            ((ILogicalExpression)op.getSelectCondition().getValue()).getUsedVariables(usedVariablesBySelect);
            usedVariablesBySelect.removeAll(op.getVariables());
            this.usedVariables.addAll(usedVariablesBySelect);
        }
        return null;
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, Void arg) {
        for (Mutable<ILogicalExpression> eRef : op.getExpressions()) {
            ((ILogicalExpression)eRef.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) {
        return null;
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        if (op.getPhysicalOperator() != null) {
            IPhysicalOperator physOp = op.getPhysicalOperator();
            switch (physOp.getOperatorTag()) {
                case BROADCAST_EXCHANGE: 
                case ONE_TO_ONE_EXCHANGE: 
                case RANDOM_MERGE_EXCHANGE: 
                case SEQUENTIAL_MERGE_EXCHANGE: 
                case RANDOM_PARTITION_EXCHANGE: {
                    break;
                }
                case HASH_PARTITION_EXCHANGE: {
                    HashPartitionExchangePOperator hashPartitionPOp = (HashPartitionExchangePOperator)physOp;
                    this.usedVariables.addAll(hashPartitionPOp.getHashFields());
                    break;
                }
                case HASH_PARTITION_MERGE_EXCHANGE: {
                    HashPartitionMergeExchangePOperator hashMergePOp = (HashPartitionMergeExchangePOperator)physOp;
                    this.usedVariables.addAll(hashMergePOp.getPartitionFields());
                    for (OrderColumn orderCol : hashMergePOp.getOrderColumns()) {
                        this.usedVariables.add(orderCol.getColumn());
                    }
                    break;
                }
                case SORT_MERGE_EXCHANGE: {
                    SortMergeExchangePOperator sortMergePOp = (SortMergeExchangePOperator)physOp;
                    for (OrderColumn orderCol : sortMergePOp.getSortColumns()) {
                        this.usedVariables.add(orderCol.getColumn());
                    }
                    break;
                }
                case RANGE_PARTITION_EXCHANGE: {
                    RangePartitionExchangePOperator rangeExchangePOp = (RangePartitionExchangePOperator)physOp;
                    for (OrderColumn orderCol : rangeExchangePOp.getPartitioningFields()) {
                        this.usedVariables.add(orderCol.getColumn());
                    }
                    break;
                }
                case PARTIAL_BROADCAST_RANGE_FOLLOWING_EXCHANGE: {
                    PartialBroadcastRangeFollowingExchangePOperator rangeFollowingPOp = (PartialBroadcastRangeFollowingExchangePOperator)physOp;
                    for (OrderColumn orderCol : rangeFollowingPOp.getPartitioningFields()) {
                        this.usedVariables.add(orderCol.getColumn());
                    }
                    break;
                }
                case PARTIAL_BROADCAST_RANGE_INTERSECT_EXCHANGE: {
                    PartialBroadcastRangeIntersectExchangePOperator intersectPOp = (PartialBroadcastRangeIntersectExchangePOperator)physOp;
                    for (IntervalColumn intervalCol : intersectPOp.getIntervalFields()) {
                        this.usedVariables.add(intervalCol.getStartColumn());
                        this.usedVariables.add(intervalCol.getEndColumn());
                    }
                    break;
                }
                default: {
                    throw new AlgebricksException("Unhandled physical operator tag '" + physOp.getOperatorTag() + "'.");
                }
            }
        }
        return null;
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        this.visitNestedPlans(op);
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> g : op.getGroupByList()) {
            ((ILogicalExpression)((Mutable)g.second).getValue()).getUsedVariables(this.usedVariables);
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> g : op.getDecorList()) {
            ((ILogicalExpression)((Mutable)g.second).getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, Void arg) {
        ((ILogicalExpression)op.getCondition().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) {
        ((ILogicalExpression)op.getCondition().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, Void arg) {
        if (op.hasMaxObjects()) {
            ((ILogicalExpression)op.getMaxObjects().getValue()).getUsedVariables(this.usedVariables);
        }
        if (op.hasOffset()) {
            ((ILogicalExpression)op.getOffset().getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) {
        return null;
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, Void arg) {
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> oe : op.getOrderExpressions()) {
            ((ILogicalExpression)((Mutable)oe.second).getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, Void arg) {
        List<LogicalVariable> parameterVariables = op.getVariables();
        for (LogicalVariable v : parameterVariables) {
            if (this.usedVariables.contains(v)) continue;
            this.usedVariables.add(v);
        }
        return null;
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) {
        for (Mutable<ILogicalExpression> exprRef : op.getExpressions()) {
            ((ILogicalExpression)exprRef.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, Void arg) {
        List<LogicalVariable> parameterVariables = op.getInputVariables();
        for (LogicalVariable v : parameterVariables) {
            if (this.usedVariables.contains(v)) continue;
            this.usedVariables.add(v);
        }
        return null;
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, Void arg) {
        ((ILogicalExpression)op.getCondition().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        this.visitNestedPlans(op);
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, Void arg) {
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> m : op.getVariableMappings()) {
            if (!this.usedVariables.contains(m.first)) {
                this.usedVariables.add((LogicalVariable)m.first);
            }
            if (this.usedVariables.contains(m.second)) continue;
            this.usedVariables.add((LogicalVariable)m.second);
        }
        return null;
    }

    @Override
    public Void visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        boolean hasExtraVars = op.hasExtraVariables();
        for (int i = 0; i < op.getNumInput(); ++i) {
            for (LogicalVariable var : op.getInputCompareVariables(i)) {
                if (this.usedVariables.contains(var)) continue;
                this.usedVariables.add(var);
            }
            if (!hasExtraVars) continue;
            for (LogicalVariable var : op.getInputExtraVariables(i)) {
                if (this.usedVariables.contains(var)) continue;
                this.usedVariables.add(var);
            }
        }
        return null;
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, Void arg) {
        this.getUsedVarsFromExprAndFilterExpr(op);
        if (op.getSelectCondition() != null) {
            HashSet<LogicalVariable> usedVariablesBySelect = new HashSet<LogicalVariable>();
            ((ILogicalExpression)op.getSelectCondition().getValue()).getUsedVariables(usedVariablesBySelect);
            usedVariablesBySelect.removeAll(op.getVariables());
            this.usedVariables.addAll(usedVariablesBySelect);
        }
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        this.getUsedVarsFromExprAndFilterExpr(op);
        return null;
    }

    private void getUsedVarsFromExprAndFilterExpr(AbstractUnnestMapOperator op) {
        ((ILogicalExpression)op.getExpressionRef().getValue()).getUsedVariables(this.usedVariables);
        if (op.getAdditionalFilteringExpressions() != null) {
            for (Mutable<ILogicalExpression> e : op.getAdditionalFilteringExpressions()) {
                ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
            }
        }
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, Void arg) {
        ((ILogicalExpression)op.getExpressionRef().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, Void arg) {
        for (Mutable<ILogicalExpression> expr : op.getExpressions()) {
            ((ILogicalExpression)expr.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, Void arg) {
        for (Mutable<ILogicalExpression> expr : op.getExpressions()) {
            ((ILogicalExpression)expr.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, Void arg) {
        ((ILogicalExpression)op.getPayloadExpression().getValue()).getUsedVariables(this.usedVariables);
        for (Mutable<ILogicalExpression> e : op.getKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        if (op.getAdditionalFilteringExpressions() != null) {
            for (Mutable<ILogicalExpression> e : op.getAdditionalFilteringExpressions()) {
                ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
            }
        }
        return null;
    }

    @Override
    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void arg) {
        ((ILogicalExpression)op.getPayloadExpression().getValue()).getUsedVariables(this.usedVariables);
        for (Mutable<ILogicalExpression> e : op.getPrimaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        if (op.getAdditionalFilteringExpressions() != null) {
            for (Mutable<ILogicalExpression> e : op.getAdditionalFilteringExpressions()) {
                ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
            }
        }
        if (op.getAdditionalNonFilteringExpressions() != null) {
            for (Mutable<ILogicalExpression> e : op.getAdditionalNonFilteringExpressions()) {
                ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
            }
        }
        return null;
    }

    @Override
    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        for (Mutable<ILogicalExpression> e : op.getPrimaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        for (Mutable<ILogicalExpression> e : op.getSecondaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        if (op.getFilterExpression() != null) {
            ((ILogicalExpression)op.getFilterExpression().getValue()).getUsedVariables(this.usedVariables);
        }
        if (op.getBeforeOpFilterExpression() != null) {
            ((ILogicalExpression)op.getBeforeOpFilterExpression().getValue()).getUsedVariables(this.usedVariables);
        }
        if (op.getAdditionalFilteringExpressions() != null) {
            for (Mutable<ILogicalExpression> e : op.getAdditionalFilteringExpressions()) {
                ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
            }
        }
        if (op.getPrevAdditionalFilteringExpression() != null) {
            ((ILogicalExpression)op.getPrevAdditionalFilteringExpression().getValue()).getUsedVariables(this.usedVariables);
        }
        if (op.getPrevSecondaryKeyExprs() != null) {
            for (Mutable<ILogicalExpression> e : op.getPrevSecondaryKeyExprs()) {
                ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
            }
        }
        if (op.getOperationExpr() != null) {
            ((ILogicalExpression)op.getOperationExpr().getValue()).getUsedVariables(this.usedVariables);
        }
        this.visitNestedPlans(op);
        return null;
    }

    @Override
    public Void visitTokenizeOperator(TokenizeOperator op, Void arg) {
        for (Mutable<ILogicalExpression> e : op.getPrimaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        for (Mutable<ILogicalExpression> e : op.getSecondaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
        ((ILogicalExpression)op.getSideDataExpression().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, Void arg) {
        return null;
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        ((ILogicalExpression)op.getBranchingExpression().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        op.getDelegate().getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        ((ILogicalExpression)op.getExpressionRef().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
        ILogicalExpression iLogicalExpression;
        this.visitNestedPlans(op);
        for (Mutable<ILogicalExpression> mutable : op.getPartitionExpressions()) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(this.usedVariables);
        }
        for (Pair pair : op.getOrderExpressions()) {
            ((ILogicalExpression)((Mutable)pair.second).getValue()).getUsedVariables(this.usedVariables);
        }
        for (Pair pair : op.getFrameValueExpressions()) {
            ((ILogicalExpression)((Mutable)pair.second).getValue()).getUsedVariables(this.usedVariables);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameStartExpressions()) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(this.usedVariables);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameStartValidationExpressions()) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(this.usedVariables);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameEndExpressions()) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(this.usedVariables);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameEndValidationExpressions()) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(this.usedVariables);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameExcludeExpressions()) {
            ((ILogicalExpression)mutable.getValue()).getUsedVariables(this.usedVariables);
        }
        ILogicalExpression frameExcludeUnaryExpr = (ILogicalExpression)op.getFrameExcludeUnaryExpression().getValue();
        if (frameExcludeUnaryExpr != null) {
            frameExcludeUnaryExpr.getUsedVariables(this.usedVariables);
        }
        if ((iLogicalExpression = (ILogicalExpression)op.getFrameOffsetExpression().getValue()) != null) {
            iLogicalExpression.getUsedVariables(this.usedVariables);
        }
        for (Mutable<ILogicalExpression> exprRef : op.getExpressions()) {
            ((ILogicalExpression)exprRef.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    private void visitNestedPlans(AbstractOperatorWithNestedPlans op) throws AlgebricksException {
        for (ILogicalPlan p : op.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                VariableUtilities.getUsedVariablesInDescendantsAndSelf((ILogicalOperator)r.getValue(), this.usedVariables);
            }
        }
    }
}

