/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ExternalDatasetAccessManager {
    private int version = 0;
    private ReentrantReadWriteLock datasetLock;
    private ReentrantReadWriteLock v0Lock = new ReentrantReadWriteLock(false);
    private ReentrantReadWriteLock v1Lock = new ReentrantReadWriteLock(false);

    public ExternalDatasetAccessManager() {
        this.datasetLock = new ReentrantReadWriteLock(true);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public ReentrantReadWriteLock getV0Lock() {
        return this.v0Lock;
    }

    public void setV0Lock(ReentrantReadWriteLock v0Lock) {
        this.v0Lock = v0Lock;
    }

    public ReentrantReadWriteLock getV1Lock() {
        return this.v1Lock;
    }

    public void setV1Lock(ReentrantReadWriteLock v1Lock) {
        this.v1Lock = v1Lock;
    }

    public int refreshBegin() {
        this.datasetLock.writeLock().lock();
        if (this.version == 0) {
            this.v1Lock.writeLock().lock();
        } else {
            this.v0Lock.writeLock().lock();
        }
        return this.version;
    }

    public void refreshEnd(boolean success) {
        if (this.version == 0) {
            this.v1Lock.writeLock().unlock();
            if (success) {
                this.version = 1;
            }
        } else {
            this.v0Lock.writeLock().unlock();
            if (success) {
                this.version = 0;
            }
        }
        this.datasetLock.writeLock().unlock();
    }

    public synchronized int buildIndexBegin(boolean isFirstIndex) {
        if (isFirstIndex) {
            this.datasetLock.writeLock().lock();
        } else {
            this.datasetLock.readLock().lock();
        }
        return this.version;
    }

    public void buildIndexEnd(boolean isFirstIndex) {
        if (isFirstIndex) {
            this.datasetLock.writeLock().unlock();
        } else {
            this.datasetLock.readLock().unlock();
        }
    }

    public int queryBegin() {
        if (this.version == 0) {
            this.v0Lock.readLock().lock();
            return 0;
        }
        this.v1Lock.readLock().lock();
        return 1;
    }

    public void queryEnd(int version) {
        if (version == 0) {
            this.v0Lock.readLock().unlock();
        } else {
            this.v1Lock.readLock().unlock();
        }
    }
}

