/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class CheckFullParallelSortRule
implements IAlgebraicRewriteRule {
    private final List<AbstractLogicalOperator> parents = new ArrayList<AbstractLogicalOperator>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        this.parents.add((AbstractLogicalOperator)opRef.getValue());
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext ctx) throws AlgebricksException {
        this.parents.remove(this.parents.size() - 1);
        AbstractLogicalOperator orderOp = (AbstractLogicalOperator)opRef.getValue();
        if (orderOp.getOperatorTag() == LogicalOperatorTag.ORDER && !orderOp.getAnnotations().containsKey("USE_STATIC_RANGE")) {
            for (int i = this.parents.size() - 1; i >= 0; --i) {
                AbstractLogicalOperator parent = this.parents.get(i);
                if (parent.getOperatorTag() == LogicalOperatorTag.LIMIT && ((LimitOperator)parent).isTopmostLimitOp()) {
                    orderOp.getAnnotations().put("USE_DYNAMIC_RANGE", Boolean.FALSE);
                    return true;
                }
                if (parent.getOperatorTag() != LogicalOperatorTag.RUNNINGAGGREGATE) continue;
                orderOp.getAnnotations().put("USE_DYNAMIC_RANGE", Boolean.FALSE);
                return true;
            }
        }
        return false;
    }
}

