/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.metadata.entities.ViewDetails;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.util.LogRedactionUtil;

public final class ViewUtil {
    private ViewUtil() {
    }

    public static ViewDecl parseStoredView(DatasetFullyQualifiedName viewName, ViewDetails view, IParserFactory parserFactory, IWarningCollector warningCollector, SourceLocation sourceLoc) throws CompilationException {
        IParser parser = parserFactory.createParser(new StringReader(view.getViewBody()));
        try {
            ViewDecl viewDecl = parser.parseViewBody(viewName);
            viewDecl.setSourceLocation(sourceLoc);
            if (warningCollector != null) {
                parser.getWarnings(warningCollector);
            }
            return viewDecl;
        }
        catch (CompilationException e) {
            throw new CompilationException(ErrorCode.COMPILATION_BAD_VIEW_DEFINITION, (Throwable)e, sourceLoc, new Serializable[]{viewName, e.getMessage()});
        }
    }

    public static List<List<Triple<DataverseName, String, String>>> getViewDependencies(ViewDecl viewDecl, List<ViewDetails.ForeignKey> foreignKeys, IQueryRewriter rewriter) throws CompilationException {
        Expression normBody = viewDecl.getNormalizedViewBody();
        if (normBody == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, viewDecl.getSourceLocation(), new Serializable[]{viewDecl.getViewName().toString()});
        }
        ArrayList<Triple<DataverseName, String, String>> datasetDependencies = new ArrayList<Triple<DataverseName, String, String>>();
        ArrayList<Triple<DataverseName, String, String>> synonymDependencies = new ArrayList<Triple<DataverseName, String, String>>();
        ArrayList<Triple<DataverseName, String, String>> functionDependencies = new ArrayList<Triple<DataverseName, String, String>>();
        ExpressionUtils.collectDependencies(normBody, rewriter, datasetDependencies, synonymDependencies, functionDependencies);
        if (foreignKeys != null) {
            DatasetFullyQualifiedName viewName = viewDecl.getViewName();
            for (ViewDetails.ForeignKey foreignKey : foreignKeys) {
                DatasetFullyQualifiedName refName = foreignKey.getReferencedDatasetName();
                boolean isSelfReference = refName.equals((Object)viewName);
                if (isSelfReference || ViewUtil.containsDependency(datasetDependencies, refName)) continue;
                datasetDependencies.add((Triple<DataverseName, String, String>)new Triple((Object)refName.getDataverseName(), (Object)refName.getDatasetName(), null));
            }
        }
        List typeDependencies = Collections.emptyList();
        return ViewDetails.createDependencies(datasetDependencies, functionDependencies, typeDependencies, synonymDependencies);
    }

    private static boolean containsDependency(List<Triple<DataverseName, String, String>> inList, DatasetFullyQualifiedName searchName) {
        for (Triple<DataverseName, String, String> d : inList) {
            if (!((DataverseName)d.first).equals((Object)searchName.getDataverseName()) || !((String)d.second).equals(searchName.getDatasetName())) continue;
            return true;
        }
        return false;
    }

    public static void validateViewItemType(ARecordType recordType, SourceLocation sourceLoc) throws CompilationException {
        if (recordType.isOpen()) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"view type cannot have open fields"});
        }
        String[] fieldNames = recordType.getFieldNames();
        IAType[] fieldTypes = recordType.getFieldTypes();
        int n = fieldNames.length;
        for (int i = 0; i < n; ++i) {
            IAType primeType;
            IAType fieldType = fieldTypes[i];
            if (fieldType.getTypeTag() == ATypeTag.UNION) {
                AUnionType unionType = (AUnionType)fieldType;
                if (!unionType.isNullableType()) {
                    throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{String.format("Invalid type for field %s. Optional type must allow NULL", LogRedactionUtil.userData((String)fieldNames[i]))});
                }
                primeType = unionType.getActualType();
            } else {
                primeType = fieldType;
            }
            if (TypeUtil.getTypeConstructorDefaultNull((IAType)primeType, (boolean)false) != null) continue;
            throw new CompilationException(ErrorCode.COMPILATION_TYPE_UNSUPPORTED, sourceLoc, new Serializable[]{"view", primeType.getTypeName()});
        }
    }

    public static Expression createTypeConvertExpression(Expression inExpr, IAType targetType, Triple<String, String, String> temporalDataFormat, DatasetFullyQualifiedName viewName, SourceLocation sourceLoc) throws CompilationException {
        String format = temporalDataFormat != null ? TypeUtil.getTemporalFormat((IAType)targetType, temporalDataFormat) : null;
        boolean withFormat = format != null;
        FunctionIdentifier constrFid = TypeUtil.getTypeConstructorDefaultNull((IAType)targetType, (boolean)withFormat);
        if (constrFid == null) {
            throw new CompilationException(ErrorCode.COMPILATION_TYPE_UNSUPPORTED, sourceLoc, new Serializable[]{viewName.toString(), targetType.getTypeName()});
        }
        ArrayList<Expression> convertArgList = new ArrayList<Expression>(2);
        convertArgList.add(inExpr);
        if (format != null) {
            LiteralExpr formatExpr = new LiteralExpr(new StringLiteral(format));
            formatExpr.setSourceLocation(sourceLoc);
            convertArgList.add(formatExpr);
        }
        CallExpr convertExpr = new CallExpr(new FunctionSignature(constrFid), convertArgList);
        convertExpr.setSourceLocation(inExpr.getSourceLocation());
        return convertExpr;
    }

    public static Expression createNotIsNullExpression(Expression inExpr, SourceLocation sourceLoc) {
        ArrayList<Expression> isNullArgs = new ArrayList<Expression>(1);
        isNullArgs.add(inExpr);
        CallExpr isNullExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.IS_NULL), isNullArgs);
        isNullExpr.setSourceLocation(sourceLoc);
        ArrayList<Expression> notExprArgs = new ArrayList<Expression>(1);
        notExprArgs.add(isNullExpr);
        CallExpr notExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.NOT), notExprArgs);
        notExpr.setSourceLocation(sourceLoc);
        return notExpr;
    }

    public static Expression createFieldAccessExpression(VarIdentifier inVar, String fieldName, SourceLocation sourceLoc) {
        VariableExpr inVarRef = new VariableExpr(inVar);
        inVarRef.setSourceLocation(sourceLoc);
        FieldAccessor fa = new FieldAccessor(inVarRef, new Identifier(fieldName));
        fa.setSourceLocation(sourceLoc);
        return fa;
    }
}

