/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class AbfsIoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsIoUtils.class);

    private AbfsIoUtils() {
    }

    public static void dumpHeadersToDebugLog(String origin, Map<String, List<String>> headers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)origin);
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                if (key == null) {
                    key = "HTTP Response";
                }
                String values = StringUtils.join((CharSequence)";", (Iterable)entry.getValue());
                if (key.contains("Cookie")) {
                    values = "*cookie info*";
                }
                if (key.equals("sig")) {
                    values = "XXXX";
                }
                LOG.debug("  {}={}", (Object)key, (Object)values);
            }
        }
    }
}

