/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.optype.UnnestType;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class UnnestClause
extends AbstractBinaryCorrelateClause {
    private final UnnestType unnestType;
    private Literal.Type outerUnnestMissingValueType;

    public UnnestClause(UnnestType unnestType, Expression rightExpr, VariableExpr rightVar, VariableExpr rightPosVar, Literal.Type outerUnnestMissingValueType) {
        super(rightExpr, rightVar, rightPosVar);
        this.unnestType = unnestType;
        this.setOuterUnnestMissingValueType(outerUnnestMissingValueType);
    }

    public Literal.Type getOuterUnnestMissingValueType() {
        return this.outerUnnestMissingValueType;
    }

    public void setOuterUnnestMissingValueType(Literal.Type outerUnnestMissingValueType) {
        this.outerUnnestMissingValueType = UnnestClause.validateMissingValueType(this.unnestType, outerUnnestMissingValueType);
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.UNNEST_CLAUSE;
    }

    public UnnestType getUnnestType() {
        return this.unnestType;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + 31 * this.unnestType.hashCode() + (this.outerUnnestMissingValueType != null ? this.outerUnnestMissingValueType.hashCode() : 0);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnnestClause)) {
            return false;
        }
        UnnestClause target = (UnnestClause)((Object)object);
        return super.equals((Object)target) && this.unnestType.equals((Object)target.getUnnestType()) && Objects.equals(this.outerUnnestMissingValueType, target.outerUnnestMissingValueType);
    }

    private static Literal.Type validateMissingValueType(UnnestType unnestType, Literal.Type missingValueType) {
        switch (unnestType) {
            case INNER: {
                if (missingValueType != null) {
                    throw new IllegalArgumentException(String.valueOf(missingValueType));
                }
                return null;
            }
            case LEFTOUTER: {
                switch (Objects.requireNonNull(missingValueType)) {
                    case MISSING: 
                    case NULL: {
                        return missingValueType;
                    }
                }
                throw new IllegalArgumentException(String.valueOf(missingValueType));
            }
        }
        throw new IllegalStateException(String.valueOf((Object)unnestType));
    }
}

