/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexFileNameMapper;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListBuilderFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class OnDiskInvertedIndexFactory
extends IndexFactory<IInvertedIndex> {
    protected final IInvertedListBuilderFactory invListBuilderFactory;
    protected final ITypeTraits[] invListTypeTraits;
    protected final IBinaryComparatorFactory[] invListCmpFactories;
    protected final ITypeTraits[] tokenTypeTraits;
    protected final IBinaryComparatorFactory[] tokenCmpFactories;
    protected final IInvertedIndexFileNameMapper fileNameMapper;
    protected final ITypeTraits nullTypeTraits;
    protected final INullIntrospector nullIntrospector;

    public OnDiskInvertedIndexFactory(IIOManager ioManager, IBufferCache bufferCache, IInvertedListBuilderFactory invListBuilderFactory, ITypeTraits[] invListTypeTraits, IBinaryComparatorFactory[] invListCmpFactories, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, IInvertedIndexFileNameMapper fileNameMapper, IPageManagerFactory pageManagerFactory, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        super(ioManager, bufferCache, pageManagerFactory);
        this.invListBuilderFactory = invListBuilderFactory;
        this.invListTypeTraits = invListTypeTraits;
        this.invListCmpFactories = invListCmpFactories;
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.fileNameMapper = fileNameMapper;
        this.nullTypeTraits = nullTypeTraits;
        this.nullIntrospector = nullIntrospector;
    }

    public OnDiskInvertedIndex createIndexInstance(FileReference dictBTreeFile) throws HyracksDataException {
        String invListsFilePath = this.fileNameMapper.getInvListsFilePath(dictBTreeFile.getFile().getAbsolutePath());
        FileReference invListsFile = this.ioManager.resolveAbsolutePath(invListsFilePath);
        IInvertedListBuilder invListBuilder = this.invListBuilderFactory.create();
        return new OnDiskInvertedIndex(this.bufferCache, invListBuilder, this.invListTypeTraits, this.invListCmpFactories, this.tokenTypeTraits, this.tokenCmpFactories, dictBTreeFile, invListsFile, this.freePageManagerFactory, this.nullTypeTraits, this.nullIntrospector);
    }
}

