/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImplBuilder;
import com.azure.storage.file.datalake.implementation.models.LeaseAccessConditions;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.models.PathGetPropertiesAction;
import com.azure.storage.file.datalake.implementation.models.PathRenameMode;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathSetAccessControlRecursiveMode;
import com.azure.storage.file.datalake.implementation.models.PathsCreateHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsGetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlRecursiveHeaders;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlRecursiveResponse;
import com.azure.storage.file.datalake.implementation.models.SourceModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.DataLakeSasImplUtil;
import com.azure.storage.file.datalake.implementation.util.ModelHelper;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.azure.storage.file.datalake.models.AccessControlChangeCounters;
import com.azure.storage.file.datalake.models.AccessControlChangeFailure;
import com.azure.storage.file.datalake.models.AccessControlChangeResult;
import com.azure.storage.file.datalake.models.AccessControlChanges;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.PathAccessControl;
import com.azure.storage.file.datalake.models.PathAccessControlEntry;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathPermissions;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.models.PathRemoveAccessControlEntry;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.options.PathRemoveAccessControlRecursiveOptions;
import com.azure.storage.file.datalake.options.PathSetAccessControlRecursiveOptions;
import com.azure.storage.file.datalake.options.PathUpdateAccessControlRecursiveOptions;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataLakePathClientBuilder.class, isAsync=true)
public class DataLakePathAsyncClient {
    private final ClientLogger logger = new ClientLogger(DataLakePathAsyncClient.class);
    final AzureDataLakeStorageRestAPIImpl dataLakeStorage;
    final AzureDataLakeStorageRestAPIImpl fileSystemDataLakeStorage;
    final AzureDataLakeStorageRestAPIImpl blobDataLakeStorage;
    private final String accountName;
    private final String fileSystemName;
    final String pathName;
    private final DataLakeServiceVersion serviceVersion;
    final PathResourceType pathResourceType;
    final BlockBlobAsyncClient blockBlobAsyncClient;

    DataLakePathAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String pathName, PathResourceType pathResourceType, BlockBlobAsyncClient blockBlobAsyncClient) {
        this.accountName = accountName;
        this.fileSystemName = fileSystemName;
        this.pathName = Utility.urlDecode((String)pathName);
        this.pathResourceType = pathResourceType;
        this.blockBlobAsyncClient = blockBlobAsyncClient;
        this.dataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).path(this.pathName).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(url, "blob", "dfs");
        this.blobDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(blobUrl).fileSystem(fileSystemName).path(this.pathName).version(serviceVersion.getVersion()).buildClient();
        this.fileSystemDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
    }

    static String buildMetadataString(Map<String, String> metadata) {
        if (!CoreUtils.isNullOrEmpty(metadata)) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                if (Objects.isNull(entry.getKey()) || entry.getKey().isEmpty()) {
                    throw new IllegalArgumentException("The key for one of the metadata key-value pairs is null, empty, or whitespace.");
                }
                if (Objects.isNull(entry.getValue()) || entry.getValue().isEmpty()) {
                    throw new IllegalArgumentException("The value for one of the metadata key-value pairs is null, empty, or whitespace.");
                }
                sb.append(entry.getKey()).append('=').append(new String(Base64.getEncoder().encode(entry.getValue().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8)).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    String getAccountUrl() {
        return this.dataLakeStorage.getUrl();
    }

    String getPathUrl() {
        return this.dataLakeStorage.getUrl() + "/" + this.fileSystemName + "/" + Utility.urlEncode((String)this.pathName);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    String getObjectPath() {
        return this.pathName;
    }

    String getObjectName() {
        String[] pathParts = this.getObjectPath().split("/");
        return pathParts[pathParts.length - 1];
    }

    public HttpPipeline getHttpPipeline() {
        return this.dataLakeStorage.getHttpPipeline();
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> create() {
        try {
            return this.create(false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> create(boolean overwrite) {
        try {
            DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
            if (!overwrite) {
                requestConditions.setIfNoneMatch("*");
            }
            return this.createWithResponse(null, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> createWithResponse(String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(permissions, umask, this.pathResourceType, headers, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PathInfo>> createWithResponse(String permissions, String umask, PathResourceType resourceType, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.getPaths().createWithResponseAsync(null, null, resourceType, null, null, null, null, DataLakePathAsyncClient.buildMetadataString(metadata), permissions, umask, headers, lac, mac, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)new PathInfo(((PathsCreateHeaders)response.getDeserializedHeaders()).getETag(), ((PathsCreateHeaders)response.getDeserializedHeaders()).getLastModified())));
    }

    Mono<Response<Void>> deleteWithResponse(Boolean recursive, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.getPaths().deleteWithResponseAsync(null, null, recursive, null, lac, mac, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            return this.blockBlobAsyncClient.setMetadataWithResponse(metadata, Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setHttpHeaders(PathHttpHeaders headers) {
        try {
            return this.setHttpHeadersWithResponse(headers, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setHttpHeadersWithResponse(PathHttpHeaders headers, DataLakeRequestConditions requestConditions) {
        try {
            return this.blockBlobAsyncClient.setHttpHeadersWithResponse(Transforms.toBlobHttpHeaders(headers), Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathProperties>> getPropertiesWithResponse(DataLakeRequestConditions requestConditions) {
        try {
            return this.blockBlobAsyncClient.getPropertiesWithResponse(Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse(response, (Object)Transforms.toPathProperties((BlobProperties)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> exists() {
        try {
            return this.existsWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return this.blockBlobAsyncClient.existsWithResponse().onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> setAccessControlList(List<PathAccessControlEntry> accessControlList, String group, String owner) {
        try {
            return this.setAccessControlListWithResponse(accessControlList, group, owner, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> setAccessControlListWithResponse(List<PathAccessControlEntry> accessControlList, String group, String owner, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessControlWithResponse(accessControlList, null, group, owner, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathInfo> setPermissions(PathPermissions permissions, String group, String owner) {
        try {
            return this.setPermissionsWithResponse(permissions, group, owner, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathInfo>> setPermissionsWithResponse(PathPermissions permissions, String group, String owner, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessControlWithResponse(null, permissions, group, owner, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PathInfo>> setAccessControlWithResponse(List<PathAccessControlEntry> accessControlList, PathPermissions permissions, String group, String owner, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        String permissionsString = permissions == null ? null : permissions.toString();
        String accessControlListString = accessControlList == null ? null : PathAccessControlEntry.serializeList(accessControlList);
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.getPaths().setAccessControlWithResponseAsync(null, owner, group, permissionsString, accessControlListString, null, lac, mac, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)new PathInfo(((PathsSetAccessControlHeaders)response.getDeserializedHeaders()).getETag(), ((PathsSetAccessControlHeaders)response.getDeserializedHeaders()).getLastModified())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessControlChangeResult> setAccessControlRecursive(List<PathAccessControlEntry> accessControlList) {
        try {
            return this.setAccessControlRecursiveWithResponse(new PathSetAccessControlRecursiveOptions(accessControlList)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessControlChangeResult>> setAccessControlRecursiveWithResponse(PathSetAccessControlRecursiveOptions options) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        try {
            return FluxUtil.withContext(context -> this.setAccessControlRecursiveWithResponse(PathAccessControlEntry.serializeList(options.getAccessControlList()), options.getProgressHandler(), PathSetAccessControlRecursiveMode.SET, options.getBatchSize(), options.getMaxBatches(), options.isContinueOnFailure(), options.getContinuationToken(), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessControlChangeResult> updateAccessControlRecursive(List<PathAccessControlEntry> accessControlList) {
        try {
            return this.updateAccessControlRecursiveWithResponse(new PathUpdateAccessControlRecursiveOptions(accessControlList)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessControlChangeResult>> updateAccessControlRecursiveWithResponse(PathUpdateAccessControlRecursiveOptions options) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        try {
            return FluxUtil.withContext(context -> this.setAccessControlRecursiveWithResponse(PathAccessControlEntry.serializeList(options.getAccessControlList()), options.getProgressHandler(), PathSetAccessControlRecursiveMode.MODIFY, options.getBatchSize(), options.getMaxBatches(), options.isContinueOnFailure(), options.getContinuationToken(), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessControlChangeResult> removeAccessControlRecursive(List<PathRemoveAccessControlEntry> accessControlList) {
        try {
            return this.removeAccessControlRecursiveWithResponse(new PathRemoveAccessControlRecursiveOptions(accessControlList)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessControlChangeResult>> removeAccessControlRecursiveWithResponse(PathRemoveAccessControlRecursiveOptions options) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        try {
            return FluxUtil.withContext(context -> this.setAccessControlRecursiveWithResponse(PathRemoveAccessControlEntry.serializeList(options.getAccessControlList()), options.getProgressHandler(), PathSetAccessControlRecursiveMode.REMOVE, options.getBatchSize(), options.getMaxBatches(), options.isContinueOnFailure(), options.getContinuationToken(), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AccessControlChangeResult>> setAccessControlRecursiveWithResponse(String accessControlList, Consumer<Response<AccessControlChanges>> progressHandler, PathSetAccessControlRecursiveMode mode, Integer batchSize, Integer maxBatches, Boolean continueOnFailure, String continuationToken, Context context) {
        StorageImplUtils.assertNotNull((String)"accessControlList", (Object)accessControlList);
        context = context == null ? Context.NONE : context;
        Context contextFinal = context.addData((Object)"az.namespace", (Object)"Microsoft.Storage");
        AtomicInteger directoriesSuccessfulCount = new AtomicInteger(0);
        AtomicInteger filesSuccessfulCount = new AtomicInteger(0);
        AtomicInteger failureCount = new AtomicInteger(0);
        AtomicInteger batchesCount = new AtomicInteger(0);
        return this.dataLakeStorage.getPaths().setAccessControlRecursiveWithResponseAsync(mode, null, continuationToken, continueOnFailure, batchSize, accessControlList, null, contextFinal).onErrorMap(e -> {
            if (e instanceof DataLakeStorageException) {
                return this.logger.logExceptionAsError((RuntimeException)((Object)ModelHelper.changeAclRequestFailed((DataLakeStorageException)((Object)((Object)e)), continuationToken)));
            }
            if (e instanceof Exception) {
                return this.logger.logExceptionAsError((RuntimeException)((Object)ModelHelper.changeAclFailed((Exception)e, continuationToken)));
            }
            return e;
        }).flatMap(response -> this.setAccessControlRecursiveWithResponseHelper((PathsSetAccessControlRecursiveResponse)((Object)response), maxBatches, directoriesSuccessfulCount, filesSuccessfulCount, failureCount, batchesCount, progressHandler, accessControlList, mode, batchSize, continueOnFailure, continuationToken, null, contextFinal));
    }

    Mono<Response<AccessControlChangeResult>> setAccessControlRecursiveWithResponseHelper(PathsSetAccessControlRecursiveResponse response, Integer maxBatches, AtomicInteger directoriesSuccessfulCount, AtomicInteger filesSuccessfulCount, AtomicInteger failureCount, AtomicInteger batchesCount, Consumer<Response<AccessControlChanges>> progressHandler, String accessControlStr, PathSetAccessControlRecursiveMode mode, Integer batchSize, Boolean continueOnFailure, String lastToken, List<AccessControlChangeFailure> batchFailures, Context context) {
        batchesCount.incrementAndGet();
        directoriesSuccessfulCount.addAndGet(response.getValue().getDirectoriesSuccessful());
        filesSuccessfulCount.addAndGet(response.getValue().getFilesSuccessful());
        failureCount.addAndGet(response.getValue().getFailureCount());
        if (failureCount.get() > 0 && batchFailures == null) {
            batchFailures = response.getValue().getFailedEntries().stream().map(aclFailedEntry -> new AccessControlChangeFailure().setDirectory(aclFailedEntry.getType().equals("DIRECTORY")).setName(aclFailedEntry.getName()).setErrorMessage(aclFailedEntry.getErrorMessage())).collect(Collectors.toList());
        }
        List<AccessControlChangeFailure> finalBatchFailures = batchFailures;
        String newToken = ((PathsSetAccessControlRecursiveHeaders)response.getDeserializedHeaders()).getXMsContinuation();
        String effectiveNextToken = newToken != null && !newToken.isEmpty() ? newToken : (failureCount.get() == 0 || continueOnFailure == null || continueOnFailure != false ? newToken : lastToken);
        if (progressHandler != null) {
            AccessControlChanges changes = new AccessControlChanges();
            changes.setContinuationToken(effectiveNextToken);
            changes.setBatchFailures(response.getValue().getFailedEntries().stream().map(aclFailedEntry -> new AccessControlChangeFailure().setDirectory(aclFailedEntry.getType().equals("DIRECTORY")).setName(aclFailedEntry.getName()).setErrorMessage(aclFailedEntry.getErrorMessage())).collect(Collectors.toList()));
            changes.setBatchCounters(new AccessControlChangeCounters().setChangedDirectoriesCount(response.getValue().getDirectoriesSuccessful().intValue()).setChangedFilesCount(response.getValue().getFilesSuccessful().intValue()).setFailedChangesCount(response.getValue().getFailureCount().intValue()));
            changes.setAggregateCounters(new AccessControlChangeCounters().setChangedDirectoriesCount(directoriesSuccessfulCount.get()).setChangedFilesCount(filesSuccessfulCount.get()).setFailedChangesCount(failureCount.get()));
            progressHandler.accept((Response<AccessControlChanges>)new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)changes, (Object)((PathsSetAccessControlRecursiveHeaders)response.getDeserializedHeaders())));
        }
        if (newToken == null || newToken.isEmpty() || maxBatches != null && batchesCount.get() >= maxBatches) {
            AccessControlChangeResult result = new AccessControlChangeResult().setBatchFailures(batchFailures).setContinuationToken(effectiveNextToken).setCounters(new AccessControlChangeCounters().setChangedDirectoriesCount(directoriesSuccessfulCount.get()).setChangedFilesCount(filesSuccessfulCount.get()).setFailedChangesCount(failureCount.get()));
            return Mono.just((Object)new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result, (Object)((PathsSetAccessControlRecursiveHeaders)response.getDeserializedHeaders())));
        }
        return this.dataLakeStorage.getPaths().setAccessControlRecursiveWithResponseAsync(mode, null, effectiveNextToken, continueOnFailure, batchSize, accessControlStr, null, context).onErrorMap(e -> {
            if (e instanceof DataLakeStorageException) {
                return this.logger.logExceptionAsError((RuntimeException)((Object)ModelHelper.changeAclRequestFailed((DataLakeStorageException)((Object)((Object)e)), effectiveNextToken)));
            }
            if (e instanceof Exception) {
                return this.logger.logExceptionAsError((RuntimeException)((Object)ModelHelper.changeAclFailed((Exception)e, effectiveNextToken)));
            }
            return e;
        }).flatMap(response2 -> this.setAccessControlRecursiveWithResponseHelper((PathsSetAccessControlRecursiveResponse)((Object)response2), maxBatches, directoriesSuccessfulCount, filesSuccessfulCount, failureCount, batchesCount, progressHandler, accessControlStr, mode, batchSize, continueOnFailure, effectiveNextToken, finalBatchFailures, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathAccessControl> getAccessControl() {
        try {
            return this.getAccessControlWithResponse(false, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathAccessControl>> getAccessControlWithResponse(boolean userPrincipalNameReturned, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getAccessControlWithResponse(userPrincipalNameReturned, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PathAccessControl>> getAccessControlWithResponse(boolean userPrincipalNameReturned, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.getPaths().getPropertiesWithResponseAsync(null, null, PathGetPropertiesAction.GET_ACCESS_CONTROL, userPrincipalNameReturned, lac, mac, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)new PathAccessControl(PathAccessControlEntry.parseList(((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsAcl()), PathPermissions.parseSymbolic(((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsPermissions()), ((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsGroup(), ((PathsGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsOwner())));
    }

    Mono<Response<DataLakePathAsyncClient>> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Context context) {
        destinationRequestConditions = destinationRequestConditions == null ? new DataLakeRequestConditions() : destinationRequestConditions;
        sourceRequestConditions = sourceRequestConditions == null ? new DataLakeRequestConditions() : sourceRequestConditions;
        SourceModifiedAccessConditions sourceConditions = new SourceModifiedAccessConditions().setSourceIfModifiedSince(sourceRequestConditions.getIfModifiedSince()).setSourceIfUnmodifiedSince(sourceRequestConditions.getIfUnmodifiedSince()).setSourceIfMatch(sourceRequestConditions.getIfMatch()).setSourceIfNoneMatch(sourceRequestConditions.getIfNoneMatch());
        LeaseAccessConditions destLac = new LeaseAccessConditions().setLeaseId(destinationRequestConditions.getLeaseId());
        ModifiedAccessConditions destMac = new ModifiedAccessConditions().setIfMatch(destinationRequestConditions.getIfMatch()).setIfNoneMatch(destinationRequestConditions.getIfNoneMatch()).setIfModifiedSince(destinationRequestConditions.getIfModifiedSince()).setIfUnmodifiedSince(destinationRequestConditions.getIfUnmodifiedSince());
        DataLakePathAsyncClient dataLakePathAsyncClient = this.getPathAsyncClient(destinationFileSystem, destinationPath);
        String renameSource = "/" + this.fileSystemName + "/" + Utility.urlEncode((String)this.pathName);
        return dataLakePathAsyncClient.dataLakeStorage.getPaths().createWithResponseAsync(null, null, null, null, PathRenameMode.LEGACY, renameSource, sourceRequestConditions.getLeaseId(), null, null, null, null, destLac, destMac, sourceConditions, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)dataLakePathAsyncClient));
    }

    DataLakePathAsyncClient getPathAsyncClient(String destinationFileSystem, String destinationPath) {
        if (destinationFileSystem == null) {
            destinationFileSystem = this.getFileSystemName();
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)destinationPath)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'destinationPath' can not be set to null"));
        }
        return new DataLakePathAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.serviceVersion, this.accountName, destinationFileSystem, destinationPath, this.pathResourceType, this.prepareBuilderReplacePath(destinationFileSystem, destinationPath).buildBlockBlobAsyncClient());
    }

    SpecializedBlobClientBuilder prepareBuilderReplacePath(String destinationFileSystem, String destinationPath) {
        if (destinationFileSystem == null) {
            destinationFileSystem = this.getFileSystemName();
        }
        String newBlobEndpoint = BlobUrlParts.parse((String)DataLakeImplUtils.endpointToDesiredEndpoint(this.getPathUrl(), "blob", "dfs")).setBlobName(destinationPath).setContainerName(destinationFileSystem).toUrl().toString();
        return new SpecializedBlobClientBuilder().pipeline(this.getHttpPipeline()).endpoint(newBlobEndpoint).serviceVersion(TransformUtils.toBlobServiceVersion(this.getServiceVersion()));
    }

    BlockBlobAsyncClient getBlockBlobAsyncClient() {
        return this.blockBlobAsyncClient;
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName(), this.getObjectPath(), PathResourceType.DIRECTORY.equals((Object)this.pathResourceType)).generateUserDelegationSas(userDelegationKey, accountName, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.generateSas(dataLakeServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName(), this.getObjectPath(), PathResourceType.DIRECTORY.equals((Object)this.pathResourceType)).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }
}

