/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.common;

import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeHelper;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;

public class MissableTypeComputer
implements IMissableTypeComputer {
    public static final MissableTypeComputer INSTANCE = new MissableTypeComputer();

    private MissableTypeComputer() {
    }

    public IAType makeMissableType(Object type) {
        IAType t = (IAType)type;
        return TypeHelper.canBeMissing(t) ? t : (t.getTypeTag() == ATypeTag.NULL ? BuiltinType.ANY : AUnionType.createMissableType(t));
    }

    public boolean canBeMissing(Object type) {
        IAType t = (IAType)type;
        return TypeHelper.canBeMissing(t);
    }

    public Object makeNullableType(Object type) {
        IAType t = (IAType)type;
        return TypeHelper.canBeNull(t) ? t : (t.getTypeTag() == ATypeTag.MISSING ? BuiltinType.ANY : AUnionType.createNullableType(t));
    }

    public boolean canBeNull(Object type) {
        IAType t = (IAType)type;
        return TypeHelper.canBeNull(t);
    }

    public Object getNonOptionalType(Object type) {
        IAType t = (IAType)type;
        return TypeComputeUtils.getActualType(t);
    }

    public Object getNonMissableType(Object type) {
        IAType t = (IAType)type;
        if (t.getTypeTag() == ATypeTag.UNION) {
            AUnionType ut = (AUnionType)t;
            IAType primeType = ut.getActualType();
            return ut.isNullableType() ? AUnionType.createNullableType(primeType) : primeType;
        }
        return t;
    }

    public Object getNonNullableType(Object type) {
        IAType t = (IAType)type;
        if (t.getTypeTag() == ATypeTag.UNION) {
            AUnionType ut = (AUnionType)t;
            IAType primeType = ut.getActualType();
            return ut.isMissableType() ? AUnionType.createMissableType(primeType) : primeType;
        }
        return t;
    }
}

