/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlockEntry;
import com.microsoft.azure.storage.blob.BlockListingFilter;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import com.microsoft.azure.storage.blob.CopyState;
import com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.azure.storage.blob.ListBlobItem;
import com.microsoft.azure.storage.blob.PageRange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.azure.StorageInterface;

@InterfaceAudience.Private
class StorageInterfaceImpl
extends StorageInterface {
    private CloudBlobClient serviceClient;
    private RetryPolicyFactory retryPolicyFactory;
    private int timeoutIntervalInMs;

    StorageInterfaceImpl() {
    }

    private void updateRetryPolicy() {
        if (this.serviceClient != null && this.retryPolicyFactory != null) {
            this.serviceClient.getDefaultRequestOptions().setRetryPolicyFactory(this.retryPolicyFactory);
        }
    }

    private void updateTimeoutInMs() {
        if (this.serviceClient != null && this.timeoutIntervalInMs > 0) {
            this.serviceClient.getDefaultRequestOptions().setTimeoutIntervalInMs(Integer.valueOf(this.timeoutIntervalInMs));
        }
    }

    @Override
    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.retryPolicyFactory = retryPolicyFactory;
        this.updateRetryPolicy();
    }

    @Override
    public void setTimeoutInMs(int timeoutInMs) {
        this.timeoutIntervalInMs = timeoutInMs;
        this.updateTimeoutInMs();
    }

    @Override
    public void createBlobClient(CloudStorageAccount account) {
        this.serviceClient = account.createCloudBlobClient();
        this.updateRetryPolicy();
        this.updateTimeoutInMs();
    }

    @Override
    public void createBlobClient(URI baseUri) {
        this.createBlobClient(baseUri, null);
    }

    @Override
    public void createBlobClient(URI baseUri, StorageCredentials credentials) {
        this.serviceClient = new CloudBlobClient(baseUri, credentials);
        this.updateRetryPolicy();
        this.updateTimeoutInMs();
    }

    @Override
    public StorageCredentials getCredentials() {
        return this.serviceClient.getCredentials();
    }

    @Override
    public StorageInterface.CloudBlobContainerWrapper getContainerReference(String uri) throws URISyntaxException, StorageException {
        return new CloudBlobContainerWrapperImpl(this.serviceClient.getContainerReference(uri));
    }

    static class CloudPageBlobWrapperImpl
    extends CloudBlobWrapperImpl
    implements StorageInterface.CloudPageBlobWrapper {
        public CloudPageBlobWrapperImpl(CloudPageBlob blob) {
            super((CloudBlob)blob);
        }

        @Override
        public void create(long length, BlobRequestOptions options, OperationContext opContext) throws StorageException {
            ((CloudPageBlob)this.getBlob()).create(length, null, options, opContext);
        }

        @Override
        public void uploadPages(InputStream sourceStream, long offset, long length, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
            ((CloudPageBlob)this.getBlob()).uploadPages(sourceStream, offset, length, null, options, opContext);
        }

        @Override
        public ArrayList<PageRange> downloadPageRanges(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return ((CloudPageBlob)this.getBlob()).downloadPageRanges(null, options, opContext);
        }
    }

    static class CloudBlockBlobWrapperImpl
    extends CloudBlobWrapperImpl
    implements StorageInterface.CloudBlockBlobWrapper {
        public CloudBlockBlobWrapperImpl(CloudBlockBlob blob) {
            super((CloudBlob)blob);
        }

        @Override
        public OutputStream openOutputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return ((CloudBlockBlob)this.getBlob()).openOutputStream(null, options, opContext);
        }

        @Override
        public void upload(InputStream sourceStream, OperationContext opContext) throws StorageException, IOException {
            this.getBlob().upload(sourceStream, 0L, null, null, opContext);
        }

        public void uploadProperties(OperationContext opContext) throws StorageException {
            this.getBlob().uploadProperties(null, null, opContext);
        }

        @Override
        public List<BlockEntry> downloadBlockList(BlockListingFilter filter, BlobRequestOptions options, OperationContext opContext) throws IOException, StorageException {
            return ((CloudBlockBlob)this.getBlob()).downloadBlockList(filter, null, options, opContext);
        }

        @Override
        public void uploadBlock(String blockId, AccessCondition accessCondition, InputStream sourceStream, long length, BlobRequestOptions options, OperationContext opContext) throws IOException, StorageException {
            ((CloudBlockBlob)this.getBlob()).uploadBlock(blockId, sourceStream, length, accessCondition, options, opContext);
        }

        @Override
        public void commitBlockList(List<BlockEntry> blockList, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws IOException, StorageException {
            ((CloudBlockBlob)this.getBlob()).commitBlockList(blockList, accessCondition, options, opContext);
        }
    }

    static abstract class CloudBlobWrapperImpl
    implements StorageInterface.CloudBlobWrapper {
        private final CloudBlob blob;

        @Override
        public CloudBlob getBlob() {
            return this.blob;
        }

        @Override
        public URI getUri() {
            return this.getBlob().getUri();
        }

        protected CloudBlobWrapperImpl(CloudBlob blob) {
            this.blob = blob;
        }

        @Override
        public HashMap<String, String> getMetadata() {
            return this.getBlob().getMetadata();
        }

        @Override
        public void delete(OperationContext opContext, SelfRenewingLease lease) throws StorageException {
            this.getBlob().delete(DeleteSnapshotsOption.NONE, this.getLeaseCondition(lease), null, opContext);
        }

        private AccessCondition getLeaseCondition(SelfRenewingLease lease) {
            AccessCondition leaseCondition = null;
            if (lease != null) {
                leaseCondition = AccessCondition.generateLeaseCondition((String)lease.getLeaseID());
            }
            return leaseCondition;
        }

        @Override
        public boolean exists(OperationContext opContext) throws StorageException {
            return this.getBlob().exists(null, null, opContext);
        }

        @Override
        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.getBlob().downloadAttributes(null, null, opContext);
        }

        @Override
        public BlobProperties getProperties() {
            return this.getBlob().getProperties();
        }

        @Override
        public void setMetadata(HashMap<String, String> metadata) {
            this.getBlob().setMetadata(metadata);
        }

        @Override
        public InputStream openInputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return this.getBlob().openInputStream(null, options, opContext);
        }

        public OutputStream openOutputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return ((CloudBlockBlob)this.getBlob()).openOutputStream(null, options, opContext);
        }

        public void upload(InputStream sourceStream, OperationContext opContext) throws StorageException, IOException {
            this.getBlob().upload(sourceStream, 0L, null, null, opContext);
        }

        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return this.getBlob().getContainer();
        }

        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return this.getBlob().getParent();
        }

        @Override
        public void uploadMetadata(OperationContext opContext) throws StorageException {
            this.uploadMetadata(null, null, opContext);
        }

        @Override
        public void uploadMetadata(AccessCondition accessConditions, BlobRequestOptions options, OperationContext opContext) throws StorageException {
            this.getBlob().uploadMetadata(accessConditions, options, opContext);
        }

        @Override
        public void uploadProperties(OperationContext opContext, SelfRenewingLease lease) throws StorageException {
            this.getBlob().uploadProperties(this.getLeaseCondition(lease), null, opContext);
        }

        @Override
        public int getStreamMinimumReadSizeInBytes() {
            return this.getBlob().getStreamMinimumReadSizeInBytes();
        }

        @Override
        public void setStreamMinimumReadSizeInBytes(int minimumReadSizeBytes) {
            this.getBlob().setStreamMinimumReadSizeInBytes(minimumReadSizeBytes);
        }

        @Override
        public void setWriteBlockSizeInBytes(int writeBlockSizeBytes) {
            this.getBlob().setStreamWriteSizeInBytes(writeBlockSizeBytes);
        }

        public StorageUri getStorageUri() {
            return this.getBlob().getStorageUri();
        }

        @Override
        public CopyState getCopyState() {
            return this.getBlob().getCopyState();
        }

        @Override
        public void startCopyFromBlob(StorageInterface.CloudBlobWrapper sourceBlob, BlobRequestOptions options, OperationContext opContext, boolean overwriteDestination) throws StorageException, URISyntaxException {
            AccessCondition dstAccessCondition = overwriteDestination ? null : AccessCondition.generateIfNotExistsCondition();
            this.getBlob().startCopy(sourceBlob.getBlob().getQualifiedUri(), null, dstAccessCondition, options, opContext);
        }

        @Override
        public void downloadRange(long offset, long length, OutputStream outStream, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
            this.getBlob().downloadRange(offset, Long.valueOf(length), outStream, null, options, opContext);
        }

        @Override
        public SelfRenewingLease acquireLease() throws StorageException {
            return new SelfRenewingLease(this, false);
        }
    }

    @InterfaceAudience.Private
    static class CloudBlobContainerWrapperImpl
    extends StorageInterface.CloudBlobContainerWrapper {
        private final CloudBlobContainer container;

        public CloudBlobContainerWrapperImpl(CloudBlobContainer container) {
            this.container = container;
        }

        @Override
        public String getName() {
            return this.container.getName();
        }

        @Override
        public boolean exists(OperationContext opContext) throws StorageException {
            return this.container.exists(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public void create(OperationContext opContext) throws StorageException {
            this.container.create(null, opContext);
        }

        @Override
        public HashMap<String, String> getMetadata() {
            return this.container.getMetadata();
        }

        @Override
        public void setMetadata(HashMap<String, String> metadata) {
            this.container.setMetadata(metadata);
        }

        @Override
        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.container.downloadAttributes(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public void uploadMetadata(OperationContext opContext) throws StorageException {
            this.container.uploadMetadata(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public StorageInterface.CloudBlobDirectoryWrapper getDirectoryReference(String relativePath) throws URISyntaxException, StorageException {
            CloudBlobDirectory dir = this.container.getDirectoryReference(relativePath);
            return new CloudBlobDirectoryWrapperImpl(dir);
        }

        @Override
        public StorageInterface.CloudBlobWrapper getBlockBlobReference(String relativePath) throws URISyntaxException, StorageException {
            return new CloudBlockBlobWrapperImpl(this.container.getBlockBlobReference(relativePath));
        }

        @Override
        public StorageInterface.CloudBlobWrapper getPageBlobReference(String relativePath) throws URISyntaxException, StorageException {
            return new CloudPageBlobWrapperImpl(this.container.getPageBlobReference(relativePath));
        }
    }

    @InterfaceAudience.Private
    static class CloudBlobDirectoryWrapperImpl
    extends StorageInterface.CloudBlobDirectoryWrapper {
        private final CloudBlobDirectory directory;

        public CloudBlobDirectoryWrapperImpl(CloudBlobDirectory directory) {
            this.directory = directory;
        }

        @Override
        public URI getUri() {
            return this.directory.getUri();
        }

        @Override
        public Iterable<ListBlobItem> listBlobs(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) throws URISyntaxException, StorageException {
            return WrappingIterator.wrap(this.directory.listBlobs(prefix, useFlatBlobListing, listingDetails, options, opContext));
        }

        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return this.directory.getContainer();
        }

        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return this.directory.getParent();
        }

        public StorageUri getStorageUri() {
            return this.directory.getStorageUri();
        }
    }

    private static class WrappingIterator
    implements Iterator<ListBlobItem> {
        private final Iterator<ListBlobItem> present;

        public WrappingIterator(Iterator<ListBlobItem> present) {
            this.present = present;
        }

        public static Iterable<ListBlobItem> wrap(final Iterable<ListBlobItem> present) {
            return new Iterable<ListBlobItem>(){

                @Override
                public Iterator<ListBlobItem> iterator() {
                    return new WrappingIterator(present.iterator());
                }
            };
        }

        @Override
        public boolean hasNext() {
            return this.present.hasNext();
        }

        @Override
        public ListBlobItem next() {
            ListBlobItem unwrapped = this.present.next();
            if (unwrapped instanceof CloudBlobDirectory) {
                return new CloudBlobDirectoryWrapperImpl((CloudBlobDirectory)unwrapped);
            }
            if (unwrapped instanceof CloudBlockBlob) {
                return new CloudBlockBlobWrapperImpl((CloudBlockBlob)unwrapped);
            }
            if (unwrapped instanceof CloudPageBlob) {
                return new CloudPageBlobWrapperImpl((CloudPageBlob)unwrapped);
            }
            return unwrapped;
        }

        @Override
        public void remove() {
            this.present.remove();
        }
    }
}

