/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFilters;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFiltersFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;

public class SimilarityFiltersCache {
    private final UTF8StringSerializerDeserializer utf8SerDer = new UTF8StringSerializerDeserializer();
    private final ByteBufferInputStream bbis = new ByteBufferInputStream();
    private final DataInputStream dis = new DataInputStream((InputStream)this.bbis);
    private float similarityThresholdCached = 0.0f;
    private byte[] similarityNameBytesCached = null;
    private SimilarityFilters similarityFiltersCached = null;

    public SimilarityFilters get(float similarityThreshold, byte[] similarityNameBytes, int startOffset, int len) throws HyracksDataException {
        if (similarityThreshold != this.similarityThresholdCached || this.similarityNameBytesCached == null || !Arrays.equals(similarityNameBytes, this.similarityNameBytesCached)) {
            this.bbis.setByteBuffer(ByteBuffer.wrap(similarityNameBytes), startOffset + 1);
            String similarityName = this.utf8SerDer.deserialize((DataInput)this.dis);
            this.similarityNameBytesCached = Arrays.copyOfRange(similarityNameBytes, startOffset, len);
            this.similarityFiltersCached = SimilarityFiltersFactory.getSimilarityFilters(similarityName, similarityThreshold);
        }
        return this.similarityFiltersCached;
    }
}

