/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ACollectionCursor;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.IndexStats;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.util.OptionalBoolean;

public class IndexTupleTranslator
extends AbstractTupleTranslator<Index> {
    private static final int INDEX_PAYLOAD_TUPLE_FIELD_INDEX = 3;
    public static final String GRAM_LENGTH_FIELD_NAME = "GramLength";
    public static final String FULL_TEXT_CONFIG_FIELD_NAME = "FullTextConfig";
    public static final String INDEX_SEARCHKEY_TYPE_FIELD_NAME = "SearchKeyType";
    public static final String INDEX_ISENFORCED_FIELD_NAME = "IsEnforced";
    public static final String INDEX_EXCLUDE_UNKNOWN_FIELD_NAME = "ExcludeUnknownKey";
    public static final String INDEX_SEARCHKEY_SOURCE_INDICATOR_FIELD_NAME = "SearchKeySourceIndicator";
    public static final String INDEX_SEARCHKEY_ELEMENTS_FIELD_NAME = "SearchKeyElements";
    public static final String COMPLEXSEARCHKEY_UNNEST_FIELD_NAME = "UnnestList";
    public static final String COMPLEXSEARCHKEY_PROJECT_FIELD_NAME = "ProjectList";
    public static final String SAMPLE_SEED = "SampleSeed";
    public static final String SAMPLE_CARDINALITY_TARGET = "SampleCardinalityTarget";
    public static final String SOURCE_CARDINALITY = "SourceCardinality";
    public static final String SOURCE_AVG_ITEM_SIZE = "SourceAvgItemSize";
    public static final String INDEXES_STATS = "IndexStats";
    public static final String STATS_NUM_PAGES = "NumPages";
    public static final String STATS_INDEX_NAME = "IndexName";
    protected final TxnId txnId;
    protected final MetadataNode metadataNode;
    protected OrderedListBuilder listBuilder;
    protected OrderedListBuilder innerListBuilder;
    protected OrderedListBuilder primaryKeyListBuilder;
    protected OrderedListBuilder complexSearchKeyNameListBuilder;
    protected IARecordBuilder complexSearchKeyNameRecordBuilder;
    protected IARecordBuilder castRecordBuilder;
    protected OrderedListBuilder indexesStatsListBuilder;
    protected IARecordBuilder indexStatsRecordBuilder;
    protected AOrderedListType stringList;
    protected AOrderedListType int8List;
    protected ArrayBackedValueStorage nameValue;
    protected ArrayBackedValueStorage itemValue;
    protected AMutableInt8 aInt8;
    protected AMutableInt64 aInt64;
    protected ISerializerDeserializer<AInt8> int8Serde;

    protected IndexTupleTranslator(TxnId txnId, MetadataNode metadataNode, boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.INDEX_DATASET, 3);
        this.txnId = txnId;
        this.metadataNode = metadataNode;
        if (getTuple) {
            this.listBuilder = new OrderedListBuilder();
            this.innerListBuilder = new OrderedListBuilder();
            this.primaryKeyListBuilder = new OrderedListBuilder();
            this.complexSearchKeyNameRecordBuilder = new RecordBuilder();
            this.castRecordBuilder = new RecordBuilder();
            this.indexesStatsListBuilder = new OrderedListBuilder();
            this.indexStatsRecordBuilder = new RecordBuilder();
            this.complexSearchKeyNameListBuilder = new OrderedListBuilder();
            this.stringList = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
            this.int8List = new AOrderedListType((IAType)BuiltinType.AINT8, null);
            this.nameValue = new ArrayBackedValueStorage();
            this.itemValue = new ArrayBackedValueStorage();
            this.aInt8 = new AMutableInt8(0);
            this.aInt64 = new AMutableInt64(0L);
            this.int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
        }
    }

    @Override
    protected Index createMetadataEntityFromARecord(ARecord indexRecord) throws AlgebricksException {
        Index.AbstractIndexDetails indexDetails;
        boolean isOverridingKeyTypes;
        String dataverseCanonicalName = ((AString)indexRecord.getValueByPos(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String datasetName = ((AString)indexRecord.getValueByPos(1)).getStringValue();
        String indexName = ((AString)indexRecord.getValueByPos(2)).getStringValue();
        DatasetConfig.IndexType indexType = DatasetConfig.IndexType.valueOf((String)((AString)indexRecord.getValueByPos(3)).getStringValue());
        boolean isPrimaryIndex = ((ABoolean)indexRecord.getValueByPos(5)).getBoolean();
        List<Object> searchElements = new ArrayList();
        switch (Index.IndexCategory.of(indexType)) {
            case VALUE: 
            case TEXT: {
                IACursor fieldNameCursor = ((AOrderedList)indexRecord.getValueByPos(4)).getCursor();
                while (fieldNameCursor.next()) {
                    AOrderedList fieldNameList = (AOrderedList)fieldNameCursor.get();
                    IACursor nestedFieldNameCursor = fieldNameList.getCursor();
                    ArrayList<String> nestedFieldName = new ArrayList<String>();
                    while (nestedFieldNameCursor.next()) {
                        nestedFieldName.add(((AString)nestedFieldNameCursor.get()).getStringValue());
                    }
                    searchElements.add(new Pair(null, Collections.singletonList(nestedFieldName)));
                }
                break;
            }
            case ARRAY: {
                int complexSearchKeyFieldPos = indexRecord.getType().getFieldIndex(INDEX_SEARCHKEY_ELEMENTS_FIELD_NAME);
                ACollectionCursor complexSearchKeyCursor = new ACollectionCursor();
                if (complexSearchKeyFieldPos > 0) {
                    complexSearchKeyCursor = ((AOrderedList)indexRecord.getValueByPos(complexSearchKeyFieldPos)).getCursor();
                }
                while (complexSearchKeyCursor.next()) {
                    Pair searchElement;
                    IAObject complexSearchKeyItem = complexSearchKeyCursor.get();
                    switch (complexSearchKeyItem.getType().getTypeTag()) {
                        case ARRAY: {
                            AOrderedList complexSearchKeyArray = (AOrderedList)complexSearchKeyItem;
                            ArrayList<String> project = new ArrayList<String>(complexSearchKeyArray.size());
                            AOrderedList innerListForArray = (AOrderedList)complexSearchKeyArray.getItem(0);
                            IACursor innerListCursorForArray = innerListForArray.getCursor();
                            while (innerListCursorForArray.next()) {
                                project.add(((AString)innerListCursorForArray.get()).getStringValue());
                            }
                            searchElement = new Pair(null, Collections.singletonList(project));
                            break;
                        }
                        case OBJECT: {
                            ARecord complexSearchKeyRecord = (ARecord)complexSearchKeyItem;
                            ARecordType complexSearchKeyRecordType = complexSearchKeyRecord.getType();
                            int unnestFieldPos = complexSearchKeyRecordType.getFieldIndex(COMPLEXSEARCHKEY_UNNEST_FIELD_NAME);
                            if (unnestFieldPos < 0) {
                                throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{complexSearchKeyRecord.toJSON()});
                            }
                            AOrderedList unnestFieldList = (AOrderedList)complexSearchKeyRecord.getValueByPos(unnestFieldPos);
                            ArrayList unnestList = new ArrayList(unnestFieldList.size());
                            IACursor unnestFieldListCursor = unnestFieldList.getCursor();
                            while (unnestFieldListCursor.next()) {
                                AOrderedList innerList = (AOrderedList)unnestFieldListCursor.get();
                                ArrayList<String> unnestPath = new ArrayList<String>(innerList.size());
                                IACursor innerListCursor = innerList.getCursor();
                                while (innerListCursor.next()) {
                                    unnestPath.add(((AString)innerListCursor.get()).getStringValue());
                                }
                                unnestList.add(unnestPath);
                            }
                            int projectFieldPos = complexSearchKeyRecordType.getFieldIndex(COMPLEXSEARCHKEY_PROJECT_FIELD_NAME);
                            ArrayList projectList = new ArrayList();
                            if (projectFieldPos >= 0) {
                                AOrderedList projectFieldList = (AOrderedList)complexSearchKeyRecord.getValueByPos(projectFieldPos);
                                projectList = new ArrayList(projectFieldList.size());
                                IACursor projectFieldListCursor = projectFieldList.getCursor();
                                while (projectFieldListCursor.next()) {
                                    AOrderedList innerList = (AOrderedList)projectFieldListCursor.get();
                                    ArrayList<String> projectPath = new ArrayList<String>(innerList.size());
                                    IACursor innerListCursor = innerList.getCursor();
                                    while (innerListCursor.next()) {
                                        projectPath.add(((AString)innerListCursor.get()).getStringValue());
                                    }
                                    projectList.add(projectPath);
                                }
                            } else {
                                projectList.add(null);
                            }
                            searchElement = new Pair(unnestList, projectList);
                            break;
                        }
                        default: {
                            throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{complexSearchKeyItem.toJSON()});
                        }
                    }
                    searchElements.add(searchElement);
                }
                break;
            }
            case SAMPLE: {
                searchElements = Collections.emptyList();
                break;
            }
            default: {
                throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{indexType.toString()});
            }
        }
        int searchElementCount = searchElements.size();
        String fullTextConfig = null;
        int fullTextConfigPos = indexRecord.getType().getFieldIndex(FULL_TEXT_CONFIG_FIELD_NAME);
        if (fullTextConfigPos >= 0) {
            fullTextConfig = ((AString)indexRecord.getValueByPos(fullTextConfigPos)).getStringValue();
        }
        ArrayList<Integer> keyFieldSourceIndicator = new ArrayList<Integer>(searchElementCount);
        int keyFieldSourceIndicatorIndex = indexRecord.getType().getFieldIndex(INDEX_SEARCHKEY_SOURCE_INDICATOR_FIELD_NAME);
        if (keyFieldSourceIndicatorIndex >= 0) {
            IACursor cursor = ((AOrderedList)indexRecord.getValueByPos(keyFieldSourceIndicatorIndex)).getCursor();
            while (cursor.next()) {
                keyFieldSourceIndicator.add(Integer.valueOf(((AInt8)cursor.get()).getByteValue()));
            }
        } else {
            for (int index = 0; index < searchElementCount; ++index) {
                keyFieldSourceIndicator.add(0);
            }
        }
        int indexKeyTypeFieldPos = indexRecord.getType().getFieldIndex(INDEX_SEARCHKEY_TYPE_FIELD_NAME);
        ACollectionCursor fieldTypeCursor = new ACollectionCursor();
        if (indexKeyTypeFieldPos > 0) {
            fieldTypeCursor = ((AOrderedList)indexRecord.getValueByPos(indexKeyTypeFieldPos)).getCursor();
        }
        ArrayList<List<Object>> searchKeyType = new ArrayList<List<Object>>(searchElementCount);
        block29: while (fieldTypeCursor.next()) {
            IAObject fieldTypeItem = fieldTypeCursor.get();
            switch (fieldTypeItem.getType().getTypeTag()) {
                case STRING: {
                    String typeName = ((AString)fieldTypeItem).getStringValue();
                    IAType fieldType = BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.txnId, dataverseName, typeName);
                    searchKeyType.add(Collections.singletonList(fieldType));
                    continue block29;
                }
                case ARRAY: {
                    String typeName;
                    ArrayList<IAType> fieldTypes = new ArrayList<IAType>();
                    AOrderedList fieldTypeList = (AOrderedList)fieldTypeItem;
                    IACursor fieldTypeListCursor = fieldTypeList.getCursor();
                    while (fieldTypeListCursor.next()) {
                        typeName = ((AString)fieldTypeListCursor.get()).getStringValue();
                        fieldTypes.add(BuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.txnId, dataverseName, typeName));
                    }
                    searchKeyType.add(fieldTypes);
                    continue block29;
                }
            }
            throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{fieldTypeItem.toJSON()});
        }
        if (searchKeyType.isEmpty()) {
            Dataset dataset = this.metadataNode.getDataset(this.txnId, dataverseName, datasetName);
            String datatypeName = dataset.getItemTypeName();
            DataverseName datatypeDataverseName = dataset.getItemTypeDataverseName();
            ARecordType recordDt = (ARecordType)this.metadataNode.getDatatype(this.txnId, datatypeDataverseName, datatypeName).getDatatype();
            String metatypeName = dataset.getMetaItemTypeName();
            DataverseName metatypeDataverseName = dataset.getMetaItemTypeDataverseName();
            ARecordType metaDt = null;
            if (metatypeName != null && metatypeDataverseName != null) {
                metaDt = (ARecordType)this.metadataNode.getDatatype(this.txnId, metatypeDataverseName, metatypeName).getDatatype();
            }
            searchKeyType = new ArrayList(searchElementCount);
            for (int i = 0; i < searchElementCount; ++i) {
                boolean inputTypeNullable;
                boolean inputTypeMissable;
                ARecordType inputTypePrime;
                ARecordType sourceRecordType;
                Pair searchElement = (Pair)searchElements.get(i);
                List unnestPathList = (List)searchElement.first;
                List projectPathList = (List)searchElement.second;
                ARecordType aRecordType = sourceRecordType = (Integer)keyFieldSourceIndicator.get(i) == 1 ? metaDt : recordDt;
                if (unnestPathList == null) {
                    inputTypePrime = sourceRecordType;
                    inputTypeMissable = false;
                    inputTypeNullable = false;
                } else {
                    Triple<IAType, Boolean, Boolean> unnestTypeResult = KeyFieldTypeUtil.getKeyUnnestType(sourceRecordType, unnestPathList, null);
                    if (unnestTypeResult == null) {
                        inputTypePrime = null;
                        inputTypeMissable = true;
                        inputTypeNullable = true;
                    } else {
                        inputTypePrime = (IAType)unnestTypeResult.first;
                        inputTypeNullable = (Boolean)unnestTypeResult.second;
                        inputTypeMissable = (Boolean)unnestTypeResult.third;
                    }
                }
                ArrayList<IAType> projectTypeList = new ArrayList<IAType>(projectPathList.size());
                for (List projectPath : projectPathList) {
                    boolean projectTypeMissable;
                    boolean projectTypeNullable;
                    ARecordType projectTypePrime;
                    if (projectPath == null) {
                        projectTypePrime = inputTypePrime;
                        projectTypeNullable = inputTypeNullable;
                        projectTypeMissable = inputTypeMissable;
                    } else if (inputTypePrime == null || projectPath.size() == 1 && ((String)projectPath.get(0)).isEmpty()) {
                        projectTypePrime = null;
                        projectTypeMissable = true;
                        projectTypeNullable = true;
                    } else {
                        if (inputTypePrime.getTypeTag() != ATypeTag.OBJECT) {
                            throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{projectPath.toString()});
                        }
                        Triple<IAType, Boolean, Boolean> projectTypeResult = KeyFieldTypeUtil.getKeyProjectType(inputTypePrime, projectPath, null);
                        if (projectTypeResult == null) {
                            throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{projectPath.toString()});
                        }
                        projectTypePrime = (IAType)projectTypeResult.first;
                        projectTypeNullable = inputTypeNullable || (Boolean)projectTypeResult.second != false;
                        projectTypeMissable = inputTypeMissable || (Boolean)projectTypeResult.third != false;
                    }
                    IAType projectType = projectTypePrime == null ? null : KeyFieldTypeUtil.makeUnknownableType((IAType)projectTypePrime, projectTypeNullable, projectTypeMissable);
                    projectTypeList.add(projectType);
                }
                searchKeyType.add(projectTypeList);
            }
            isOverridingKeyTypes = false;
        } else {
            isOverridingKeyTypes = true;
        }
        switch (Index.IndexCategory.of(indexType)) {
            case VALUE: {
                boolean isBtreeIdx;
                List<List<String>> keyFieldNames = searchElements.stream().map(Pair::getSecond).map(l -> (List)l.get(0)).collect(Collectors.toList());
                List<IAType> keyFieldTypes = searchKeyType.stream().map(l -> (IAType)l.get(0)).collect(Collectors.toList());
                OptionalBoolean excludeUnknownKey = OptionalBoolean.empty();
                OptionalBoolean castDefaultNull = OptionalBoolean.empty();
                String datetimeFormat = null;
                String dateFormat = null;
                String timeFormat = null;
                boolean bl = isBtreeIdx = indexType == DatasetConfig.IndexType.BTREE && !isPrimaryIndex && !keyFieldNames.isEmpty();
                if (isBtreeIdx) {
                    IAObject defaultVal;
                    ARecord castRec;
                    ARecordType castRecType;
                    int defaultFieldPos;
                    IAObject recValue;
                    int castPos;
                    excludeUnknownKey = OptionalBoolean.FALSE();
                    int excludeUnknownKeyPos = indexRecord.getType().getFieldIndex(INDEX_EXCLUDE_UNKNOWN_FIELD_NAME);
                    if (excludeUnknownKeyPos >= 0) {
                        excludeUnknownKey = OptionalBoolean.of((boolean)((ABoolean)indexRecord.getValueByPos(excludeUnknownKeyPos)).getBoolean());
                    }
                    if ((castPos = indexRecord.getType().getFieldIndex("Cast")) >= 0 && (recValue = indexRecord.getValueByPos(castPos)).getType().getTypeTag() == ATypeTag.OBJECT && (defaultFieldPos = (castRecType = (castRec = (ARecord)recValue).getType()).getFieldIndex("Default")) >= 0 && (defaultVal = castRec.getValueByPos(defaultFieldPos)).getType().getTypeTag() == ATypeTag.NULL) {
                        castDefaultNull = OptionalBoolean.TRUE();
                        Triple<String, String, String> dateTimeFormats = IndexTupleTranslator.getDateTimeFormats(castRec);
                        datetimeFormat = (String)dateTimeFormats.first;
                        dateFormat = (String)dateTimeFormats.second;
                        timeFormat = (String)dateTimeFormats.third;
                    }
                }
                indexDetails = new Index.ValueIndexDetails(keyFieldNames, keyFieldSourceIndicator, keyFieldTypes, isOverridingKeyTypes, excludeUnknownKey, castDefaultNull, datetimeFormat, dateFormat, timeFormat);
                break;
            }
            case TEXT: {
                List<List<String>> keyFieldNames = searchElements.stream().map(Pair::getSecond).map(l -> (List)l.get(0)).collect(Collectors.toList());
                List<IAType> keyFieldTypes = searchKeyType.stream().map(l -> (IAType)l.get(0)).collect(Collectors.toList());
                int gramLength = -1;
                int gramLenPos = indexRecord.getType().getFieldIndex(GRAM_LENGTH_FIELD_NAME);
                if (gramLenPos >= 0) {
                    gramLength = ((AInt32)indexRecord.getValueByPos(gramLenPos)).getIntegerValue();
                }
                indexDetails = new Index.TextIndexDetails(keyFieldNames, keyFieldSourceIndicator, keyFieldTypes, isOverridingKeyTypes, gramLength, fullTextConfig);
                break;
            }
            case ARRAY: {
                ArrayList<Index.ArrayIndexElement> elementList = new ArrayList<Index.ArrayIndexElement>(searchElementCount);
                for (int i = 0; i < searchElementCount; ++i) {
                    Pair searchElement = (Pair)searchElements.get(i);
                    List typeList = (List)searchKeyType.get(i);
                    int sourceIndicator = (Integer)keyFieldSourceIndicator.get(i);
                    elementList.add(new Index.ArrayIndexElement((List)searchElement.first, (List)searchElement.second, typeList, sourceIndicator));
                }
                indexDetails = new Index.ArrayIndexDetails(elementList, isOverridingKeyTypes);
                break;
            }
            case SAMPLE: {
                HashMap<String, IndexStats> indexesStats;
                List<List<String>> keyFieldNames = searchElements.stream().map(Pair::getSecond).map(l -> (List)l.get(0)).collect(Collectors.toList());
                List<IAType> keyFieldTypes = searchKeyType.stream().map(l -> (IAType)l.get(0)).collect(Collectors.toList());
                int sampleSeedPos = indexRecord.getType().getFieldIndex(SAMPLE_SEED);
                if (sampleSeedPos < 0) {
                    throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{SAMPLE_SEED});
                }
                long sampleSeed = ((AInt64)indexRecord.getValueByPos(sampleSeedPos)).getLongValue();
                int sampleCardinalityTargetPos = indexRecord.getType().getFieldIndex(SAMPLE_CARDINALITY_TARGET);
                if (sampleCardinalityTargetPos < 0) {
                    throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{SAMPLE_CARDINALITY_TARGET});
                }
                int sampleCardinalityTarget = ((AInt32)indexRecord.getValueByPos(sampleCardinalityTargetPos)).getIntegerValue();
                int sourceCardinalityPos = indexRecord.getType().getFieldIndex(SOURCE_CARDINALITY);
                if (sourceCardinalityPos < 0) {
                    throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{SOURCE_CARDINALITY});
                }
                long sourceCardinality = ((AInt64)indexRecord.getValueByPos(sourceCardinalityPos)).getLongValue();
                int sourceAvgItemSizePos = indexRecord.getType().getFieldIndex(SOURCE_AVG_ITEM_SIZE);
                if (sourceAvgItemSizePos < 0) {
                    throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{SOURCE_AVG_ITEM_SIZE});
                }
                int sourceAvgItemSize = ((AInt32)indexRecord.getValueByPos(sourceAvgItemSizePos)).getIntegerValue();
                int indexesStatsPos = indexRecord.getType().getFieldIndex(INDEXES_STATS);
                if (indexesStatsPos >= 0) {
                    AOrderedList indexesStatsList = (AOrderedList)indexRecord.getValueByPos(indexesStatsPos);
                    int numIndexes = indexesStatsList.size();
                    indexesStats = numIndexes > 0 ? new HashMap<String, IndexStats>() : Collections.emptyMap();
                    for (int i = 0; i < numIndexes; ++i) {
                        ARecord stats = (ARecord)indexesStatsList.getItem(i);
                        IAObject numPages = stats.getValueByPos(stats.getType().getFieldIndex(STATS_NUM_PAGES));
                        IAObject idxNameObj = stats.getValueByPos(stats.getType().getFieldIndex(STATS_INDEX_NAME));
                        String idxName = ((AString)idxNameObj).getStringValue();
                        IndexStats idxStats = new IndexStats(idxName, ((AInt64)numPages).getLongValue());
                        indexesStats.put(idxName, idxStats);
                    }
                } else {
                    indexesStats = Collections.emptyMap();
                }
                indexDetails = new Index.SampleIndexDetails(keyFieldNames, keyFieldSourceIndicator, keyFieldTypes, sampleCardinalityTarget, sourceCardinality, sourceAvgItemSize, sampleSeed, indexesStats);
                break;
            }
            default: {
                throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{indexType.toString()});
            }
        }
        int isEnforcedFieldPos = indexRecord.getType().getFieldIndex(INDEX_ISENFORCED_FIELD_NAME);
        Boolean isEnforcingKeys = false;
        if (isEnforcedFieldPos > 0) {
            isEnforcingKeys = ((ABoolean)indexRecord.getValueByPos(isEnforcedFieldPos)).getBoolean();
        }
        int pendingOp = ((AInt32)indexRecord.getValueByPos(7)).getIntegerValue();
        return new Index(dataverseName, datasetName, indexName, indexType, indexDetails, isEnforcingKeys, isPrimaryIndex, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Index index) throws HyracksDataException, AlgebricksException {
        List<Object> searchKey;
        String dataverseCanonicalName = index.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(index.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(index.getIndexName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.INDEX_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(index.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(index.getIndexName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        DatasetConfig.IndexType indexType = index.getIndexType();
        this.fieldValue.reset();
        this.aString.setValue(indexType.toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.primaryKeyListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.INDEX_RECORDTYPE.getFieldTypes()[4]));
        switch (Index.IndexCategory.of(indexType)) {
            case VALUE: {
                searchKey = ((Index.ValueIndexDetails)index.getIndexDetails()).getKeyFieldNames();
                break;
            }
            case TEXT: {
                searchKey = ((Index.TextIndexDetails)index.getIndexDetails()).getKeyFieldNames();
                break;
            }
            case ARRAY: {
                searchKey = Collections.emptyList();
                break;
            }
            case SAMPLE: {
                searchKey = ((Index.SampleIndexDetails)index.getIndexDetails()).getKeyFieldNames();
                break;
            }
            default: {
                throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{indexType.toString()});
            }
        }
        for (List field : searchKey) {
            this.listBuilder.reset((AbstractCollectionType)this.stringList);
            for (String subField : field) {
                this.itemValue.reset();
                this.aString.setValue(subField);
                this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.itemValue);
            }
            this.itemValue.reset();
            this.listBuilder.write(this.itemValue.getDataOutput(), true);
            this.primaryKeyListBuilder.addItem((IValueReference)this.itemValue);
        }
        this.fieldValue.reset();
        this.primaryKeyListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        if (index.isPrimaryIndex()) {
            this.booleanSerde.serialize((Object)ABoolean.TRUE, this.fieldValue.getDataOutput());
        } else {
            this.booleanSerde.serialize((Object)ABoolean.FALSE, this.fieldValue.getDataOutput());
        }
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.int32Serde.serialize((Object)new AInt32(index.getPendingOp()), this.fieldValue.getDataOutput());
        this.recordBuilder.addField(7, (IValueReference)this.fieldValue);
        this.writeOpenFields(index);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeOpenFields(Index index) throws HyracksDataException, AlgebricksException {
        switch (Index.IndexCategory.of(index.getIndexType())) {
            case TEXT: {
                Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)index.getIndexDetails();
                this.writeGramLength(textIndexDetails);
                this.writeFullTextConfig(textIndexDetails);
                break;
            }
            case ARRAY: {
                this.writeComplexSearchKeys((Index.ArrayIndexDetails)index.getIndexDetails());
            }
        }
        this.writeSearchKeyType(index);
        this.writeEnforced(index);
        this.writeSearchKeySourceIndicator(index);
        this.writeExcludeUnknownKey(index);
        this.writeCast(index);
        this.writeSampleDetails(index);
    }

    private void writeComplexSearchKeys(Index.ArrayIndexDetails indexDetails) throws HyracksDataException {
        this.complexSearchKeyNameListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
        for (Index.ArrayIndexElement element : indexDetails.getElementList()) {
            if (element.getUnnestList().isEmpty()) {
                this.buildSearchKeyNameList(element.getProjectList());
                this.itemValue.reset();
                this.listBuilder.write(this.itemValue.getDataOutput(), true);
            } else {
                this.complexSearchKeyNameRecordBuilder.reset(RecordUtil.FULLY_OPEN_RECORD_TYPE);
                this.nameValue.reset();
                this.aString.setValue(COMPLEXSEARCHKEY_UNNEST_FIELD_NAME);
                this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
                this.buildSearchKeyNameList(element.getUnnestList());
                this.itemValue.reset();
                this.listBuilder.write(this.itemValue.getDataOutput(), true);
                this.complexSearchKeyNameRecordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.itemValue);
                if (element.getProjectList().get(0) != null) {
                    this.nameValue.reset();
                    this.aString.setValue(COMPLEXSEARCHKEY_PROJECT_FIELD_NAME);
                    this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
                    this.buildSearchKeyNameList(element.getProjectList());
                    this.itemValue.reset();
                    this.listBuilder.write(this.itemValue.getDataOutput(), true);
                    this.complexSearchKeyNameRecordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.itemValue);
                }
                this.itemValue.reset();
                this.complexSearchKeyNameRecordBuilder.write(this.itemValue.getDataOutput(), true);
            }
            this.complexSearchKeyNameListBuilder.addItem((IValueReference)this.itemValue);
        }
        this.nameValue.reset();
        this.fieldValue.reset();
        this.aString.setValue(INDEX_SEARCHKEY_ELEMENTS_FIELD_NAME);
        this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
        this.complexSearchKeyNameListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
    }

    private void buildSearchKeyNameList(List<List<String>> fieldList) throws HyracksDataException {
        this.listBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
        for (List<String> nestedField : fieldList) {
            if (nestedField == null) {
                this.itemValue.reset();
                this.nullSerde.serialize((Object)ANull.NULL, this.itemValue.getDataOutput());
            } else {
                this.innerListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
                for (String subField : nestedField) {
                    this.itemValue.reset();
                    this.aString.setValue(subField);
                    this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                    this.innerListBuilder.addItem((IValueReference)this.itemValue);
                }
                this.itemValue.reset();
                this.innerListBuilder.write(this.itemValue.getDataOutput(), true);
            }
            this.listBuilder.addItem((IValueReference)this.itemValue);
        }
    }

    private void writeGramLength(Index.TextIndexDetails index) throws HyracksDataException {
        if (index.getGramLength() > 0) {
            this.fieldValue.reset();
            this.nameValue.reset();
            this.aString.setValue(GRAM_LENGTH_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.int32Serde.serialize((Object)new AInt32(index.getGramLength()), this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
    }

    private void writeFullTextConfig(Index.TextIndexDetails index) throws HyracksDataException {
        if (!Strings.isNullOrEmpty((String)index.getFullTextConfigName())) {
            this.nameValue.reset();
            this.aString.setValue(FULL_TEXT_CONFIG_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(index.getFullTextConfigName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
    }

    private void writeSearchKeyType(Index index) throws HyracksDataException, AlgebricksException {
        if (!index.getIndexDetails().isOverridingKeyFieldTypes()) {
            return;
        }
        OrderedListBuilder typeListBuilder = new OrderedListBuilder();
        typeListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
        this.nameValue.reset();
        this.aString.setValue(INDEX_SEARCHKEY_TYPE_FIELD_NAME);
        this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
        switch (Index.IndexCategory.of(index.getIndexType())) {
            case VALUE: {
                for (IAType type : ((Index.ValueIndexDetails)index.getIndexDetails()).getKeyFieldTypes()) {
                    this.itemValue.reset();
                    this.aString.setValue(type.getTypeName());
                    this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                    typeListBuilder.addItem((IValueReference)this.itemValue);
                }
                break;
            }
            case TEXT: {
                for (IAType type : ((Index.TextIndexDetails)index.getIndexDetails()).getKeyFieldTypes()) {
                    this.itemValue.reset();
                    this.aString.setValue(type.getTypeName());
                    this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                    typeListBuilder.addItem((IValueReference)this.itemValue);
                }
                break;
            }
            case ARRAY: {
                for (Index.ArrayIndexElement element : ((Index.ArrayIndexDetails)index.getIndexDetails()).getElementList()) {
                    this.listBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
                    for (IAType type : element.getTypeList()) {
                        this.itemValue.reset();
                        this.aString.setValue(type.getTypeName());
                        this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                        this.listBuilder.addItem((IValueReference)this.itemValue);
                    }
                    this.itemValue.reset();
                    this.listBuilder.write(this.itemValue.getDataOutput(), true);
                    typeListBuilder.addItem((IValueReference)this.itemValue);
                }
                break;
            }
            default: {
                throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{index.getIndexType().toString()});
            }
        }
        this.fieldValue.reset();
        typeListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
    }

    private void writeEnforced(Index index) throws HyracksDataException {
        if (index.isEnforced()) {
            this.fieldValue.reset();
            this.nameValue.reset();
            this.aString.setValue(INDEX_ISENFORCED_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.booleanSerde.serialize((Object)ABoolean.TRUE, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
    }

    private void writeSearchKeySourceIndicator(Index index) throws HyracksDataException, AlgebricksException {
        List<Integer> keySourceIndicator;
        switch (Index.IndexCategory.of(index.getIndexType())) {
            case VALUE: {
                keySourceIndicator = ((Index.ValueIndexDetails)index.getIndexDetails()).getKeyFieldSourceIndicators();
                break;
            }
            case TEXT: {
                keySourceIndicator = ((Index.TextIndexDetails)index.getIndexDetails()).getKeyFieldSourceIndicators();
                break;
            }
            case ARRAY: {
                keySourceIndicator = ((Index.ArrayIndexDetails)index.getIndexDetails()).getElementList().stream().map(Index.ArrayIndexElement::getSourceIndicator).collect(Collectors.toList());
                break;
            }
            case SAMPLE: {
                keySourceIndicator = ((Index.SampleIndexDetails)index.getIndexDetails()).getKeyFieldSourceIndicators();
                break;
            }
            default: {
                throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{index.getIndexType().toString()});
            }
        }
        boolean needSerialization = false;
        if (keySourceIndicator != null) {
            for (int source : keySourceIndicator) {
                if (source == 0) continue;
                needSerialization = true;
                break;
            }
        }
        if (needSerialization) {
            this.listBuilder.reset((AbstractCollectionType)this.int8List);
            this.nameValue.reset();
            this.aString.setValue(INDEX_SEARCHKEY_SOURCE_INDICATOR_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            for (int source : keySourceIndicator) {
                this.itemValue.reset();
                this.aInt8.setValue((byte)source);
                this.int8Serde.serialize((Object)this.aInt8, this.itemValue.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.itemValue);
            }
            this.fieldValue.reset();
            this.listBuilder.write(this.fieldValue.getDataOutput(), true);
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
    }

    private void writeExcludeUnknownKey(Index index) throws HyracksDataException {
        switch (index.getIndexType()) {
            case BTREE: {
                if (index.isPrimaryIndex() || index.isPrimaryKeyIndex()) break;
                OptionalBoolean excludeUnknown = ((Index.ValueIndexDetails)index.getIndexDetails()).getExcludeUnknownKey();
                ABoolean bVal = excludeUnknown.isEmpty() ? ABoolean.FALSE : ABoolean.valueOf((boolean)excludeUnknown.get());
                this.fieldValue.reset();
                this.nameValue.reset();
                this.aString.setValue(INDEX_EXCLUDE_UNKNOWN_FIELD_NAME);
                this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
                this.booleanSerde.serialize((Object)bVal, this.fieldValue.getDataOutput());
                this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
                break;
            }
            case ARRAY: {
                this.fieldValue.reset();
                this.nameValue.reset();
                this.aString.setValue(INDEX_EXCLUDE_UNKNOWN_FIELD_NAME);
                this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
                this.booleanSerde.serialize((Object)ABoolean.TRUE, this.fieldValue.getDataOutput());
                this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
            }
        }
    }

    private void writeCast(Index index) throws HyracksDataException {
        Index.ValueIndexDetails indexDetails;
        boolean defaultNull;
        if (index.getIndexType() == DatasetConfig.IndexType.BTREE && !index.isPrimaryIndex() && !index.isPrimaryKeyIndex() && (defaultNull = (indexDetails = (Index.ValueIndexDetails)index.getIndexDetails()).getCastDefaultNull().getOrElse(false))) {
            this.castRecordBuilder.reset(RecordUtil.FULLY_OPEN_RECORD_TYPE);
            this.fieldValue.reset();
            this.nameValue.reset();
            this.aString.setValue("Default");
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.nullSerde.serialize((Object)ANull.NULL, this.fieldValue.getDataOutput());
            this.castRecordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
            String datetimeFormat = indexDetails.getCastDatetimeFormat();
            String dateFormat = indexDetails.getCastDateFormat();
            String timeFormat = indexDetails.getCastTimeFormat();
            IndexTupleTranslator.writeDateTimeFormats(datetimeFormat, dateFormat, timeFormat, this.castRecordBuilder, this.aString, (ISerializerDeserializer<ANull>)this.nullSerde, (ISerializerDeserializer<AString>)this.stringSerde, this.nameValue, this.fieldValue, this.itemValue);
            this.nameValue.reset();
            this.fieldValue.reset();
            this.aString.setValue("Cast");
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.castRecordBuilder.write(this.fieldValue.getDataOutput(), true);
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
        }
    }

    private void writeSampleDetails(Index index) throws HyracksDataException {
        if (index.getIndexType() == DatasetConfig.IndexType.SAMPLE) {
            Index.SampleIndexDetails indexDetails = (Index.SampleIndexDetails)index.getIndexDetails();
            this.nameValue.reset();
            this.fieldValue.reset();
            this.aString.setValue(SAMPLE_SEED);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.int64Serde.serialize((Object)new AInt64(indexDetails.getSampleSeed()), this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
            this.nameValue.reset();
            this.fieldValue.reset();
            this.aString.setValue(SAMPLE_CARDINALITY_TARGET);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.int32Serde.serialize((Object)new AInt32(indexDetails.getSampleCardinalityTarget()), this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
            this.nameValue.reset();
            this.fieldValue.reset();
            this.aString.setValue(SOURCE_CARDINALITY);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.int64Serde.serialize((Object)new AInt64(indexDetails.getSourceCardinality()), this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
            this.nameValue.reset();
            this.fieldValue.reset();
            this.aString.setValue(SOURCE_AVG_ITEM_SIZE);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.int32Serde.serialize((Object)new AInt32(indexDetails.getSourceAvgItemSize()), this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
            Map<String, IndexStats> indexesStats = indexDetails.getIndexesStats();
            if (!indexesStats.isEmpty()) {
                this.indexesStatsListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
                for (Map.Entry<String, IndexStats> stats : indexesStats.entrySet()) {
                    this.indexStatsRecordBuilder.reset(RecordUtil.FULLY_OPEN_RECORD_TYPE);
                    this.nameValue.reset();
                    this.itemValue.reset();
                    this.aString.setValue(STATS_INDEX_NAME);
                    this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
                    this.aString.setValue(stats.getKey());
                    this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                    this.indexStatsRecordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.itemValue);
                    this.nameValue.reset();
                    this.itemValue.reset();
                    this.aString.setValue(STATS_NUM_PAGES);
                    this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
                    this.aInt64.setValue(stats.getValue().getNumPages());
                    this.int64Serde.serialize((Object)this.aInt64, this.itemValue.getDataOutput());
                    this.indexStatsRecordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.itemValue);
                    this.itemValue.reset();
                    this.indexStatsRecordBuilder.write(this.itemValue.getDataOutput(), true);
                    this.indexesStatsListBuilder.addItem((IValueReference)this.itemValue);
                }
                this.nameValue.reset();
                this.fieldValue.reset();
                this.aString.setValue(INDEXES_STATS);
                this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
                this.indexesStatsListBuilder.write(this.fieldValue.getDataOutput(), true);
                this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
            }
        }
    }
}

