/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.util.Arrays;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameFreeSlotPolicy;

class FrameFreeSlotLastFit
implements IFrameFreeSlotPolicy {
    private static int INITIAL_CAPACITY = 10;
    private final int initialNumFrames;
    private FrameSpace[] frameSpaces;
    private int size;

    FrameFreeSlotLastFit(int initialFrameNumber) {
        this.initialNumFrames = initialFrameNumber;
        this.frameSpaces = new FrameSpace[this.initialNumFrames];
        this.size = 0;
    }

    FrameFreeSlotLastFit() {
        this(INITIAL_CAPACITY);
    }

    @Override
    public int popBestFit(int tobeInsertedSize) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.frameSpaces[i].freeSpace < tobeInsertedSize) continue;
            FrameSpace ret = this.frameSpaces[i];
            System.arraycopy(this.frameSpaces, i + 1, this.frameSpaces, i, this.size - i - 1);
            this.frameSpaces[--this.size] = ret;
            return ret.frameId;
        }
        return -1;
    }

    @Override
    public void pushNewFrame(int frameID, int freeSpace) {
        if (this.frameSpaces == null) {
            this.frameSpaces = new FrameSpace[this.initialNumFrames];
        }
        if (this.size >= this.frameSpaces.length) {
            this.frameSpaces = Arrays.copyOf(this.frameSpaces, this.size * 2);
        }
        if (this.frameSpaces[this.size] == null) {
            this.frameSpaces[this.size++] = new FrameSpace(frameID, freeSpace);
        } else {
            this.frameSpaces[this.size++].reset(frameID, freeSpace);
        }
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    @Override
    public void close() {
        this.size = 0;
        this.frameSpaces = null;
    }

    private class FrameSpace {
        private int frameId;
        private int freeSpace;

        FrameSpace(int frameId, int freeSpace) {
            this.reset(frameId, freeSpace);
        }

        void reset(int frameId, int freeSpace) {
            this.frameId = frameId;
            this.freeSpace = freeSpace;
        }
    }
}

