/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.PrelocatedRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.net.InetAddress;
import java.util.List;

public class QueryLocator
implements Locator {
    private long counter = 0L;

    @Override
    public void locateAndDispatch(CouchbaseRequest request, List<Node> nodes, ClusterConfig config, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        Node node;
        int offset;
        int i;
        if (request instanceof PrelocatedRequest && ((PrelocatedRequest)request).sendTo() != null) {
            InetAddress target = ((PrelocatedRequest)request).sendTo();
            for (Node node2 : nodes) {
                if (!node2.hostname().equals(target) || !this.checkNode(node2)) continue;
                node2.send(request);
                return;
            }
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        int nodeSize = nodes.size();
        for (i = offset = (int)this.counter++ % nodeSize; i < nodeSize; ++i) {
            node = nodes.get(i);
            if (!this.checkNode(node)) continue;
            node.send(request);
            return;
        }
        for (i = 0; i < offset; ++i) {
            node = nodes.get(i);
            if (!this.checkNode(node)) continue;
            node.send(request);
            return;
        }
        RetryHelper.retryOrCancel(env, request, responseBuffer);
    }

    protected boolean checkNode(Node node) {
        return node.serviceEnabled(ServiceType.QUERY);
    }
}

